/*
 * Decompiled with CFR 0.152.
 */
package xyz.uckystudio.ufireball;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import xyz.uckystudio.ufireball.bstats.Metrics;
import xyz.uckystudio.ufireball.tools.Hex;

public class uFireBall
extends JavaPlugin
implements Listener {
    private boolean requireLaunchPerms;
    private String launchPerms;
    private boolean cooldownEnabled;
    private int cooldownSeconds;
    private String cooldownBp;
    private HashMap<UUID, Long> cooldowns = new HashMap();

    public void onEnable() {
        this.saveDefaultConfig();
        this.requireLaunchPerms = this.getConfig().getBoolean("settings.launchPerms");
        this.launchPerms = this.getConfig().getString("settings.customPerms.launch");
        this.cooldownBp = this.getConfig().getString("settings.customPerms.cooldownBp");
        this.cooldownEnabled = this.getConfig().getBoolean("settings.cooldownEnable", true);
        this.cooldownSeconds = this.getConfig().getInt("settings.cooldown");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new Metrics(this, 20373);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        long timeLeft;
        Action action = event.getAction();
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        Long lastUsage = this.cooldowns.get(player.getUniqueId());
        if (lastUsage != null && !player.hasPermission(this.cooldownBp) && this.cooldownEnabled && (timeLeft = lastUsage + (long)(this.cooldownSeconds * 1000) - System.currentTimeMillis()) > 0L) {
            int secondsLeft = (int)(timeLeft / 1000L);
            player.sendMessage(Hex.hex(this.getConfig().getString("messages.cooldown")).replace("%cooldown%", String.valueOf(secondsLeft)));
            return;
        }
        if ((action.equals((Object)Action.RIGHT_CLICK_AIR) || action.equals((Object)Action.RIGHT_CLICK_BLOCK)) && itemInHand.getType() == Material.FIREBALL && (!this.requireLaunchPerms || player.hasPermission(this.launchPerms))) {
            event.getItem().setAmount(event.getItem().getAmount() - 1);
            player.updateInventory();
            Vector direction = player.getLocation().getDirection();
            Fireball fireball = (Fireball)player.launchProjectile(Fireball.class, direction);
            fireball.setShooter((ProjectileSource)player);
            if (this.cooldownEnabled && !player.hasPermission(this.cooldownBp)) {
                this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            }
        }
    }
}

