/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.Fireworks;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import org.bukkit.FireworkEffect;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.util.Handleable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperFireworks(class_9284 impl) implements Fireworks,
Handleable<class_9284>
{
    @Override
    public class_9284 getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<FireworkEffect> effects() {
        return MCUtil.transformUnmodifiable(this.impl.comp_2392(), CraftMetaFirework::getEffect);
    }

    public int flightDuration() {
        return this.impl.comp_2391();
    }

    static final class BuilderImpl
    implements Fireworks.Builder {
        private final List<class_9283> effects = new ObjectArrayList();
        private int duration = 0;

        BuilderImpl() {
        }

        public Fireworks.Builder flightDuration(int duration) {
            Preconditions.checkArgument((duration >= 0 && duration <= 255 ? 1 : 0) != 0, (String)"duration must be an unsigned byte ([%s, %s]), was %s", (Object)0, (Object)255, (Object)duration);
            this.duration = duration;
            return this;
        }

        public Fireworks.Builder addEffect(FireworkEffect effect) {
            Preconditions.checkArgument((this.effects.size() + 1 <= 256 ? 1 : 0) != 0, (String)"Cannot have more than %s effects, had %s", (int)256, (int)(this.effects.size() + 1));
            this.effects.add(CraftMetaFirework.getExplosion(effect));
            return this;
        }

        public Fireworks.Builder addEffects(List<FireworkEffect> effects) {
            Preconditions.checkArgument((this.effects.size() + effects.size() <= 256 ? 1 : 0) != 0, (String)"Cannot have more than %s effects, had %s", (int)256, (int)(this.effects.size() + effects.size()));
            MCUtil.addAndConvert(this.effects, effects, CraftMetaFirework::getExplosion);
            return this;
        }

        public Fireworks build() {
            return new PaperFireworks(new class_9284(this.duration, (List)new ObjectArrayList(this.effects)));
        }
    }
}

