/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.ItemContainerContents;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_9288;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.inventory.ItemStack;

public record PaperItemContainerContents(class_9288 impl) implements ItemContainerContents,
Handleable<class_9288>
{
    @Override
    public class_9288 getHandle() {
        return this.impl;
    }

    public List<ItemStack> contents() {
        return MCUtil.transformUnmodifiable(this.impl.field_49338, CraftItemStack::asBukkitCopy);
    }

    static final class BuilderImpl
    implements ItemContainerContents.Builder {
        private final List<class_1799> items = new ObjectArrayList();

        BuilderImpl() {
        }

        public ItemContainerContents.Builder add(ItemStack stack) {
            Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"Item cannot be null");
            Preconditions.checkArgument((this.items.size() + 1 <= 256 ? 1 : 0) != 0, (String)"Cannot have more than %s items, had %s", (int)256, (int)(this.items.size() + 1));
            this.items.add(CraftItemStack.asNMSCopy(stack));
            return this;
        }

        public ItemContainerContents.Builder addAll(List<ItemStack> stacks) {
            Preconditions.checkArgument((this.items.size() + stacks.size() <= 256 ? 1 : 0) != 0, (String)"Cannot have more than %s items, had %s", (int)256, (int)(this.items.size() + stacks.size()));
            MCUtil.addAndConvert(this.items, stacks, stack -> {
                Preconditions.checkArgument((stack != null ? 1 : 0) != 0, (Object)"Cannot pass null itemstacks!");
                return CraftItemStack.asNMSCopy(stack);
            });
            return this;
        }

        public ItemContainerContents build() {
            if (this.items.isEmpty()) {
                return new PaperItemContainerContents(class_9288.field_49334);
            }
            return new PaperItemContainerContents(class_9288.method_57493(this.items));
        }
    }
}

