/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item.blocksattacks;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.blocksattacks.DamageReduction;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.Optional;
import net.minecraft.class_10707;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.damage.DamageType;
import org.checkerframework.checker.index.qual.Positive;
import org.jspecify.annotations.Nullable;

public record PaperDamageReduction(class_10707.class_10708 impl) implements DamageReduction,
Handleable<class_10707.class_10708>
{
    @Override
    public class_10707.class_10708 getHandle() {
        return this.impl;
    }

    public @Nullable RegistryKeySet<DamageType> type() {
        return this.impl.comp_3592().map(set -> PaperRegistrySets.convertToApi(RegistryKey.DAMAGE_TYPE, set)).orElse(null);
    }

    public @Positive float horizontalBlockingAngle() {
        return this.impl.comp_3638();
    }

    public float base() {
        return this.impl.comp_3593();
    }

    public float factor() {
        return this.impl.comp_3594();
    }

    static final class BuilderImpl
    implements DamageReduction.Builder {
        private Optional<class_6885<class_8110>> type = Optional.empty();
        private float horizontalBlockingAngle = 90.0f;
        private float base = 0.0f;
        private float factor = 1.0f;

        BuilderImpl() {
        }

        public DamageReduction.Builder type(@Nullable RegistryKeySet<DamageType> type) {
            this.type = Optional.ofNullable(type).map(set -> PaperRegistrySets.convertToNms(class_7924.field_42534, Conversions.global().lookup(), set));
            return this;
        }

        public DamageReduction.Builder horizontalBlockingAngle(@Positive float horizontalBlockingAngle) {
            Preconditions.checkArgument((horizontalBlockingAngle > 0.0f ? 1 : 0) != 0, (String)"horizontalBlockingAngle must be positive and not zero, was %s", (Object)Float.valueOf(horizontalBlockingAngle));
            this.horizontalBlockingAngle = horizontalBlockingAngle;
            return this;
        }

        public DamageReduction.Builder base(float base) {
            this.base = base;
            return this;
        }

        public DamageReduction.Builder factor(float factor) {
            this.factor = factor;
            return this;
        }

        public DamageReduction build() {
            return new PaperDamageReduction(new class_10707.class_10708(this.horizontalBlockingAngle, this.type, this.base, this.factor));
        }
    }
}

