/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.set;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collection;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public record NamedRegistryKeySetImpl<T extends Keyed, M>(TagKey<T> tagKey, class_6885.class_6888<M> namedSet) implements io.papermc.paper.registry.tag.Tag<T>,
Tag<T>
{
    public NamedRegistryKeySetImpl(class_6885.class_6888<M> namedSet) {
        this(PaperRegistries.fromNms(namedSet.method_40251()), namedSet);
    }

    public @Unmodifiable Collection<TypedKey<T>> values() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_6880 holder : this.namedSet) {
            builder.add((Object)TypedKey.create((RegistryKey)this.tagKey.registryKey(), (Key)CraftNamespacedKey.fromMinecraft(((class_6880.class_6883)holder).method_40237().method_29177())));
        }
        return builder.build();
    }

    public RegistryKey<T> registryKey() {
        return this.tagKey.registryKey();
    }

    public boolean contains(TypedKey<T> valueKey) {
        return Iterables.any(this.namedSet, h -> PaperRegistries.fromNms(((class_6880.class_6883)h).method_40237()).equals((Object)valueKey));
    }

    public @Unmodifiable Collection<T> resolve(Registry<T> registry) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_6880 holder : this.namedSet) {
            builder.add((Object)registry.getOrThrow(CraftNamespacedKey.fromMinecraft(((class_6880.class_6883)holder).method_40237().method_29177())));
        }
        return builder.build();
    }

    public boolean isTagged(T item) {
        return this.getValues().contains(item);
    }

    public Set<T> getValues() {
        return Set.copyOf(this.resolve(RegistryAccess.registryAccess().getRegistry(this.registryKey())));
    }

    public NamespacedKey getKey() {
        Key key = this.tagKey().key();
        return new NamespacedKey(key.namespace(), key.value());
    }
}

