/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib;

import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.MethodSignature;
import net.techcable.srglib.SrgLib;

public final class MethodData {
    private final JavaType declaringType;
    private final String name;
    private final MethodSignature signature;
    private static final JavaType[] EMPTY_TYPE_ARRAY = new JavaType[0];

    private MethodData(JavaType declaringType, String name, MethodSignature signature) {
        this.declaringType = Objects.requireNonNull(declaringType, "Null declaring type");
        this.name = Objects.requireNonNull(name, "Null name");
        this.signature = Objects.requireNonNull(signature, "Null method descriptor");
        if (!SrgLib.isValidIdentifier(name)) {
            throw new IllegalArgumentException("Invalid method name: " + name);
        }
    }

    public JavaType getDeclaringType() {
        return this.declaringType;
    }

    public String getName() {
        return this.name;
    }

    public List<JavaType> getParameterTypes() {
        return this.signature.getParameterTypes();
    }

    public JavaType getReturnType() {
        return this.signature.getReturnType();
    }

    public String getInternalName() {
        return this.declaringType.getInternalName() + "/" + this.name;
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    public MethodData withSignature(MethodSignature signature) {
        if (signature.equals(this.signature)) {
            return this;
        }
        return MethodData.create(this.declaringType, this.name, signature);
    }

    public MethodData mapSignature(UnaryOperator<JavaType> transformer) {
        return this.withSignature(this.signature.mapTypes(transformer));
    }

    public MethodData mapTypes(UnaryOperator<JavaType> transformer) {
        return this.mapSignature(transformer).withDeclaringType((JavaType)transformer.apply(this.declaringType));
    }

    public boolean hasSameTypes(MethodData other) {
        Objects.requireNonNull(other, "Null other data!");
        return this.declaringType.equals(other.declaringType) && this.signature.equals(other.signature);
    }

    public MethodData withReturnType(JavaType returnType) {
        if (returnType.equals(this.getReturnType())) {
            return this;
        }
        return new MethodData(this.declaringType, this.name, this.signature);
    }

    public MethodData withName(String name) {
        if (name.equals(this.name)) {
            return this;
        }
        return new MethodData(this.declaringType, name, this.signature);
    }

    public MethodData withDeclaringType(JavaType declaringType) {
        if (declaringType.equals(this.declaringType)) {
            return this;
        }
        return new MethodData(declaringType, this.name, this.signature);
    }

    public int hashCode() {
        return this.declaringType.hashCode() ^ this.name.hashCode() ^ this.signature.hashCode();
    }

    public boolean equals(Object other) {
        return this == other || other != null && other.getClass() == MethodData.class && this.name.equals(((MethodData)other).name) && this.hasSameTypes((MethodData)other);
    }

    public String toString() {
        return this.declaringType.getName() + "." + this.name + this.signature.toString();
    }

    public static MethodData create(JavaType declaringType, String name, List<JavaType> parameterTypes, JavaType returnType) {
        return MethodData.create(declaringType, name, MethodSignature.create(parameterTypes, returnType));
    }

    public static MethodData create(JavaType declaringType, String name, MethodSignature signature) {
        return new MethodData(declaringType, name, signature);
    }

    public static MethodData fromInternalName(String joinedName, MethodSignature signature) {
        int index = joinedName.lastIndexOf(47);
        if (index < 0 || index >= joinedName.length() - 1) {
            throw new IllegalArgumentException("Invalid internal name: " + joinedName);
        }
        JavaType declaringType = JavaType.fromInternalName(joinedName.substring(0, index));
        String name = joinedName.substring(index + 1);
        return MethodData.create(declaringType, name, signature);
    }
}

