/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.PrimitiveType;
import net.techcable.srglib.utils.ImmutableLists;

public final class MethodSignature {
    private final List<JavaType> parameterTypes;
    private final JavaType returnType;
    private String descriptor;
    private int hash;

    private MethodSignature(List<JavaType> parameterTypes, JavaType returnType) {
        this.parameterTypes = Objects.requireNonNull(parameterTypes, "Null parameter types");
        this.returnType = Objects.requireNonNull(returnType, "Null return type");
        for (JavaType parameterType : parameterTypes) {
            if (parameterType != PrimitiveType.VOID) continue;
            throw new IllegalArgumentException("Void parameter!");
        }
    }

    public List<JavaType> getParameterTypes() {
        return this.parameterTypes;
    }

    public JavaType getReturnType() {
        return this.returnType;
    }

    public MethodSignature mapTypes(UnaryOperator<JavaType> transformer) {
        JavaType newReturnType = this.returnType.mapClass(transformer);
        List<JavaType> newParameterTypes = this.parameterTypes.stream().map(type -> type.mapClass(transformer)).collect(Collectors.toList());
        MethodSignature result = MethodSignature.create(newParameterTypes, newReturnType);
        if (result.equals(this)) {
            return this;
        }
        return result;
    }

    public String getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = ImmutableLists.joinToString(this.parameterTypes, JavaType::getDescriptor, "", "(", ")") + this.returnType.getDescriptor();
        }
        return this.descriptor;
    }

    public String toString() {
        return ImmutableLists.joinToString(this.parameterTypes, JavaType::getSimpleName, ",", "(", ")") + this.returnType.getSimpleName();
    }

    public int hashCode() {
        int hash = this.hash;
        if (hash == 0) {
            int n = hash = this.returnType == PrimitiveType.VOID ? 0 : this.returnType.hashCode();
            if (!this.parameterTypes.isEmpty()) {
                hash ^= this.parameterTypes.hashCode();
            }
            this.hash = hash;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj.getClass() == MethodSignature.class && this.hashCode() == obj.hashCode() && this.returnType.equals(((MethodSignature)obj).returnType) && this.parameterTypes.equals(((MethodSignature)obj).parameterTypes);
    }

    public static MethodSignature fromDescriptor(String descriptor) {
        if (descriptor.length() <= 2 && descriptor.charAt(0) != '(') {
            throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
        }
        int lastArgChar = descriptor.indexOf(41);
        if (lastArgChar < 0) {
            throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
        }
        LinkedList<JavaType> parameterTypes = new LinkedList<JavaType>();
        for (int index = 1; index < lastArgChar; ++index) {
            JavaType result;
            int arrayDimensions;
            char c = descriptor.charAt(index);
            if (c == '[') {
                int dimensions = 1;
                while ((c = descriptor.charAt(index + dimensions)) == '[') {
                    ++dimensions;
                }
                index += dimensions;
                arrayDimensions = dimensions;
            } else {
                arrayDimensions = 0;
            }
            if (c == 'L') {
                int endIndex = descriptor.indexOf(59, index);
                if (endIndex < 0 || endIndex >= lastArgChar) {
                    throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
                }
                String internalName = descriptor.substring(index + 1, endIndex);
                result = JavaType.fromInternalName(internalName);
                index = endIndex;
            } else {
                result = PrimitiveType.fromDescriptorChar(c);
            }
            parameterTypes.add(JavaType.createArray(arrayDimensions, result));
        }
        JavaType returnType = JavaType.fromDescriptor(descriptor.substring(lastArgChar + 1));
        return MethodSignature.create(parameterTypes, returnType);
    }

    public static MethodSignature create(List<JavaType> parameterTypes, JavaType returnType) {
        return new MethodSignature(parameterTypes, returnType);
    }
}

