/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class ImmutableLists {
    private ImmutableLists() {
    }

    public static <T, U> List<U> transform(List<T> original, Function<T, U> transformer) {
        int size = Objects.requireNonNull(original, "Null original list").size();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            T originalElement = original.get(i);
            U newElement = transformer.apply(originalElement);
            Objects.requireNonNull(newElement, "Transformer produced null value for input: " + originalElement);
            result[i] = newElement;
        }
        return Arrays.asList(result);
    }

    public static <T> String joinToString(List<T> list, Function<T, String> asString, String delimiter) {
        return ImmutableLists.joinToString(list, asString, delimiter, "", "");
    }

    public static <T> String joinToString(List<T> list, Function<T, String> asString, String delimiter, String prefix, String suffix) {
        int size = Objects.requireNonNull(list, "Null list").size();
        int delimiterLength = Objects.requireNonNull(delimiter, "Null delimiter").length();
        int prefixLength = Objects.requireNonNull(prefix, "Null prefix").length();
        int suffixLength = Objects.requireNonNull(suffix, "Null suffix").length();
        String[] strings = new String[size];
        int neededChars = prefixLength + suffixLength + Math.max(0, size - 1) * delimiterLength;
        for (int i = 0; i < size; ++i) {
            String str;
            T element = list.get(i);
            strings[i] = str = asString.apply(element);
            neededChars += str.length();
        }
        char[] result = new char[neededChars];
        int resultSize = 0;
        prefix.getChars(0, prefixLength, result, resultSize);
        resultSize += prefixLength;
        for (int i = 0; i < size; ++i) {
            String str = strings[i];
            if (i > 0) {
                delimiter.getChars(0, delimiterLength, result, resultSize);
                resultSize += delimiterLength;
            }
            int length = str.length();
            str.getChars(0, length, result, resultSize);
            resultSize += length;
        }
        suffix.getChars(0, suffixLength, result, resultSize);
        assert (result.length == (resultSize += suffixLength));
        return String.valueOf(result);
    }
}

