/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_7924;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.inventory.CraftItemType;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.inventory.ItemType;
import org.cardboardpowered.impl.world.CraftWorld;
import org.cardboardpowered.interfaces.IBlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class CraftBlockType<B extends BlockData>
implements BlockType.Typed<B>,
Handleable<class_2248> {
    private final NamespacedKey key;
    private final class_2248 block;
    private final Class<B> blockDataClass;
    private final boolean interactable;

    public static Material minecraftToBukkit(class_2248 block) {
        return CraftMagicNumbers.getMaterial(block);
    }

    public static class_2248 bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getBlock(material);
    }

    public static BlockType minecraftToBukkitNew(class_2248 minecraft) {
        return (BlockType)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41254);
    }

    public static class_2248 bukkitToMinecraftNew(BlockType bukkit) {
        return (class_2248)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    private static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        boolean hasMethod;
        try {
            hasMethod = clazz.getDeclaredMethod(methodName, params) != null;
        }
        catch (NoSuchMethodException ex) {
            hasMethod = false;
        }
        return hasMethod;
    }

    private static boolean isInteractable(class_2248 block) {
        Class<?> clazz = block.getClass();
        boolean hasMethod = CraftBlockType.hasMethod(clazz, "useWithoutItem", class_2680.class, class_1937.class, class_2338.class, class_1657.class, class_3965.class) || CraftBlockType.hasMethod(clazz, "useItemOn", class_1799.class, class_2680.class, class_1937.class, class_2338.class, class_1657.class, class_1268.class, class_3965.class);
        boolean bl = hasMethod;
        if (!hasMethod && clazz.getSuperclass() != class_4970.class) {
            clazz = clazz.getSuperclass();
            hasMethod = CraftBlockType.hasMethod(clazz, "useWithoutItem", class_2680.class, class_1937.class, class_2338.class, class_1657.class, class_3965.class) || CraftBlockType.hasMethod(clazz, "useItemOn", class_1799.class, class_2680.class, class_1937.class, class_2338.class, class_1657.class, class_1268.class, class_3965.class);
        }
        return hasMethod;
    }

    public CraftBlockType(NamespacedKey key, class_2248 block) {
        this.key = key;
        this.block = block;
        this.blockDataClass = CraftBlockData.fromData(block.method_9564()).getClass().getInterfaces()[0];
        this.interactable = CraftBlockType.isInteractable(block);
    }

    @Override
    public class_2248 getHandle() {
        return this.block;
    }

    @NotNull
    public BlockType.Typed<BlockData> typed() {
        return this.typed(BlockData.class);
    }

    @NotNull
    public <Other extends BlockData> BlockType.Typed<Other> typed(@NotNull Class<Other> blockDataType) {
        if (blockDataType.isAssignableFrom(this.blockDataClass)) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type block type " + this.key.toString() + " to blockdata type " + blockDataType.getSimpleName());
    }

    public boolean hasItemType() {
        if (this == AIR) {
            return true;
        }
        return this.block.method_8389() != class_1802.field_8162;
    }

    @NotNull
    public ItemType getItemType() {
        if (this == AIR) {
            return ItemType.AIR;
        }
        class_1792 item = this.block.method_8389();
        Preconditions.checkArgument((item != class_1802.field_8162 ? 1 : 0) != 0, (String)"The block type %s has no corresponding item type", (Object)this.getKey());
        return CraftItemType.minecraftToBukkitNew(item);
    }

    public Class<B> getBlockDataClass() {
        return this.blockDataClass;
    }

    public B createBlockData() {
        return this.createBlockData((String)null);
    }

    public B createBlockData(Consumer<? super B> consumer) {
        B data = this.createBlockData();
        if (consumer != null) {
            consumer.accept(data);
        }
        return data;
    }

    public B createBlockData(String data) {
        return (B)CraftBlockData.newData((BlockType)this, data);
    }

    public boolean isSolid() {
        return this.block.method_9564().method_51366();
    }

    public boolean isAir() {
        return this.block.method_9564().method_26215();
    }

    public boolean isEnabledByFeature(@NotNull World world) {
        Preconditions.checkNotNull((Object)world, (Object)"World cannot be null");
        return this.getHandle().method_45382(((CraftWorld)world).getHandle().method_45162());
    }

    public boolean isFlammable() {
        return this.block.method_9564().method_50011();
    }

    public boolean isBurnable() {
        return false;
    }

    public boolean isOccluding() {
        return this.block.method_9564().method_26212((class_1922)class_2682.field_12294, class_2338.field_10980);
    }

    public boolean hasGravity() {
        return this.block instanceof class_2346;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public float getHardness() {
        return 0.0f;
    }

    public float getBlastResistance() {
        return this.block.method_9520();
    }

    public float getSlipperiness() {
        return this.block.method_9499();
    }

    public String getTranslationKey() {
        return this.block.method_63499();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.key);
    }

    public String translationKey() {
        return this.block.method_63499();
    }

    public boolean hasCollision() {
        return false;
    }

    public @Unmodifiable @NotNull Collection<B> createBlockDataStates() {
        ImmutableList possibleStates = this.block.method_9595().method_11662();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)possibleStates.size());
        for (class_2680 possibleState : possibleStates) {
            IBlockState cardboard_state = (IBlockState)possibleState;
            builder.add((Object)((BlockData)this.blockDataClass.cast(cardboard_state.createCraftBlockData())));
        }
        return builder.build();
    }
}

