/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.damage;

import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_6880;
import net.minecraft.class_8110;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.damage.CraftDamageType;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;

public class CraftDamageSource
implements DamageSource {
    private final class_1282 damageSource;
    private final DamageType damageType;

    public CraftDamageSource(class_1282 damageSource) {
        this.damageSource = damageSource;
        this.damageType = CraftDamageType.minecraftHolderToBukkit((class_6880<class_8110>)damageSource.method_48793());
    }

    public class_1282 getHandle() {
        return this.damageSource;
    }

    public World getCausingEntityWorld() {
        Entity causingEntity = this.getCausingEntity();
        return causingEntity != null ? causingEntity.getWorld() : null;
    }

    public Block getDirectBlock() {
        return null;
    }

    public DamageType getDamageType() {
        return this.damageType;
    }

    public Entity getCausingEntity() {
        class_1297 entity = this.getHandle().method_5529();
        return entity != null ? entity.getBukkitEntity() : null;
    }

    public Entity getDirectEntity() {
        class_1297 entity = this.getHandle().method_5526();
        return entity != null ? entity.getBukkitEntity() : null;
    }

    public Location getDamageLocation() {
        class_243 vec3D = this.getHandle().method_48791();
        return vec3D != null ? CraftLocation.toBukkit(vec3D, this.getCausingEntityWorld()) : null;
    }

    public Location getSourceLocation() {
        class_243 vec3D = this.getHandle().method_5510();
        return vec3D != null ? CraftLocation.toBukkit(vec3D, this.getCausingEntityWorld()) : null;
    }

    public boolean isIndirect() {
        return this.getHandle().method_5529() != this.getHandle().method_5526();
    }

    public float getFoodExhaustion() {
        return this.damageType.getExhaustion();
    }

    public boolean scalesWithDifficulty() {
        return this.getHandle().method_5514();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DamageSource)) {
            return false;
        }
        DamageSource other = (DamageSource)obj;
        return Objects.equals(this.getDamageType(), other.getDamageType()) && Objects.equals(this.getCausingEntity(), other.getCausingEntity()) && Objects.equals(this.getDirectEntity(), other.getDirectEntity()) && Objects.equals(this.getDamageLocation(), other.getDamageLocation());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.damageType.hashCode();
        result = 31 * result + (this.getCausingEntity() != null ? this.getCausingEntity().hashCode() : 0);
        result = 31 * result + (this.getDirectEntity() != null ? this.getDirectEntity().hashCode() : 0);
        result = 31 * result + (this.getDamageLocation() != null ? this.getDamageLocation().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DamageSource{damageType=" + String.valueOf(this.getDamageType()) + ",causingEntity=" + String.valueOf(this.getCausingEntity()) + ",directEntity=" + String.valueOf(this.getDirectEntity()) + ",damageLocation=" + String.valueOf(this.getDamageLocation()) + "}";
    }

    public static DamageSource buildFromBukkit(DamageType damageType, Entity causingEntity, Entity directEntity, Location damageLocation) {
        class_6880<class_8110> holderDamageType = CraftDamageType.bukkitToMinecraftHolder(damageType);
        class_1297 nmsCausingEntity = null;
        if (causingEntity instanceof CraftEntity) {
            CraftEntity craftCausingEntity = (CraftEntity)causingEntity;
            nmsCausingEntity = craftCausingEntity.getHandle();
        }
        class_1297 nmsDirectEntity = null;
        if (directEntity instanceof CraftEntity) {
            CraftEntity craftDirectEntity = (CraftEntity)directEntity;
            nmsDirectEntity = craftDirectEntity.getHandle();
        }
        class_243 vec3D = damageLocation == null ? null : CraftLocation.toVec3D(damageLocation);
        class_1282 sor = new class_1282(holderDamageType, nmsDirectEntity, nmsCausingEntity);
        return new CraftDamageSource(sor);
    }
}

