/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.view.builder;

import com.google.common.base.Preconditions;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3917;
import org.bukkit.Location;
import org.bukkit.craftbukkit.inventory.view.builder.CraftAbstractInventoryViewBuilder;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.LocationInventoryViewBuilder;
import org.cardboardpowered.impl.world.CraftWorld;
import org.jspecify.annotations.Nullable;

public abstract class CraftAbstractLocationInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractInventoryViewBuilder<V>
implements LocationInventoryViewBuilder<V> {
    protected @Nullable class_1937 world;
    protected @Nullable class_2338 position;

    public CraftAbstractLocationInventoryViewBuilder(class_3917<?> handle) {
        super(handle);
    }

    @Override
    public LocationInventoryViewBuilder<V> title(Component title) {
        return (LocationInventoryViewBuilder)super.title(title);
    }

    public LocationInventoryViewBuilder<V> copy() {
        throw new UnsupportedOperationException("copy is not implemented on CraftAbstractLocationInventoryViewBuilder");
    }

    public LocationInventoryViewBuilder<V> checkReachable(boolean checkReachable) {
        this.checkReachable = checkReachable;
        return this;
    }

    public LocationInventoryViewBuilder<V> location(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"The provided location must not be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"The provided location must be associated with a world");
        this.world = ((CraftWorld)location.getWorld()).getHandle();
        this.position = CraftLocation.toBlockPosition(location);
        return this;
    }
}

