/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.potion;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Supplier;
import me.isaiah.common.ICommonMod;
import net.minecraft.class_1842;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.cardboardpowered.impl.CardboardPotionUtil;

public class CraftPotionType
implements PotionType.InternalPotionData {
    private final NamespacedKey key;
    private final class_1842 potion;
    private final Supplier<List<PotionEffect>> potionEffects;
    private final Supplier<Boolean> upgradeable;
    private final Supplier<Boolean> extendable;
    private final Supplier<Integer> maxLevel;

    public static PotionType minecraftHolderToBukkit(class_6880<class_1842> minecraft) {
        return CraftPotionType.minecraftToBukkit((class_1842)minecraft.comp_349());
    }

    public static PotionType minecraftToBukkit(class_1842 minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_41215);
        PotionType bukkit = (PotionType)Registry.POTION.get(CraftNamespacedKey.fromMinecraft(((class_5321)registry.method_29113((Object)minecraft).orElseThrow()).method_29177()));
        return bukkit;
    }

    public static class_1842 bukkitToMinecraft(PotionType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (class_1842)CraftRegistry.getMinecraftRegistry(class_7924.field_41215).method_17966(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static class_6880<class_1842> bukkitToMinecraftHolder(PotionType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        class_2378 registry = ICommonMod.getIServer().getMinecraft().method_30611().method_30530(class_7924.field_41215);
        class_6880 class_68802 = registry.method_47983((Object)CraftPotionType.bukkitToMinecraft(bukkit));
        if (class_68802 instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public static String bukkitToString(PotionType potionType) {
        Preconditions.checkArgument((potionType != null ? 1 : 0) != 0);
        return potionType.getKey().toString();
    }

    public static PotionType stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        return (PotionType)Registry.POTION.get(NamespacedKey.fromString((String)string));
    }

    public CraftPotionType(NamespacedKey key, class_1842 potion) {
        this.key = key;
        this.potion = potion;
        this.potionEffects = Suppliers.memoize(() -> potion.method_8049().stream().map(CardboardPotionUtil::toBukkit).toList());
        this.upgradeable = Suppliers.memoize(() -> Registry.POTION.get(new NamespacedKey(key.getNamespace(), "strong_" + key.getKey())) != null);
        this.extendable = Suppliers.memoize(() -> Registry.POTION.get(new NamespacedKey(key.getNamespace(), "long_" + key.getKey())) != null);
        this.maxLevel = Suppliers.memoize(() -> this.isUpgradeable() ? 2 : 1);
    }

    public PotionEffectType getEffectType() {
        return this.getPotionEffects().isEmpty() ? null : this.getPotionEffects().get(0).getType();
    }

    public List<PotionEffect> getPotionEffects() {
        return this.potionEffects.get();
    }

    public boolean isInstant() {
        return this.potion.method_8050();
    }

    public boolean isUpgradeable() {
        return this.upgradeable.get();
    }

    public boolean isExtendable() {
        return this.extendable.get();
    }

    public int getMaxLevel() {
        return this.maxLevel.get();
    }
}

