/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scheduler;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.craftbukkit.scheduler.BukkitTaskImpl;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitWorker;

public class AsyncTaskImpl
extends BukkitTaskImpl {
    private final LinkedList<BukkitWorker> workers = new LinkedList();
    private final Map<Integer, BukkitTaskImpl> runners;

    AsyncTaskImpl(Map<Integer, BukkitTaskImpl> runners, Plugin plugin, Object task, int id, long delay) {
        super(plugin, task, id, delay);
        this.runners = runners;
    }

    @Override
    public boolean isSync() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final Thread thread = Thread.currentThread();
        LinkedList<BukkitWorker> linkedList = this.workers;
        synchronized (linkedList) {
            if (this.getPeriod() == -2L) {
                return;
            }
            this.workers.add(new BukkitWorker(){

                public Thread getThread() {
                    return thread;
                }

                public int getTaskId() {
                    return AsyncTaskImpl.this.getTaskId();
                }

                public Plugin getOwner() {
                    return AsyncTaskImpl.this.getOwner();
                }
            });
        }
        Throwable thrown = null;
        try {
            super.run();
        }
        catch (Throwable t) {
            thrown = t;
            this.getOwner().getLogger().log(Level.WARNING, "Plugin " + this.getOwner().getDescription().getFullName() + " generated an exception while executing task " + this.getTaskId(), thrown);
        }
        finally {
            LinkedList<BukkitWorker> linkedList2 = this.workers;
            synchronized (linkedList2) {
                try {
                    Iterator workers = this.workers.iterator();
                    boolean removed = false;
                    while (workers.hasNext()) {
                        if (((BukkitWorker)workers.next()).getThread() != thread) continue;
                        workers.remove();
                        removed = true;
                        break;
                    }
                    if (!removed) {
                        throw new IllegalStateException("Unable to remove worker " + thread.getName() + " on task " + this.getTaskId() + " for " + this.getOwner().getDescription().getFullName(), thrown);
                    }
                }
                finally {
                    if (this.getPeriod() < 0L && this.workers.isEmpty()) {
                        this.runners.remove(this.getTaskId());
                    }
                }
            }
        }
    }

    LinkedList<BukkitWorker> getWorkers() {
        return this.workers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean cancel0() {
        LinkedList<BukkitWorker> linkedList = this.workers;
        synchronized (linkedList) {
            this.setPeriod(-2L);
            if (this.workers.isEmpty()) {
                this.runners.remove(this.getTaskId());
            }
        }
        return true;
    }
}

