/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_3176;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import org.bukkit.BanEntry;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.craftbukkit.CraftServer;
import org.cardboardpowered.impl.CraftProfileBanEntry;

public class CraftProfileBanList
implements ProfileBanList {
    private final class_3335 list;

    public CraftProfileBanList(class_3335 list) {
        this.list = list;
    }

    public BanEntry<PlayerProfile> getBanEntry(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.getBanEntry(CraftProfileBanList.getProfile(target));
    }

    public BanEntry<PlayerProfile> getBanEntry(org.bukkit.profile.PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.getBanEntry(new class_11560(((SharedPlayerProfile)target).buildGameProfile()));
    }

    public BanEntry<PlayerProfile> getBanEntry(PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target cannot be null");
        return this.getBanEntry(new class_11560(((SharedPlayerProfile)target).buildGameProfile()));
    }

    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"PlayerProfile cannot be null");
        Preconditions.checkArgument((target.getId() != null ? 1 : 0) != 0, (Object)"The PlayerProfile UUID cannot be null");
        return this.addBan(new class_11560(((SharedPlayerProfile)target).buildGameProfile()), reason, expires, source);
    }

    public boolean isBanned(PlayerProfile target) {
        return this.isBanned((SharedPlayerProfile)target);
    }

    public void pardon(PlayerProfile target) {
        this.pardon((SharedPlayerProfile)target);
    }

    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Instant expires, String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Duration duration, String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    public BanEntry<PlayerProfile> addBan(String target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Ban target cannot be null");
        return this.addBan(CraftProfileBanList.getProfileByName(target), reason, expires, source);
    }

    public BanEntry<PlayerProfile> addBan(org.bukkit.profile.PlayerProfile target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"PlayerProfile cannot be null");
        Preconditions.checkArgument((target.getUniqueId() != null ? 1 : 0) != 0, (Object)"The PlayerProfile UUID cannot be null");
        return this.addBan(new class_11560(((SharedPlayerProfile)target).buildGameProfile()), reason, expires, source);
    }

    public BanEntry<PlayerProfile> addBan(org.bukkit.profile.PlayerProfile target, String reason, Instant expires, String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    public BanEntry<PlayerProfile> addBan(org.bukkit.profile.PlayerProfile target, String reason, Duration duration, String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_3336 entry : this.list.method_14632()) {
            class_11560 profile = (class_11560)entry.method_14626();
            builder.add((Object)new CraftProfileBanEntry(profile, entry, this.list));
        }
        return builder.build();
    }

    public Set<BanEntry<PlayerProfile>> getEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_3336 entry : this.list.method_14632()) {
            class_11560 profile = (class_11560)entry.method_14626();
            builder.add((Object)new CraftProfileBanEntry(profile, entry, this.list));
        }
        return builder.build();
    }

    public boolean isBanned(org.bukkit.profile.PlayerProfile target) {
        return this.isBanned((SharedPlayerProfile)target);
    }

    private boolean isBanned(SharedPlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.isBanned(new class_11560(target.buildGameProfile()));
    }

    public boolean isBanned(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.isBanned(CraftProfileBanList.getProfile(target));
    }

    public void pardon(org.bukkit.profile.PlayerProfile target) {
        this.pardon((SharedPlayerProfile)target);
    }

    private void pardon(SharedPlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.pardon(new class_11560(target.buildGameProfile()));
    }

    public void pardon(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.pardon(CraftProfileBanList.getProfile(target));
    }

    public BanEntry<PlayerProfile> getBanEntry(class_11560 profile) {
        if (profile == null) {
            return null;
        }
        class_3336 entry = (class_3336)this.list.method_14640((Object)profile);
        return entry == null ? null : new CraftProfileBanEntry(profile, entry, this.list);
    }

    public BanEntry<PlayerProfile> addBan(class_11560 profile, String reason, Date expires, String source) {
        if (profile == null) {
            return null;
        }
        class_3336 entry = new class_3336(profile, new Date(), source != null && !source.isBlank() ? source : null, expires, reason != null && !reason.isBlank() ? reason : null);
        this.list.method_74006(entry);
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    private void pardon(class_11560 profile) {
        this.list.method_74007(profile);
    }

    private boolean isBanned(class_11560 profile) {
        return profile != null && this.list.method_14650(profile);
    }

    static class_11560 getProfile(String target) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(target);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uuid != null ? CraftProfileBanList.getProfileByUUID(uuid) : CraftProfileBanList.getProfileByName(target);
    }

    static class_11560 getProfileByUUID(UUID uuid) {
        class_3176 server = CraftServer.server;
        return server != null ? (class_11560)server.method_73550().comp_4407().method_14512(uuid).orElse(null) : null;
    }

    static class_11560 getProfileByName(String name) {
        class_3176 server = CraftServer.server;
        return server != null ? (class_11560)server.method_73550().comp_4407().method_14515(name).orElse(null) : null;
    }
}

