/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import me.isaiah.common.ICommonMod;
import me.isaiah.common.cmixin.IMixinMinecraftServer;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2586;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.persistence.PersistentDataContainer;
import org.cardboardpowered.impl.world.CraftWorld;
import org.cardboardpowered.interfaces.IMixinBlockEntity;
import org.slf4j.Logger;

public abstract class CardboardBlockEntityState<T extends class_2586>
extends CraftBlockState
implements TileState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final T tileEntity;
    private final T snapshot;
    public boolean snapshotDisabled;
    public static boolean DISABLE_SNAPSHOT = false;

    public CardboardBlockEntityState(World world, T tileEntity) {
        super(world, tileEntity.method_11016(), tileEntity.method_11010());
        this.tileEntity = tileEntity;
        try {
            this.snapshotDisabled = DISABLE_SNAPSHOT;
            T t = this.snapshot = DISABLE_SNAPSHOT ? this.tileEntity : this.createSnapshot(tileEntity);
            if (this.snapshot != null) {
                this.load(this.snapshot);
            }
        }
        catch (Throwable thr) {
            if (thr instanceof ThreadDeath) {
                throw (ThreadDeath)thr;
            }
            throw new RuntimeException("Failed to read BlockState at: world: " + this.getWorld().getName() + " location: (" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")", thr);
        }
    }

    protected CardboardBlockEntityState(CardboardBlockEntityState<T> state, Location location) {
        super(state, location);
        this.tileEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.tileEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public void loadData(class_2487 tag) {
        try (class_8942.class_11340 problemReporter = new class_8942.class_11340(() -> "CraftBlockEntityState@" + this.getPosition().method_23854(), LOGGER);){
            this.snapshot.method_58690(class_11352.method_71417((class_8942)problemReporter, (class_7225.class_7874)ICommonMod.getIServer().getMinecraft().method_30611(), (class_2487)tag));
        }
        this.load(this.snapshot);
    }

    public class_5455 getRegistryAccess() {
        class_1936 worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.method_30349() : CraftRegistry.getMinecraftRegistry();
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        me.isaiah.common.cmixin.IMixinBlockEntity ic = (me.isaiah.common.cmixin.IMixinBlockEntity)tileEntity;
        class_2487 nbtTagCompound = ic.I_createNbtWithIdentifyingData();
        IMixinMinecraftServer mc = (IMixinMinecraftServer)ICommonMod.getIServer().getMinecraft();
        class_2586 snapshot = mc.IC$create_blockentity_from_nbt(this.getPosition(), this.data, nbtTagCompound);
        return (T)snapshot;
    }

    public void applyComponents(class_9323 datacomponentmap, class_9326 datacomponentpatch) {
        this.snapshot.method_58685(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
    }

    public class_2487 getSnapshotCustomNbtOnly() {
        this.applyTo(this.snapshot);
        try (class_8942.class_11340 problemReporter = new class_8942.class_11340(() -> "CraftBlockEntityState@" + this.getPosition().method_23854(), LOGGER);){
            class_2487 nbtCompound;
            class_11362 output = CardboardBlockEntityState.createWrappingWithContext(problemReporter, this.getRegistryAccess(), this.snapshot.method_58692((class_7225.class_7874)this.getRegistryAccess()));
            this.snapshot.method_57569((class_11372)output);
            if (!output.method_71457()) {
                this.snapshot.method_38241((class_11372)output);
            }
            class_2487 class_24872 = nbtCompound = output.method_71475();
            return class_24872;
        }
    }

    public static class_11362 createWrappingWithContext(class_8942.class_11340 problemReporter, class_5455 lookup, class_2487 compoundTag) {
        return new class_11362((class_8942)problemReporter, (DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), compoundTag);
    }

    public class_9323 collectComponents() {
        return this.snapshot.method_57590();
    }

    private void copyData(T from, T to) {
        class_2338 pos = to.method_11016();
        me.isaiah.common.cmixin.IMixinBlockEntity ic = (me.isaiah.common.cmixin.IMixinBlockEntity)this.tileEntity;
        class_2487 nbtTagCompound = ic.I_createNbtWithIdentifyingData();
        to.method_31664(this.data);
        me.isaiah.common.cmixin.IMixinBlockEntity ic2 = (me.isaiah.common.cmixin.IMixinBlockEntity)to;
        ic2.IC$read_nbt(nbtTagCompound);
        ((class_2586)to).field_11867 = pos;
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    public T getSnapshot() {
        return this.snapshot;
    }

    protected class_2586 getTileEntityFromWorld() {
        this.requirePlaced();
        return ((CraftWorld)this.getWorld()).getHandle().method_8321(this.getPosition());
    }

    public class_2487 getSnapshotNBT() {
        this.applyTo(this.snapshot);
        me.isaiah.common.cmixin.IMixinBlockEntity ic = (me.isaiah.common.cmixin.IMixinBlockEntity)this.snapshot;
        return ic.I_createNbtWithIdentifyingData();
    }

    public void load(T blockEntity) {
        if (this.tileEntity != null && this.tileEntity != this.snapshot) {
            this.copyData(blockEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    public boolean isApplicable(class_2586 tileEntity) {
        return tileEntity != null && this.tileEntity.getClass() == tileEntity.getClass();
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        class_2586 tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo(tile);
            tile.method_5431();
        }
        return result;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return ((IMixinBlockEntity)this.getSnapshot()).getPersistentDataContainer();
    }

    @Override
    public abstract CardboardBlockEntityState<T> copy();

    @Override
    public abstract CardboardBlockEntityState<T> copy(Location var1);

    public boolean isSnapshot() {
        return !this.snapshotDisabled;
    }
}

