/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.command;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ModsCommand
extends Command {
    public ModsCommand(String name) {
        super(name);
        this.description = "Gets the version of this server including any plugins in use";
        this.usageMessage = "/fabricmods";
        List<String> aka = Arrays.asList("mymods", "mods");
        this.setAliases(aka);
        this.setPermission("cardboard.command.mods");
    }

    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (sender.hasPermission("cardboard.command.mods")) {
            Object mods = "";
            int count = 0;
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                String name = mod.getMetadata().getName();
                if (name.startsWith("Fabric") && name.endsWith(")")) continue;
                if (name.startsWith("Fabric API Base")) {
                    name = "Fabric API";
                }
                if (name.startsWith("OpenJDK") || name.startsWith("SpecialSource") || name.startsWith("Fabric Convention Tags") || name.startsWith("MixinExtras") || name.contains("-bundle") || ((String)mods).contains(name)) continue;
                mods = (String)mods + ", " + String.valueOf(ChatColor.GREEN) + name + String.valueOf(ChatColor.WHITE);
                ++count;
            }
            sender.sendMessage("Mods (" + count + "): " + ((String)mods).substring(2));
        } else {
            sender.sendMessage("No Permission for command! Missing permission: cardboard.command.mods");
        }
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        return ImmutableList.of();
    }
}

