/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.mixin.network;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import io.netty.channel.local.LocalAddress;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.PaperPlayerLoginConnection;
import io.papermc.paper.connection.PlayerConnection;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.minecraft.class_11560;
import net.minecraft.class_140;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2901;
import net.minecraft.class_2907;
import net.minecraft.class_2909;
import net.minecraft.class_2915;
import net.minecraft.class_2917;
import net.minecraft.class_3222;
import net.minecraft.class_3248;
import net.minecraft.class_3324;
import net.minecraft.class_3515;
import net.minecraft.class_4844;
import net.minecraft.class_5525;
import net.minecraft.class_7648;
import net.minecraft.class_8593;
import net.minecraft.class_8610;
import net.minecraft.class_8792;
import net.minecraft.class_9157;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.cardboardpowered.extras.PlayerManager_LoginResult;
import org.cardboardpowered.interfaces.IMixinClientConnection;
import org.cardboardpowered.interfaces.IMixinPlayerManager;
import org.cardboardpowered.interfaces.IMixinServerLoginNetworkHandler;
import org.cardboardpowered.interfaces.INetworkConfiguration;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3248.class}, priority=999)
public abstract class MixinServerLoginNetworkHandler
implements IMixinServerLoginNetworkHandler {
    private static Logger LOGGER_BF = LoggerFactory.getLogger((String)"PaperMC|ServerLoginNetworkHandler");
    private static final ExecutorService authenticatorPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("User Authenticator #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER_BF)).build());
    @Shadow
    @Nullable
    private String field_45028;
    @Shadow
    private byte[] field_14167 = new byte[4];
    @Shadow
    private MinecraftServer field_14162;
    @Shadow
    public class_2535 field_14158;
    @Shadow
    private class_3248.class_3249 field_14163;
    @Shadow
    private GameProfile field_45029;
    @Shadow
    private static AtomicInteger field_14157;
    public class_3222 delayedPlayer;
    public String hostname = "";
    private long theid = 0L;
    private class_3222 player;
    public UUID requestedUuid;
    private PaperPlayerLoginConnection paperLoginConnection1;
    private class_3222 cardboard_player;
    @Shadow
    private boolean field_48275;

    @Shadow
    abstract void method_52417(GameProfile var1);

    @Override
    public class_2535 cb_get_connection() {
        return this.field_14158;
    }

    private PaperPlayerLoginConnection paperLoginConnection() {
        if (null == this.paperLoginConnection1) {
            this.paperLoginConnection1 = new PaperPlayerLoginConnection((class_3248)this);
        }
        return this.paperLoginConnection1;
    }

    @Inject(at={@At(value="HEAD")}, method={"onHello"})
    public void cardboard$setRequestedUuid(class_2915 packet, CallbackInfo ci) {
        this.requestedUuid = packet.comp_907();
    }

    @Override
    public UUID cardboard$requestedUuid() {
        return this.requestedUuid;
    }

    @Override
    public String cardboard$profileName() {
        return this.field_45028;
    }

    @Override
    public boolean cardboard$transferred() {
        return this.field_48275;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHostname(String s) {
        this.hostname = s;
    }

    @Overwrite
    public void method_12642(class_2917 packet) {
        String string;
        Validate.validState((this.field_14163 == class_3248.class_3249.field_14175 ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey _private = this.field_14162.method_3716().getPrivate();
            if (!packet.method_43643(this.field_14167, _private)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretKey = packet.method_12654(_private);
            Cipher cipher = class_3515.method_15235((int)2, (Key)secretKey);
            Cipher cipher1 = class_3515.method_15235((int)1, (Key)secretKey);
            string = new BigInteger(class_3515.method_15240((String)"", (PublicKey)this.field_14162.method_3716().getPublic(), (SecretKey)secretKey)).toString(16);
            this.field_14163 = class_3248.class_3249.field_14169;
            this.field_14158.method_10746(cipher, cipher1);
        }
        catch (class_5525 var5) {
            throw new IllegalStateException("Protocol error", var5);
        }
        authenticatorPool.execute(new Runnable(){

            @Override
            public void run() {
                String string1 = Objects.requireNonNull(MixinServerLoginNetworkHandler.this.field_45028, "Player name not initialized");
                try {
                    ProfileResult profileResult = MixinServerLoginNetworkHandler.this.field_14162.method_73550().comp_837().hasJoinedServer(string1, string, this.getClientAddress());
                    if (profileResult != null) {
                        GameProfile gameProfile = profileResult.profile();
                        if (!MixinServerLoginNetworkHandler.this.field_14158.method_10758()) {
                            return;
                        }
                        gameProfile = MixinServerLoginNetworkHandler.this.callPlayerPreLoginEvents(gameProfile);
                        LOGGER_BF.info("UUID of player {} is {}", (Object)gameProfile.name(), (Object)gameProfile.id());
                        MixinServerLoginNetworkHandler.this.method_52417(gameProfile);
                    } else if (MixinServerLoginNetworkHandler.this.field_14162.method_3724()) {
                        LOGGER_BF.warn("Failed to verify username but will let them in anyway!");
                        MixinServerLoginNetworkHandler.this.method_52417(MixinServerLoginNetworkHandler.this.createOfflineProfile(string1));
                    } else {
                        MixinServerLoginNetworkHandler.this.method_14380((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.unverified_username"));
                        LOGGER_BF.error("Username '{}' tried to join with an invalid session", (Object)string1);
                    }
                }
                catch (AuthenticationUnavailableException var4) {
                    if (MixinServerLoginNetworkHandler.this.field_14162.method_3724()) {
                        LOGGER_BF.warn("Authentication servers are down but will let them in anyway!");
                        MixinServerLoginNetworkHandler.this.method_52417(MixinServerLoginNetworkHandler.this.createOfflineProfile(string1));
                    } else {
                        MixinServerLoginNetworkHandler.this.method_14380(PaperAdventure.asVanilla((Component)Component.translatable((String)"multiplayer.disconnect.authservers_down")));
                        LOGGER_BF.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception var5) {
                    MixinServerLoginNetworkHandler.this.disconnect("Failed to verify username!");
                    LOGGER_BF.warn("Exception verifying {}", (Object)string1, (Object)var5);
                }
            }

            @Nullable
            private InetAddress getClientAddress() {
                SocketAddress remoteAddress = MixinServerLoginNetworkHandler.this.field_14158.method_10755();
                return MixinServerLoginNetworkHandler.this.field_14162.method_3775() && remoteAddress instanceof InetSocketAddress ? ((InetSocketAddress)remoteAddress).getAddress() : null;
            }
        });
    }

    protected GameProfile createOfflineProfile(String s) {
        return class_4844.method_54140((String)s);
    }

    private GameProfile callPlayerPreLoginEvents(GameProfile gameprofile) throws Exception {
        String playerName = gameprofile.name();
        InetAddress address = ((InetSocketAddress)this.field_14158.method_10755()).getAddress();
        UUID uniqueId = gameprofile.id();
        final CraftServer server = CraftServer.INSTANCE;
        InetAddress rawAddress = ((InetSocketAddress)this.field_14158.field_11651.remoteAddress()).getAddress();
        PlayerProfile profile = CraftPlayerProfile.asBukkitCopy(gameprofile);
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
        server.getPluginManager().callEvent((Event)asyncEvent);
        profile = asyncEvent.getPlayerProfile();
        profile.complete(true);
        gameprofile = CraftPlayerProfile.asAuthlibCopy(profile);
        playerName = gameprofile.name();
        uniqueId = gameprofile.id();
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.kickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(this){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent((Event)event);
                    return event.getResult();
                }
            };
            CraftServer.server.getProcessQueue().add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.method_14380(PaperAdventure.asVanilla(event.kickMessage()));
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.method_14380(PaperAdventure.asVanilla(asyncEvent.kickMessage()));
        }
        return gameprofile;
    }

    public void fireEvents(GameProfile profile) throws Exception {
        String playerName = profile.name();
        InetAddress address = this.field_14158.method_10755() instanceof LocalAddress ? InetAddress.getLocalHost() : ((InetSocketAddress)this.field_14158.method_10755()).getAddress();
        UUID uniqueId = profile.id();
        final CraftServer server = CraftServer.INSTANCE;
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
        server.getPluginManager().callEvent((Event)asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(this){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent((Event)event);
                    return event.getResult();
                }
            };
            CraftServer.server.getProcessQueue().add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.disconnect(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.disconnect(asyncEvent.getKickMessage());
            return;
        }
        LOGGER_BF.info("UUID of player {} is {}", (Object)profile.name(), (Object)profile.id());
        this.method_52417(profile);
    }

    public void disconnect(String s) {
        try {
            class_2561 text = class_2561.method_30163((String)s);
            LOGGER_BF.info("Disconnecting BUKKITFABRIC_TODO: " + s);
            this.field_14158.method_10743((class_2596)new class_2909(text));
            this.field_14158.method_10747(text);
        }
        catch (Exception exception) {
            LOGGER_BF.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    @Override
    public class_3222 cardboard$get_player() {
        if (null == this.player) {
            this.player = this.cardboard_player;
        }
        return this.player;
    }

    @Overwrite
    private void method_52419(GameProfile profile) {
        class_3222 s;
        class_3324 playerManager = this.field_14162.method_3760();
        class_2561 text = playerManager.method_14586(this.field_14158.method_10755(), new class_11560(profile));
        IMixinPlayerManager pm = (IMixinPlayerManager)this.field_14162.method_3760();
        PlayerManager_LoginResult paperizedResult = pm.cardboard$canPlayerLogin(text, new class_11560(profile));
        text = CraftEventFactory.handleLoginResult(paperizedResult, (PlayerConnection)this.paperLoginConnection(), this.field_14158, profile, this.field_14162, true);
        this.cardboard_player = s = pm.attemptLogin((class_3248)this, this.field_45029, null, this.hostname);
        this.player = s;
        if (text != null) {
            this.method_14380(text);
        } else {
            boolean bl;
            if (this.field_14162.method_3773() >= 0 && !this.field_14158.method_10756()) {
                this.field_14158.method_10752((class_2596)new class_2907(this.field_14162.method_3773()), class_7648.method_45084(() -> this.field_14158.method_10760(this.field_14162.method_3773(), true)));
            }
            if (bl = playerManager.method_52449(profile.id())) {
                this.field_14163 = class_3248.class_3249.field_45031;
            } else {
                this.method_52420(profile);
            }
        }
    }

    @Shadow
    private void method_52420(GameProfile profile) {
        this.field_14163 = class_3248.class_3249.field_45032;
        this.field_14158.method_10743((class_2596)new class_2901(profile));
    }

    @Inject(at={@At(value="TAIL")}, method={"onHello"})
    public void spigotHello(class_2915 packetlogininstart, CallbackInfo ci) {
        if (!this.field_14162.method_3828() || this.field_14158.method_10756()) {
            new Thread("User Authenticator #" + this.theid++){

                @Override
                public void run() {
                    try {
                        MixinServerLoginNetworkHandler.this.initUUID();
                        MixinServerLoginNetworkHandler.this.fireEvents(MixinServerLoginNetworkHandler.this.field_45029);
                    }
                    catch (Exception ex) {
                        MixinServerLoginNetworkHandler.this.disconnect("Failed to verify username!");
                        CraftServer.INSTANCE.getLogger().log(Level.WARNING, "Exception verifying " + MixinServerLoginNetworkHandler.this.field_45029.name(), ex);
                    }
                }
            }.start();
        }
    }

    public void initUUID() {
        UUID uuid = ((IMixinClientConnection)this.field_14158).getSpoofedUUID() != null ? ((IMixinClientConnection)this.field_14158).getSpoofedUUID() : class_4844.method_43344((String)this.field_45029.name());
        this.field_45029 = new GameProfile(uuid, this.field_45029.name());
        if (((IMixinClientConnection)this.field_14158).getSpoofedProfile() != null) {
            for (Property property : ((IMixinClientConnection)this.field_14158).getSpoofedProfile()) {
                this.field_45029.properties().put((Object)property.name(), (Object)property);
            }
        }
    }

    @Overwrite
    public void method_52289(class_8593 packet) {
        Validate.validState((this.field_14163 == class_3248.class_3249.field_45032 ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        this.field_14158.method_56329(class_9157.field_48699);
        class_8792 commonlistenercookie = class_8792.method_53824((GameProfile)Objects.requireNonNull(this.field_45029), (boolean)this.field_48275);
        class_8610 networkConfig = new class_8610(this.field_14162, this.field_14158, commonlistenercookie);
        if (this.cardboard_player != null) {
            ((INetworkConfiguration)networkConfig).cardboard_setPlayer(this.cardboard_player);
        }
        this.field_14158.method_56330(class_9157.field_48698, (class_2547)networkConfig);
        networkConfig.method_52409();
        this.field_14163 = class_3248.class_3249.field_14172;
    }

    @Shadow
    public void method_14380(class_2561 t) {
    }
}

