/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent;

import io.papermc.paper.datacomponent.DataComponentAdapter;
import io.papermc.paper.datacomponent.DataComponentAdapters;
import io.papermc.paper.datacomponent.DataComponentType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.Handleable;
import org.jspecify.annotations.Nullable;

public abstract class PaperDataComponentType<T, NMS>
implements DataComponentType,
Handleable<class_9331<NMS>> {
    private final NamespacedKey key;
    private final class_9331<NMS> type;
    private final DataComponentAdapter<NMS, T> adapter;

    public static <T> class_9331<T> bukkitToMinecraft(DataComponentType type) {
        return (class_9331)CraftRegistry.bukkitToMinecraft(type);
    }

    public static DataComponentType minecraftToBukkit(class_9331<?> type) {
        return (DataComponentType)CraftRegistry.minecraftToBukkit(type, class_7924.field_49659);
    }

    public static Set<DataComponentType> minecraftToBukkit(Set<class_9331<?>> nmsTypes) {
        HashSet<DataComponentType> types = new HashSet<DataComponentType>(nmsTypes.size());
        for (class_9331<?> nmsType : nmsTypes) {
            types.add(PaperDataComponentType.minecraftToBukkit(nmsType));
        }
        return Collections.unmodifiableSet(types);
    }

    public static <B, M> @Nullable B convertDataComponentValue(class_9323 map, ValuedImpl<B, M> type) {
        class_9331 nms = PaperDataComponentType.bukkitToMinecraft(type);
        Object nmsValue = map.method_58694(nms);
        if (nmsValue == null) {
            return null;
        }
        return (B)type.getAdapter().fromVanilla(nmsValue);
    }

    public PaperDataComponentType(NamespacedKey key, class_9331<NMS> type, DataComponentAdapter<NMS, T> adapter) {
        this.key = key;
        this.type = type;
        this.adapter = adapter;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public boolean isPersistent() {
        return !this.type.method_57877();
    }

    public DataComponentAdapter<NMS, T> getAdapter() {
        return this.adapter;
    }

    @Override
    public class_9331<NMS> getHandle() {
        return this.type;
    }

    public static <NMS> DataComponentType of(NamespacedKey key, class_9331<NMS> type) {
        DataComponentAdapter<?, ?> adapter = DataComponentAdapters.ADAPTERS.get(class_7923.field_49658.method_29113(type).orElseThrow());
        if (adapter == null) {
            throw new IllegalArgumentException("No adapter found for " + String.valueOf(key));
        }
        if (adapter.isValued()) {
            return new ValuedImpl(key, type, adapter);
        }
        return new NonValuedImpl(key, type, adapter);
    }

    static {
        DataComponentAdapters.bootstrap();
    }

    public static final class ValuedImpl<T, NMS>
    extends PaperDataComponentType<T, NMS>
    implements DataComponentType.Valued<T> {
        ValuedImpl(NamespacedKey key, class_9331<NMS> type, DataComponentAdapter<NMS, T> adapter) {
            super(key, type, adapter);
        }
    }

    public static final class NonValuedImpl<T, NMS>
    extends PaperDataComponentType<T, NMS>
    implements DataComponentType.NonValued {
        NonValuedImpl(NamespacedKey key, class_9331<NMS> type, DataComponentAdapter<NMS, T> adapter) {
            super(key, type, adapter);
        }
    }
}

