/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.attribute.AttributeModifierDisplay;
import io.papermc.paper.datacomponent.item.attribute.PaperAttributeModifierDisplay;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1320;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.Unmodifiable;

public record PaperItemAttributeModifiers(class_9285 impl) implements ItemAttributeModifiers,
Handleable<class_9285>
{
    private static List<ItemAttributeModifiers.Entry> convert(class_9285 nmsModifiers) {
        return MCUtil.transformUnmodifiable(nmsModifiers.comp_2393(), nms -> new PaperEntry(CraftAttribute.minecraftHolderToBukkit((class_6880<class_1320>)nms.comp_2395()), CraftAttributeInstance.convert(nms.comp_2396(), nms.comp_2397()), PaperAttributeModifierDisplay.fromNms(nms.comp_4036())));
    }

    @Override
    public class_9285 getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    ItemAttributeModifiers.Entry> modifiers() {
        return PaperItemAttributeModifiers.convert(this.impl);
    }

    public record PaperEntry(Attribute attribute, AttributeModifier modifier, AttributeModifierDisplay display) implements ItemAttributeModifiers.Entry
    {
    }

    static final class BuilderImpl
    implements ItemAttributeModifiers.Builder {
        private final List<class_9285.class_9287> entries = new ObjectArrayList();

        BuilderImpl() {
        }

        public ItemAttributeModifiers.Builder addModifier(Attribute attribute, AttributeModifier modifier) {
            return this.addModifier(attribute, modifier, modifier.getSlotGroup());
        }

        public ItemAttributeModifiers.Builder addModifier(Attribute attribute, AttributeModifier modifier, EquipmentSlotGroup equipmentSlotGroup) {
            Preconditions.checkArgument((boolean)this.entries.stream().noneMatch(e -> e.comp_2396().comp_2447().equals((Object)CraftNamespacedKey.toMinecraft(modifier.getKey())) && e.comp_2395().method_40226(CraftNamespacedKey.toMinecraft(attribute.getKey()))), (String)"Cannot add 2 modifiers with identical keys on the same attribute (modifier %s for attribute %s)", (Object)modifier.getKey(), (Object)attribute.getKey());
            this.entries.add(new class_9285.class_9287(CraftAttribute.bukkitToMinecraftHolder(attribute), CraftAttributeInstance.convert(modifier), CraftEquipmentSlot.getNMSGroup(equipmentSlotGroup)));
            return this;
        }

        public ItemAttributeModifiers.Builder addModifier(Attribute attribute, AttributeModifier modifier, EquipmentSlotGroup equipmentSlotGroup, AttributeModifierDisplay display) {
            Preconditions.checkArgument((boolean)this.entries.stream().noneMatch(e2 -> e2.comp_2396().comp_2447().equals((Object)CraftNamespacedKey.toMinecraft(modifier.getKey())) && e2.comp_2395().method_40226(CraftNamespacedKey.toMinecraft(attribute.getKey()))), (String)"Cannot add 2 modifiers with identical keys on the same attribute (modifier %s for attribute %s)", (Object)modifier.getKey(), (Object)attribute.getKey());
            this.entries.add(new class_9285.class_9287(CraftAttribute.bukkitToMinecraftHolder(attribute), CraftAttributeInstance.convert(modifier), CraftEquipmentSlot.getNMSGroup(equipmentSlotGroup), PaperAttributeModifierDisplay.toNms(display)));
            return this;
        }

        public ItemAttributeModifiers build() {
            if (this.entries.isEmpty()) {
                return new PaperItemAttributeModifiers(class_9285.field_49326);
            }
            return new PaperItemAttributeModifiers(new class_9285((List)new ObjectArrayList(this.entries)));
        }
    }
}

