/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.PaperDataComponentType;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.Arrays;
import java.util.SequencedSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_10712;
import org.bukkit.craftbukkit.util.Handleable;

public record PaperTooltipDisplay(class_10712 impl) implements TooltipDisplay,
Handleable<class_10712>
{
    @Override
    public class_10712 getHandle() {
        return this.impl;
    }

    public boolean hideTooltip() {
        return this.impl.comp_3600();
    }

    public Set<DataComponentType> hiddenComponents() {
        return (Set)this.impl.comp_3601().stream().map(PaperDataComponentType::minecraftToBukkit).collect(Collectors.toCollection(ReferenceLinkedOpenHashSet::new));
    }

    static final class BuilderImpl
    implements TooltipDisplay.Builder {
        private final Set<DataComponentType> hiddenComponents = new ReferenceLinkedOpenHashSet();
        private boolean hideTooltip;

        BuilderImpl() {
        }

        public TooltipDisplay.Builder hideTooltip(boolean hide) {
            this.hideTooltip = hide;
            return this;
        }

        public TooltipDisplay.Builder addHiddenComponents(DataComponentType ... components) {
            this.hiddenComponents.addAll(Arrays.asList(components));
            return this;
        }

        public TooltipDisplay.Builder hiddenComponents(Set<DataComponentType> components) {
            this.hiddenComponents.addAll(components);
            return this;
        }

        public TooltipDisplay build() {
            return new PaperTooltipDisplay(new class_10712(this.hideTooltip, (SequencedSet)this.hiddenComponents.stream().map(PaperDataComponentType::bukkitToMinecraft).collect(Collectors.toCollection(ReferenceLinkedOpenHashSet::new))));
        }
    }
}

