/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib;

import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.JavaTypeSort;

final class ReferenceType
implements JavaType {
    private final String name;
    private final String internalName;
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("([\\w$_]+\\.)*([\\w$_]+)");

    ReferenceType(String name) {
        this.name = Objects.requireNonNull(name, "Null name");
        if (!TYPE_NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid class name: " + name);
        }
        this.internalName = name.replace('.', '/');
    }

    @Override
    public JavaTypeSort getSort() {
        return JavaTypeSort.REFERENCE_TYPE;
    }

    @Override
    public JavaType mapClass(UnaryOperator<JavaType> func) {
        return (JavaType)func.apply(this);
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    @Override
    public String getDescriptor() {
        return "L" + this.internalName + ";";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        int index = this.name.lastIndexOf(46);
        return index < 0 ? this.name : this.name.substring(index + 1);
    }

    @Override
    public String getPackageName() {
        int index = this.name.lastIndexOf(46);
        return index < 0 ? "" : this.name.substring(0, index);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceType that = (ReferenceType)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        return this.getName();
    }
}

