/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib;

import net.techcable.srglib.FieldData;
import net.techcable.srglib.MethodData;
import net.techcable.srglib.mappings.Mappings;

public final class SrgLib {
    private SrgLib() {
    }

    public static boolean isValidIdentifier(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Empty name: " + name);
        }
        return Character.isJavaIdentifierStart(name.codePointAt(0)) && name.codePoints().skip(1L).allMatch(Character::isJavaIdentifierPart);
    }

    public static void checkConsistency(Mappings mappings) {
        mappings.forEachField((originalField, renamedField) -> {
            if (!originalField.mapTypes(mappings::getNewType).hasSameTypes((FieldData)renamedField)) {
                throw new IllegalArgumentException("Remapped field data (" + originalField + ") doesn't correspond to original types (" + renamedField + ")");
            }
        });
        mappings.forEachMethod((originalMethod, renamedMethod) -> {
            if (!originalMethod.mapTypes(mappings::getNewType).hasSameTypes((MethodData)renamedMethod)) {
                throw new IllegalArgumentException("Remapped method data (" + originalMethod + ") doesn't correspond to original types (" + renamedMethod + ")");
            }
        });
    }
}

