/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib.format;

import java.io.IOException;
import java.io.UncheckedIOException;
import net.techcable.srglib.FieldData;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.MethodData;
import net.techcable.srglib.MethodSignature;
import net.techcable.srglib.format.MappingsFormat;
import net.techcable.srglib.mappings.Mappings;
import net.techcable.srglib.mappings.MutableMappings;
import net.techcable.srglib.utils.Exceptions;
import net.techcable.srglib.utils.LineProcessor;
import org.checkerframework.checker.nullness.qual.NonNull;

class SrgMappingsFormat
implements MappingsFormat {
    public static final SrgMappingsFormat INSTANCE = new SrgMappingsFormat();

    private SrgMappingsFormat() {
    }

    @Override
    public LineProcessor<Mappings> createLineProcessor() {
        return new SrgLineProcessor();
    }

    @Override
    public void write(Mappings mappings, Appendable output) throws IOException {
        try {
            mappings.forEachClass(Exceptions.sneakyThrowing((original, renamed) -> {
                output.append("CL: ");
                output.append(original.getInternalName());
                output.append(' ');
                output.append(renamed.getInternalName());
                output.append('\n');
            }));
            mappings.forEachField(Exceptions.sneakyThrowing((original, renamed) -> {
                output.append("FD: ");
                output.append(original.getInternalName());
                output.append(' ');
                output.append(renamed.getInternalName());
                output.append('\n');
            }));
            mappings.forEachMethod(Exceptions.sneakyThrowing((original, renamed) -> {
                output.append("MD: ");
                output.append(original.getInternalName());
                output.append(' ');
                output.append(original.getSignature().getDescriptor());
                output.append(' ');
                output.append(renamed.getInternalName());
                output.append(' ');
                output.append(renamed.getSignature().getDescriptor());
                output.append('\n');
            }));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    static class SrgLineProcessor
    implements LineProcessor<Mappings> {
        private final MutableMappings result = MutableMappings.create();

        SrgLineProcessor() {
        }

        @Override
        public boolean processLine(@NonNull String line) throws IOException {
            this.parseLine(line);
            return true;
        }

        public void parseLine(@NonNull String line) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) {
                return;
            }
            if (line.length() < 4) {
                throw new IllegalArgumentException("Invalid line: " + line);
            }
            String id = line.substring(0, 2);
            String[] args = line.substring(4).split(" ");
            switch (id) {
                case "MD": {
                    if (args.length != 4) {
                        throw new IllegalArgumentException("Invalid line: " + line);
                    }
                    String originalInternalName = args[0];
                    MethodSignature originalSignature = MethodSignature.fromDescriptor(args[1]);
                    String renamedInternalName = args[2];
                    MethodSignature renamedSignature = MethodSignature.fromDescriptor(args[3]);
                    MethodData originalMethodData = MethodData.fromInternalName(originalInternalName, originalSignature);
                    MethodData renamedMethodData = MethodData.fromInternalName(renamedInternalName, renamedSignature);
                    this.result.putMethod(originalMethodData, renamedMethodData);
                    return;
                }
                case "FD": {
                    if (args.length != 2) {
                        throw new IllegalArgumentException("Invalid line: " + line);
                    }
                    String originalInternalName = args[0];
                    String renamedInternalName = args[1];
                    FieldData originalFieldData = FieldData.fromInternalName(originalInternalName);
                    FieldData renamedFieldData = FieldData.fromInternalName(renamedInternalName);
                    this.result.putField(originalFieldData, renamedFieldData);
                    return;
                }
                case "CL": {
                    if (args.length != 2) {
                        throw new IllegalArgumentException("Invalid line: " + line);
                    }
                    String originalInternalName = args[0];
                    String renamedInternalName = args[1];
                    JavaType originalType = JavaType.fromInternalName(originalInternalName);
                    JavaType renamedType = JavaType.fromInternalName(renamedInternalName);
                    this.result.putClass(originalType, renamedType);
                    return;
                }
                case "PK": {
                    return;
                }
            }
            throw new IllegalArgumentException("Invalid line: " + line);
        }

        @Override
        public Mappings getResult() {
            return this.result;
        }
    }
}

