/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib.mappings;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.techcable.srglib.FieldData;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.MethodData;
import net.techcable.srglib.mappings.ImmutableMappings;
import net.techcable.srglib.mappings.Mappings;
import net.techcable.srglib.mappings.MutableMappings;

class SimpleMappings
implements MutableMappings {
    private final Map<JavaType, JavaType> classes;
    private final Map<MethodData, String> methodNames;
    private final Map<FieldData, String> fieldNames;

    SimpleMappings(Map<JavaType, JavaType> classes, Map<MethodData, String> methodNames, Map<FieldData, String> fieldNames) {
        this.classes = Objects.requireNonNull(classes, "Null types");
        this.methodNames = Objects.requireNonNull(methodNames, "Null methods");
        this.fieldNames = Objects.requireNonNull(fieldNames, "Null fields");
    }

    @Override
    public void putClass(JavaType original, JavaType renamed) {
        if (!original.isReferenceType()) {
            throw new IllegalArgumentException("Original type isn't a reference type: " + original);
        }
        if (!renamed.isReferenceType()) {
            throw new IllegalArgumentException("Renamed type isn't a reference type: " + renamed);
        }
        if (original.equals(renamed)) {
            this.classes.remove(original);
        } else {
            this.classes.put(original, renamed);
        }
    }

    @Override
    public void putMethod(MethodData original, String newName) {
        this.methodNames.put(Objects.requireNonNull(original, "Null original"), Objects.requireNonNull(newName, "Null newName"));
    }

    @Override
    public void putField(FieldData original, String newName) {
        this.fieldNames.put(Objects.requireNonNull(original, "Null original"), Objects.requireNonNull(newName, "Null newName"));
    }

    @Override
    public JavaType getNewClass(JavaType original) {
        if (!original.isReferenceType()) {
            throw new IllegalArgumentException("Type isn't a reference type: " + original);
        }
        return this.classes.getOrDefault(Objects.requireNonNull(original), original);
    }

    @Override
    public MethodData getNewMethod(MethodData original) {
        String newName = this.methodNames.getOrDefault(original, original.getName());
        return original.mapTypes(this::getNewType).withName(newName);
    }

    @Override
    public FieldData getNewField(FieldData original) {
        String newName = this.fieldNames.getOrDefault(original, original.getName());
        return FieldData.create(this.getNewType(original.getDeclaringType()), newName);
    }

    @Override
    public ImmutableMappings snapshot() {
        return ImmutableMappings.copyOf(this.classes, this.methodNames, this.fieldNames);
    }

    @Override
    public Set<JavaType> classes() {
        return this.classes.keySet();
    }

    @Override
    public Set<MethodData> methods() {
        return this.methodNames.keySet();
    }

    @Override
    public Set<FieldData> fields() {
        return this.fieldNames.keySet();
    }

    @Override
    public Mappings inverted() {
        return this.snapshot().inverted();
    }

    @Override
    public void forEachClass(BiConsumer<JavaType, JavaType> action) {
        this.classes.forEach(action);
    }

    @Override
    public void forEachMethod(BiConsumer<MethodData, MethodData> action) {
        this.methodNames.forEach((originalData, newName) -> {
            MethodData newData = originalData.mapTypes(this::getNewType).withName((String)newName);
            action.accept((MethodData)originalData, newData);
        });
    }

    @Override
    public void forEachField(BiConsumer<FieldData, FieldData> action) {
        this.fieldNames.forEach((originalData, newName) -> {
            FieldData newData = FieldData.create(this.getNewType(originalData.getDeclaringType()), newName);
            action.accept((FieldData)originalData, newData);
        });
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        if (otherObj.getClass() == SimpleMappings.class) {
            SimpleMappings other = (SimpleMappings)otherObj;
            return this.classes.equals(other.classes) && this.methodNames.equals(other.methodNames) && this.fieldNames.equals(other.fieldNames);
        }
        if (otherObj instanceof Mappings) {
            return this.snapshot().equals(((Mappings)otherObj).snapshot());
        }
        return false;
    }

    public int hashCode() {
        int result = this.classes.hashCode();
        result = 31 * result + this.methodNames.hashCode();
        result = 31 * result + this.fieldNames.hashCode();
        return result;
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

