/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.entry.RegistryTypeMapper;
import io.papermc.paper.registry.set.NamedRegistryKeySetImpl;
import io.papermc.paper.registry.tag.Tag;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.util.Holderable;
import io.papermc.paper.util.MCUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7876;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.legacy.FieldRename;
import org.bukkit.craftbukkit.util.ApiVersion;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private static class_5455 registry;
    private final Class<?> bukkitClass;
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final class_2378<M> minecraftRegistry;
    private final RegistryTypeMapper<M, B> minecraftToBukkit;
    private final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater;
    private final InvalidHolderOwner invalidHolderOwner = new InvalidHolderOwner(this);
    private boolean lockReferenceHolders;

    public static void setMinecraftRegistry(class_5455 registry) {
        CraftRegistry.registry = registry;
    }

    public static class_5455 getMinecraftRegistry() {
        if (null == registry) {
            System.out.println("Setting Registry..");
            registry = CraftServer.console.method_30611();
        }
        return registry;
    }

    public static <E> class_2378<E> getMinecraftRegistry(class_5321<? extends class_2378<E>> key) {
        return CraftRegistry.getMinecraftRegistry().method_30530(key);
    }

    public static <B extends Keyed, M> B minecraftToBukkit(M minecraft, class_5321<? extends class_2378<M>> registryKey) {
        CraftRegistry craftRegistry;
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(registryKey);
        Registry bukkitRegistry = RegistryAccess.registryAccess().getRegistry(PaperRegistries.registryFromNms(registryKey));
        Optional resourceKey = registry.method_29113(minecraft);
        if (resourceKey.isEmpty() && bukkitRegistry instanceof CraftRegistry && (craftRegistry = (CraftRegistry)bukkitRegistry).supportsDirectHolders()) {
            return ((CraftRegistry)bukkitRegistry).createBukkit(class_6880.method_40223(minecraft));
        }
        if (resourceKey.isEmpty()) {
            throw new IllegalStateException(String.format("Cannot convert '%s' to bukkit representation, since it is not registered.", minecraft));
        }
        Keyed bukkit = bukkitRegistry.get(CraftNamespacedKey.fromMinecraft(((class_5321)resourceKey.get()).method_29177()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> B minecraftHolderToBukkit(class_6880<M> minecraft, class_5321<? extends class_2378<M>> registryKey) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        Registry bukkitRegistry = RegistryAccess.registryAccess().getRegistry(PaperRegistries.registryFromNms(registryKey));
        class_6880<M> class_68802 = minecraft;
        Objects.requireNonNull(class_68802);
        class_6880<M> class_68803 = class_68802;
        int n = 0;
        Keyed bukkit = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_6880.class_6881.class, class_6880.class_6883.class}, class_68803, n)) {
            case 0 -> {
                CraftRegistry craftRegistry;
                class_6880.class_6881 direct = (class_6880.class_6881)class_68803;
                if (!(bukkitRegistry instanceof CraftRegistry) || !(craftRegistry = (CraftRegistry)bukkitRegistry).supportsDirectHolders()) {
                    throw new IllegalArgumentException("Cannot convert direct holder to bukkit representation");
                }
                yield (Keyed)((CraftRegistry)bukkitRegistry).createBukkit((class_6880<M>)direct);
            }
            case 1 -> {
                class_6880.class_6883 reference = (class_6880.class_6883)class_68803;
                yield bukkitRegistry.get(MCUtil.fromResourceKey(reference.method_40237()));
            }
            default -> throw new IllegalArgumentException("Unknown holder: " + String.valueOf(minecraft));
        };
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (B)bukkit;
    }

    public static <B extends Keyed, M> M bukkitToMinecraft(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Handleable)bukkit).getHandle();
    }

    public static <B extends Keyed, M> class_6880<M> bukkitToMinecraftHolder(B bukkit, class_5321<class_2378<M>> registryKey) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        if (bukkit instanceof Holderable) {
            return ((Holderable)bukkit).getHolder();
        }
        class_2378<M> registry = CraftRegistry.getMinecraftRegistry(registryKey);
        class_6880 class_68802 = registry.method_47983(CraftRegistry.bukkitToMinecraft(bukkit));
        if (class_68802 instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own registry entry with out properly registering it.");
    }

    public static <T extends Keyed, M> Optional<T> unwrapAndConvertHolder(RegistryKey<T> registryKey, class_6880<M> value) {
        CraftRegistry craftRegistry;
        Registry registry = RegistryAccess.registryAccess().getRegistry(registryKey);
        if (registry instanceof CraftRegistry && (craftRegistry = (CraftRegistry)registry).supportsDirectHolders() && value.method_40231() == class_6880.class_6882.field_36447) {
            return Optional.of(((CraftRegistry)registry).createBukkit(value));
        }
        return value.method_40230().map(key -> registry.get(CraftNamespacedKey.fromMinecraft(key.method_29177())));
    }

    public static <B extends Keyed> B get(RegistryKey<B> bukkitKey, NamespacedKey namespacedKey, ApiVersion apiVersion) {
        Registry bukkit = RegistryAccess.registryAccess().getRegistry(bukkitKey);
        if (bukkit instanceof CraftRegistry) {
            CraftRegistry craft = (CraftRegistry)bukkit;
            return craft.get(craft.serializationUpdater.apply(namespacedKey, apiVersion));
        }
        if (bukkit instanceof Registry.SimpleRegistry) {
            Registry.SimpleRegistry simple = (Registry.SimpleRegistry)bukkit;
            Class bClass = simple.getType();
            if (bClass == EntityType.class) {
                return (B)bukkit.get(FieldRename.ENTITY_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
            if (bClass == Particle.class) {
                return (B)bukkit.get(FieldRename.PARTICLE_TYPE_RENAME.apply(namespacedKey, apiVersion));
            }
        }
        return (B)bukkit.get(namespacedKey);
    }

    public CraftRegistry(Class<?> bukkitClass, class_2378<M> minecraftRegistry, BiFunction<? super NamespacedKey, M, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater) {
        this(bukkitClass, minecraftRegistry, new RegistryTypeMapper<M, B>(minecraftToBukkit), serializationUpdater);
    }

    public CraftRegistry(RegistryEntryMeta.ServerSide<M, B> meta, class_2378<M> minecraftRegistry) {
        this(meta.classToPreload(), minecraftRegistry, meta.registryTypeMapper(), meta.serializationUpdater());
    }

    public CraftRegistry(Class<?> bukkitClass, class_2378<M> minecraftRegistry, RegistryTypeMapper<M, B> minecraftToBukkit, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater) {
        this.bukkitClass = bukkitClass;
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
        this.serializationUpdater = serializationUpdater;
        this.lockReferenceHolders = !this.minecraftToBukkit.constructorUsesHolder();
    }

    public void lockReferenceHolders() {
        Preconditions.checkState((boolean)this.cache.isEmpty(), (String)"Registry %s is already loaded", (Object)this.minecraftRegistry.method_46765());
        try {
            Class.forName(this.bukkitClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load class " + this.bukkitClass.getSimpleName(), e);
        }
        if (!this.minecraftToBukkit.constructorUsesHolder()) {
            return;
        }
        Preconditions.checkState((!this.lockReferenceHolders ? 1 : 0) != 0, (Object)"Reference holders are already locked");
        this.lockReferenceHolders = true;
    }

    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        Optional holderOptional = this.minecraftRegistry.method_10223(CraftNamespacedKey.toMinecraft(namespacedKey));
        Object holder = holderOptional.isPresent() ? (class_6880.class_6883)holderOptional.get() : (!this.lockReferenceHolders && this.minecraftToBukkit.constructorUsesHolder() ? class_6880.class_6883.method_40234((class_7876)this.invalidHolderOwner, MCUtil.toResourceKey(this.minecraftRegistry.method_46765(), namespacedKey)) : null);
        B bukkit = this.createBukkit((class_6880<M>)holder);
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    @NotNull
    public Stream<B> stream() {
        return this.minecraftRegistry.method_10235().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }

    public Iterator<B> iterator() {
        return this.stream().iterator();
    }

    public B createBukkit(class_6880<M> minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.createBukkit(minecraft));
    }

    public boolean supportsDirectHolders() {
        return this.minecraftToBukkit.supportsDirectHolders();
    }

    public NamespacedKey getKey(B value) {
        if (value instanceof Holderable) {
            Holderable holderable = (Holderable)value;
            return holderable.getKeyOrNull();
        }
        return value.getKey();
    }

    public boolean hasTag(TagKey<B> key) {
        return this.minecraftRegistry.method_46733(class_6862.method_40092((class_5321)this.minecraftRegistry.method_46765(), (class_2960)PaperAdventure.asVanilla(key.key()))).isPresent();
    }

    public Tag<B> getTag(TagKey<B> key) {
        class_6885.class_6888 namedHolderSet = (class_6885.class_6888)this.minecraftRegistry.method_46733(PaperRegistries.toNms(key)).orElseThrow();
        return new NamedRegistryKeySetImpl(key, namedHolderSet);
    }

    public Collection<Tag<B>> getTags() {
        return this.minecraftRegistry.method_40272().map(NamedRegistryKeySetImpl::new).toList();
    }

    public int size() {
        return this.minecraftRegistry.method_10204();
    }

    public static <B extends Keyed, M> class_6880<M> bukkitToMinecraftHolder(B bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((Holderable)bukkit).getHolder();
    }

    public Stream<NamespacedKey> keyStream() {
        return this.minecraftRegistry.method_10235().stream().map(CraftNamespacedKey::fromMinecraft);
    }

    final class InvalidHolderOwner
    implements class_7876<M> {
        InvalidHolderOwner(CraftRegistry this$0) {
        }
    }
}

