/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.destroystokyo.paper.block.BlockSoundGroup;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2386;
import net.minecraft.class_2457;
import net.minecraft.class_2542;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_4770;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.SoundGroup;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.bukkit.util.VoxelShape;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.impl.world.CraftWorld;
import org.jetbrains.annotations.NotNull;

public class CraftBlock
implements Block {
    private final class_3218 world;
    private final class_2338 position;

    public CraftBlock(class_3218 world, class_2338 position) {
        this.world = world;
        this.position = position.method_10062();
    }

    public static CraftBlock at(class_3218 world, class_2338 position) {
        return new CraftBlock(world, position);
    }

    private class_2248 getNMSBlock() {
        return this.getNMS().method_26204();
    }

    public class_2680 getNMS() {
        return this.world.method_8320(this.position);
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public World getWorld() {
        return this.world.getCraftWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public Location getLocation() {
        return new Location(this.getWorld(), (double)this.position.method_10263(), (double)this.position.method_10264(), (double)this.position.method_10260());
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX((double)this.position.method_10263());
            loc.setY((double)this.position.method_10264());
            loc.setZ((double)this.position.method_10260());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.getX(), this.getY(), this.getZ());
    }

    public int getX() {
        return this.position.method_10263();
    }

    public int getY() {
        return this.position.method_10264();
    }

    public int getZ() {
        return this.position.method_10260();
    }

    public Chunk getChunk() {
        return this.getWorld().getChunkAt((Block)this);
    }

    public void setData(byte data) {
        this.setData(data, 3);
    }

    public void setData(byte data, boolean applyPhysics) {
        this.setData(data, applyPhysics ? 3 : 2);
    }

    private void setData(byte data, int flag) {
        this.world.method_8652(this.position, CraftMagicNumbers.getBlock(this.getType(), data), flag);
    }

    public byte getData() {
        class_2680 blockData = this.world.method_8320(this.position);
        return CraftMagicNumbers.toLegacyData(blockData);
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getNMS());
    }

    public void setType(Material type) {
        this.setType(type, true);
    }

    public void setType(Material type, boolean applyPhysics) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        this.setBlockData(type.createBlockData(), applyPhysics);
    }

    public void setBlockData(BlockData data) {
        this.setBlockData(data, true);
    }

    public void setBlockData(BlockData data, boolean applyPhysics) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        this.setTypeAndData(((CraftBlockData)data).getState(), applyPhysics);
    }

    public boolean setTypeAndData(class_2680 blockData, boolean applyPhysics) {
        if (!blockData.method_26215() && blockData.method_26204() instanceof class_2237 && blockData.method_26204() != this.getNMSBlock()) {
            if (this.world instanceof class_1937) {
                this.world.method_8544(this.position);
            } else {
                this.world.method_8652(this.position, class_2246.field_10124.method_9564(), 0);
            }
        }
        if (applyPhysics) {
            return this.world.method_8652(this.position, blockData, 3);
        }
        class_2680 old = this.world.method_8320(this.position);
        boolean success = this.world.method_8652(this.position, blockData, 1042);
        if (success) {
            this.world.method_8410().method_8413(this.position, old, blockData, 3);
        }
        return success;
    }

    public static boolean setTypeAndData(class_1936 world, class_2338 position, class_2680 old, class_2680 blockData, boolean applyPhysics) {
        if (old.method_31709() && blockData.method_26204() != old.method_26204()) {
            if (world instanceof class_1937) {
                ((class_1937)world).method_8544(position);
            } else {
                world.method_8652(position, class_2246.field_10124.method_9564(), 0);
            }
        }
        if (applyPhysics) {
            return world.method_8652(position, blockData, 3);
        }
        boolean success = world.method_8652(position, blockData, 1042);
        if (success && world instanceof class_1937) {
            ((class_3218)world).method_8413(position, old, blockData, 3);
        }
        return success;
    }

    public Material getType() {
        return CraftMagicNumbers.getMaterial(this.world.method_8320(this.position).method_26204());
    }

    public byte getLightLevel() {
        return (byte)this.world.method_8410().method_22339(this.position);
    }

    public byte getLightFromSky() {
        return (byte)this.world.method_8314(class_1944.field_9284, this.position);
    }

    public byte getLightFromBlocks() {
        return (byte)this.world.method_8314(class_1944.field_9282, this.position);
    }

    public Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    public Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    public BlockFace getFace(Block block) {
        BlockFace[] values;
        for (BlockFace face : values = BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{pos=" + String.valueOf(this.position) + ",type=" + String.valueOf(this.getType()) + ",data=" + String.valueOf(this.getNMS()) + ",fluid=" + String.valueOf(this.world.method_8316(this.position)) + "}";
    }

    public static BlockFace notchToBlockFace(class_2350 notch) {
        if (notch == null) {
            return BlockFace.SELF;
        }
        return BlockFace.valueOf((String)notch.name());
    }

    public static class_2350 blockFaceToNotch(BlockFace face) {
        return class_2350.valueOf((String)face.name());
    }

    public BlockState getState1() {
        return CraftBlockStates.getBlockState(this);
    }

    public BlockState getState() {
        return CraftBlockStates.getBlockState(this);
    }

    public Biome getBiome() {
        return this.getWorld().getBiome(this.getX(), this.getY(), this.getZ());
    }

    public void setBiome(Biome bio) {
        this.getWorld().setBiome(this.getX(), this.getY(), this.getZ(), bio);
    }

    public static Biome biomeBaseToBiome(class_2378<class_1959> registry, class_6880<class_1959> base) {
        return CraftBlock.biomeBaseToBiome(registry, (class_1959)base.comp_349());
    }

    public static Biome biomeBaseToBiome(class_2378<class_1959> registry, class_1959 biome) {
        if (biome == null) {
            return null;
        }
        return (Biome)Registry.BIOME.get(CraftNamespacedKey.fromMinecraft(((class_5321)registry.method_29113((Object)biome).get()).method_29177()));
    }

    public static class_1959 biomeToBiomeBase(class_2378<class_1959> registry, Biome bio) {
        return null == bio ? null : (class_1959)registry.method_63535(CraftNamespacedKey.toMinecraft(bio.getKey()));
    }

    public double getTemperature() {
        return 0.0;
    }

    public double getHumidity() {
        return this.getWorld().getHumidity(this.getX(), this.getY(), this.getZ());
    }

    public boolean isBlockPowered() {
        return this.world.method_8410().method_49804(this.position) > 0;
    }

    public boolean isBlockIndirectlyPowered() {
        return this.world.method_8410().method_49803(this.position);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o;
        return this.position.equals((Object)other.position) && this.getWorld().equals((Object)other.getWorld());
    }

    public int hashCode() {
        return this.position.hashCode() ^ this.getWorld().hashCode();
    }

    public boolean isBlockFacePowered(BlockFace face) {
        return this.world.method_8410().method_49807(this.position, CraftBlock.blockFaceToNotch(face));
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        int power = this.world.method_8410().method_49808(this.position, CraftBlock.blockFaceToNotch(face));
        Block relative = this.getRelative(face);
        if (relative.getType() == Material.REDSTONE_WIRE) {
            return Math.max(power, relative.getData()) > 0;
        }
        return power > 0;
    }

    public int getBlockPower(BlockFace face) {
        int power = 0;
        class_3218 world = this.world;
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.method_49807(new class_2338(x, y - 1, z), class_2350.field_11033)) {
            power = CraftBlock.getPower(power, world.method_8320(new class_2338(x, y - 1, z)));
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.method_49807(new class_2338(x, y + 1, z), class_2350.field_11036)) {
            power = CraftBlock.getPower(power, world.method_8320(new class_2338(x, y + 1, z)));
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.method_49807(new class_2338(x + 1, y, z), class_2350.field_11034)) {
            power = CraftBlock.getPower(power, world.method_8320(new class_2338(x + 1, y, z)));
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.method_49807(new class_2338(x - 1, y, z), class_2350.field_11039)) {
            power = CraftBlock.getPower(power, world.method_8320(new class_2338(x - 1, y, z)));
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.method_49807(new class_2338(x, y, z - 1), class_2350.field_11043)) {
            power = CraftBlock.getPower(power, world.method_8320(new class_2338(x, y, z - 1)));
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.method_49807(new class_2338(x, y, z + 1), class_2350.field_11035)) {
            power = CraftBlock.getPower(power, world.method_8320(new class_2338(x, y, z + 1)));
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    private static int getPower(int i, class_2680 iblockdata) {
        if (!iblockdata.method_26204().equals(class_2246.field_10091)) {
            return i;
        }
        int j = (Integer)iblockdata.method_11654((class_2769)class_2457.field_11432);
        return j > i ? j : i;
    }

    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    public boolean isEmpty() {
        return this.getNMS().method_26215();
    }

    public boolean isLiquid() {
        return this.getNMS().method_51176();
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.getNMS().method_26223().ordinal());
    }

    public boolean breakNaturally() {
        return this.breakNaturally(new ItemStack(Material.AIR));
    }

    public boolean breakNaturally(ItemStack item) {
        class_2680 iblockdata = this.getNMS();
        class_2248 block = iblockdata.method_26204();
        class_1799 nmsItem = CraftItemStack.asNMSCopy(item);
        boolean result = false;
        if (block != class_2246.field_10124 && (item == null || !iblockdata.method_29291() || nmsItem.method_7951(iblockdata))) {
            class_2248.method_9511((class_2680)iblockdata, (class_1937)this.world, (class_2338)this.position, (class_2586)this.world.method_8321(this.position), null, (class_1799)nmsItem);
            result = true;
        }
        return this.setTypeAndData(class_2246.field_10124.method_9564(), true) && result;
    }

    public Collection<ItemStack> getDrops() {
        return this.getDrops(new ItemStack(Material.AIR));
    }

    public Collection<ItemStack> getDrops(ItemStack item) {
        return this.getDrops(item, null);
    }

    public Collection<ItemStack> getDrops(ItemStack item, Entity entity) {
        class_2680 iblockdata = this.getNMS();
        class_1799 nms = CraftItemStack.asNMSCopy(item);
        if (item == null || !iblockdata.method_29291() || nms.method_7951(iblockdata)) {
            return class_2248.method_9609((class_2680)iblockdata, (class_3218)this.world, (class_2338)this.position, (class_2586)this.world.method_8321(this.position), (class_1297)(entity == null ? null : ((CraftEntity)entity).getHandle()), (class_1799)nms).stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return null;
    }

    public boolean hasMetadata(String metadataKey) {
        return false;
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
    }

    public boolean isPassable() {
        return this.getNMS().method_26220((class_1922)this.world, this.position).method_1110();
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        return null;
    }

    public BoundingBox getBoundingBox() {
        class_265 shape = this.getNMS().method_26218((class_1922)this.world, this.position);
        if (shape.method_1110()) {
            return new BoundingBox();
        }
        class_238 aabb = shape.method_1107();
        return new BoundingBox((double)this.getX() + aabb.field_1323, (double)this.getY() + aabb.field_1322, (double)this.getZ() + aabb.field_1321, (double)this.getX() + aabb.field_1320, (double)this.getY() + aabb.field_1325, (double)this.getZ() + aabb.field_1324);
    }

    public boolean applyBoneMeal(BlockFace face) {
        return false;
    }

    public boolean breakNaturally(ItemStack arg0, boolean arg1) {
        return this.breakNaturally(arg0);
    }

    public float getDestroySpeed(ItemStack arg0) {
        return 0.0f;
    }

    public BlockSoundGroup getSoundGroup() {
        return null;
    }

    public BlockState getState(boolean arg0) {
        return CraftBlockState.getBlockState((class_1936)this.world, this.position);
    }

    public String getTranslationKey() {
        return this.getNMS().method_26204().method_63499();
    }

    public boolean isBuildable() {
        return true;
    }

    public boolean isBurnable() {
        return false;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSolid() {
        return this.getBlockData().getMaterial().isSolid();
    }

    public float getDestroySpeed(@NotNull ItemStack arg0, boolean arg1) {
        return 0.0f;
    }

    public boolean isPreferredTool(@NotNull ItemStack arg0) {
        return false;
    }

    public boolean isValidTool(@NotNull ItemStack arg0) {
        return false;
    }

    public float getBreakSpeed(@NotNull Player arg0) {
        return this.getNMS().method_26165((class_1657)((CraftPlayer)arg0).getHandle(), (class_1922)this.world, this.position);
    }

    public VoxelShape getCollisionShape() {
        return null;
    }

    @NotNull
    public String translationKey() {
        return null;
    }

    public boolean breakNaturally(boolean bl) {
        return false;
    }

    public boolean isCollidable() {
        return false;
    }

    public boolean canPlace(@NotNull BlockData arg0) {
        return true;
    }

    @NotNull
    public SoundGroup getBlockSoundGroup() {
        return null;
    }

    @NotNull
    public Biome getComputedBiome() {
        return null;
    }

    public void randomTick() {
    }

    public void tick() {
    }

    @Deprecated
    public CraftWorld getWorldImpl() {
        return this.getCraftWorld();
    }

    public boolean breakNaturally(boolean triggerEffect, boolean dropExperience) {
        return this.breakNaturally(null, triggerEffect, dropExperience);
    }

    public boolean breakNaturally(ItemStack item, boolean triggerEffect, boolean dropExperience) {
        boolean destroyed;
        class_2680 iblockdata = this.getNMS();
        class_2248 block = iblockdata.method_26204();
        class_1799 nmsItem = CraftItemStack.asNMSCopy(item);
        boolean result = false;
        if (block != class_2246.field_10124 && (item == null || !iblockdata.method_29291() || nmsItem.method_7951(iblockdata))) {
            class_2248.method_9511((class_2680)iblockdata, (class_1937)this.world, (class_2338)this.position, (class_2586)this.world.method_8321(this.position), null, (class_1799)nmsItem);
            if (triggerEffect) {
                if (iblockdata.method_26204() instanceof class_4770) {
                    this.world.method_20290(1009, this.position, 0);
                } else {
                    this.world.method_20290(2001, this.position, class_2248.method_9507((class_2680)iblockdata));
                }
            }
            if (dropExperience) {
                // empty if block
            }
            result = true;
        }
        if (destroyed = this.world.method_8650(this.position, false)) {
            block.method_9585((class_1936)this.world, this.position, iblockdata);
        }
        if (!result || block instanceof class_2386 || block instanceof class_2542) {
            // empty if block
        }
        return destroyed && result;
    }

    public class_3218 getHandle() {
        return this.getCraftWorld().getHandle();
    }

    public class_3610 getNMSFluid() {
        return this.world.method_8316(this.position);
    }

    public void fluidTick() {
        this.getNMSFluid().method_15770(this.getHandle(), this.position, this.getNMS());
    }

    public boolean isSuffocating() {
        return this.getNMS().method_26228((class_1922)this.world, this.position);
    }

    public boolean breakNaturally(@NotNull ItemStack tool, boolean triggerEffect, boolean dropExperience, boolean forceEffect) {
        return this.breakNaturally(tool, triggerEffect, dropExperience);
    }
}

