/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_12259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.cardboardpowered.impl.world.CraftWorld;
import org.slf4j.Logger;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_2487 data;
    private final EntityType type;

    private CraftEntitySnapshot(class_2487 data, EntityType type) {
        this.data = data;
        this.type = type;
    }

    public EntityType getEntityType() {
        return this.type;
    }

    public Entity createEntity(World world) {
        class_1297 internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        class_1297 internal = this.createInternal(location.getWorld());
        internal.method_5814(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)internal.getBukkitEntity());
    }

    public String getAsString() {
        return this.data.toString();
    }

    public static class_11368 NbtReadView_createGlobal(class_8942 problemReporter, class_2487 compoundTag) {
        return class_11352.method_71417((class_8942)problemReporter, (class_7225.class_7874)CraftServer.server.method_30611(), (class_2487)compoundTag);
    }

    private class_1297 createInternal(World world) {
        class_3218 nms = ((CraftWorld)world).getHandle();
        class_1297 internal = class_1299.method_71371((class_2487)this.data, (class_1937)nms, (class_3730)class_3730.field_52444, (class_12259)class_12259.field_64130);
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).method_5883((class_1937)nms, class_3730.field_52444);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        try (class_8942.class_11340 problemReporter = new class_8942.class_11340(() -> "EntitySnapshot#createEntity", LOGGER);){
            internal.method_5651(CraftEntitySnapshot.NbtReadView_createGlobal((class_8942)problemReporter, this.data));
        }
        return internal;
    }

    public class_2487 getData() {
        return this.data;
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        try (class_8942.class_11340 problemReporter = new class_8942.class_11340(() -> "create@" + String.valueOf(entity.getUniqueId()), LOGGER);){
            CraftEntitySnapshot craftEntitySnapshot;
            class_11362 output = class_11362.method_71459((class_8942)problemReporter, (class_7225.class_7874)CraftRegistry.getMinecraftRegistry());
            if (!entity.getHandle().method_5786((class_11372)output)) {
                CraftEntitySnapshot craftEntitySnapshot2;
                CraftEntitySnapshot craftEntitySnapshot3 = craftEntitySnapshot2 = null;
                return craftEntitySnapshot3;
            }
            CraftEntitySnapshot craftEntitySnapshot4 = craftEntitySnapshot = new CraftEntitySnapshot(output.method_71475(), entity.getType());
            return craftEntitySnapshot4;
        }
    }

    public static CraftEntitySnapshot create(class_2487 tag, EntityType type) {
        if (tag == null || tag.method_33133() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(class_2487 tag) {
        try (class_8942.class_11340 problemReporter = new class_8942.class_11340(() -> "create", LOGGER);){
            CraftEntitySnapshot craftEntitySnapshot;
            EntityType type = class_1299.method_17684((class_11368)CraftEntitySnapshot.NbtReadView_createGlobal((class_8942)problemReporter, tag)).map(CraftEntityType::minecraftToBukkit).orElse(null);
            CraftEntitySnapshot craftEntitySnapshot2 = craftEntitySnapshot = CraftEntitySnapshot.create(tag, type);
            return craftEntitySnapshot2;
        }
    }
}

