/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.HolderableBase;
import net.minecraft.class_10823;
import net.minecraft.class_1321;
import net.minecraft.class_1493;
import net.minecraft.class_1767;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9346;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Wolf;
import org.jetbrains.annotations.NotNull;

public class CraftWolf
extends CraftTameableAnimal
implements Wolf {
    public CraftWolf(CraftServer server, class_1493 wolf) {
        super(server, (class_1321)wolf);
    }

    public boolean isAngry() {
        return this.getHandle().method_29511();
    }

    public void setAngry(boolean angry) {
        if (angry) {
            this.getHandle().method_29509();
        } else {
            this.getHandle().method_29922();
        }
    }

    public class_1493 getHandle() {
        return (class_1493)this.nms;
    }

    @Override
    public EntityType getType() {
        return EntityType.WOLF;
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().method_6713().method_7789()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().method_6708(class_1767.method_7791((int)color.getWoolData()));
    }

    public boolean isInterested() {
        return this.getHandle().method_6710();
    }

    public void setInterested(boolean arg0) {
        this.getHandle().method_6712(arg0);
    }

    public float getTailAngle() {
        return this.getHandle().method_6714();
    }

    public boolean isWet() {
        return this.getHandle().field_6944;
    }

    public Wolf.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit((class_6880<class_9346>)this.getHandle().method_58062());
    }

    public void setVariant(Wolf.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().method_58063(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    @NotNull
    public Wolf.SoundVariant getSoundVariant() {
        return null;
    }

    public void setSoundVariant(@NotNull Wolf.SoundVariant soundVariant) {
    }

    public static class CraftVariant
    implements Wolf.Variant,
    Handleable<class_9346> {
        private final NamespacedKey key;
        private final class_9346 variant;

        public static Wolf.Variant minecraftToBukkit(class_9346 minecraft) {
            return (Wolf.Variant)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_49772);
        }

        public static Wolf.Variant minecraftHolderToBukkit(class_6880<class_9346> minecraft) {
            return CraftVariant.minecraftToBukkit((class_9346)minecraft.comp_349());
        }

        public static class_9346 bukkitToMinecraft(Wolf.Variant bukkit) {
            return (class_9346)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static class_6880<class_9346> bukkitToMinecraftHolder(Wolf.Variant bukkit) {
            Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
            class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_49772);
            class_6880 class_68802 = registry.method_47983((Object)CraftVariant.bukkitToMinecraft(bukkit));
            if (class_68802 instanceof class_6880.class_6883) {
                class_6880.class_6883 holder = (class_6880.class_6883)class_68802;
                return holder;
            }
            throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own wolf variant with out properly registering it.");
        }

        public CraftVariant(NamespacedKey key, class_9346 variant) {
            this.key = key;
            this.variant = variant;
        }

        @Override
        public class_9346 getHandle() {
            return this.variant;
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toString();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CraftVariant)) {
                return false;
            }
            CraftVariant otherVariant = (CraftVariant)other;
            return this.getKey().equals((Object)otherVariant.getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }
    }

    public static class CraftSoundVariant
    extends HolderableBase<class_10823>
    implements Wolf.SoundVariant {
        public static Wolf.SoundVariant minecraftToBukkit(class_10823 minecraft) {
            return (Wolf.SoundVariant)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_57110);
        }

        public static Wolf.SoundVariant minecraftHolderToBukkit(class_6880<class_10823> minecraft) {
            return (Wolf.SoundVariant)CraftRegistry.minecraftHolderToBukkit(minecraft, class_7924.field_57110);
        }

        public static class_10823 bukkitToMinecraft(Wolf.SoundVariant bukkit) {
            return (class_10823)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static class_6880<class_10823> bukkitToMinecraftHolder(Wolf.SoundVariant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftSoundVariant(class_6880<class_10823> holder) {
            super(holder);
        }
    }
}

