/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.destroystokyo.paper.Namespaced;
import com.destroystokyo.paper.NamespacedTag;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Level;
import me.isaiah.common.ICommonMod;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.class_10130;
import net.minecraft.class_10131;
import net.minecraft.class_10192;
import net.minecraft.class_10215;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1814;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_4174;
import net.minecraft.class_4550;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6538;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_9274;
import net.minecraft.class_9275;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.class_9792;
import net.minecraft.class_9889;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.block.CraftBlockType;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.inventory.CraftItemFlag;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.inventory.components.CraftCustomModelDataComponent;
import org.bukkit.craftbukkit.inventory.components.CraftEquippableComponent;
import org.bukkit.craftbukkit.inventory.components.CraftToolComponent;
import org.bukkit.craftbukkit.inventory.components.CraftUseCooldownComponent;
import org.bukkit.craftbukkit.inventory.tags.DeprecatedCustomTagContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.CraftNBTTagConfigSerializer;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.tag.DamageTypeTags;
import org.cardboardpowered.adventure.CardboardAdventure;
import org.cardboardpowered.impl.CardboardAttributeInstance;
import org.cardboardpowered.impl.CardboardEnchantment;
import org.cardboardpowered.interfaces.IComponentChanges;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaItem
implements ItemMeta,
Damageable,
Repairable,
BlockDataMeta {
    static final Logger LOGGER = LogUtils.getLogger();
    static final ItemMetaKeyType<class_2561> NAME = new ItemMetaKeyType(class_9334.field_49631, "display-name");
    static final ItemMetaKeyType<class_2561> ITEM_NAME = new ItemMetaKeyType(class_9334.field_50239, "item-name");
    static final ItemMetaKeyType<class_9290> LORE = new ItemMetaKeyType(class_9334.field_49632, "lore");
    static final ItemMetaKeyType<class_9280> CUSTOM_MODEL_DATA = new ItemMetaKeyType(class_9334.field_49637, "custom-model-data");
    static final ItemMetaKeyType<class_9889> ENCHANTABLE = new ItemMetaKeyType(class_9334.field_53695, "enchantable");
    static final ItemMetaKeyType<class_9304> ENCHANTMENTS = new ItemMetaKeyType(class_9334.field_49633, "enchants");
    static final ItemMetaKeyType<Integer> REPAIR = new ItemMetaKeyType(class_9334.field_49639, "repair-cost");
    static final ItemMetaKeyType<class_9285> ATTRIBUTES = new ItemMetaKeyType(class_9334.field_49636, "attribute-modifiers");
    static final ItemMetaKey ATTRIBUTES_IDENTIFIER = new ItemMetaKey("AttributeName");
    static final ItemMetaKey ATTRIBUTES_SLOT = new ItemMetaKey("Slot");
    static final ItemMetaKey HIDEFLAGS = new ItemMetaKey("ItemFlags");
    static final ItemMetaKeyType<class_10712> TOOLTIP_DISPLAY = new ItemMetaKeyType(class_9334.field_56400, "tool-tip-display");
    static final ItemMetaKeyType<class_2960> TOOLTIP_STYLE = new ItemMetaKeyType(class_9334.field_54198, "tool-tip-style");
    static final ItemMetaKeyType<class_2960> ITEM_MODEL = new ItemMetaKeyType(class_9334.field_54199, "item-model");
    static final ItemMetaKeyType<class_3902> UNBREAKABLE = new ItemMetaKeyType(class_9334.field_49630, "Unbreakable");
    static final ItemMetaKeyType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = new ItemMetaKeyType(class_9334.field_49641, "enchantment-glint-override");
    static final ItemMetaKeyType<class_3902> GLIDER = new ItemMetaKeyType(class_9334.field_54197, "glider");
    static final ItemMetaKeyType<class_10215> DAMAGE_RESISTANT = new ItemMetaKeyType(class_9334.field_54273, "damage-resistant");
    static final ItemMetaKeyType<Integer> MAX_STACK_SIZE = new ItemMetaKeyType(class_9334.field_50071, "max-stack-size");
    static final ItemMetaKeyType<class_1814> RARITY = new ItemMetaKeyType(class_9334.field_50073, "rarity");
    static final ItemMetaKeyType<class_10131> USE_REMAINDER = new ItemMetaKeyType(class_9334.field_53965, "use-remainder");
    static final ItemMetaKeyType<class_10130> USE_COOLDOWN = new ItemMetaKeyType(class_9334.field_53966, "use-cooldown");
    static final ItemMetaKeyType<class_4174> FOOD = new ItemMetaKeyType(class_9334.field_50075, "food");
    static final ItemMetaKeyType<class_9424> TOOL = new ItemMetaKeyType(class_9334.field_50077, "tool");
    static final ItemMetaKeyType<class_10192> EQUIPPABLE = new ItemMetaKeyType(class_9334.field_54196, "equippable");
    static final ItemMetaKeyType<class_9792> JUKEBOX_PLAYABLE = new ItemMetaKeyType(class_9334.field_52175, "jukebox-playable");
    static final ItemMetaKeyType<Integer> DAMAGE = new ItemMetaKeyType(class_9334.field_49629, "Damage");
    static final ItemMetaKeyType<Integer> MAX_DAMAGE = new ItemMetaKeyType(class_9334.field_50072, "max-damage");
    static final ItemMetaKeyType<class_9275> BLOCK_DATA = new ItemMetaKeyType(class_9334.field_49623, "BlockStateTag");
    static final ItemMetaKey BUKKIT_CUSTOM_TAG = new ItemMetaKey("PublicBukkitValues");
    static final ItemMetaKeyType<class_9279> CUSTOM_DATA = new ItemMetaKeyType(class_9334.field_49628);
    static final ItemMetaKeyType<class_6538> CAN_PLACE_ON = new ItemMetaKeyType(class_9334.field_49634);
    static final ItemMetaKeyType<class_6538> CAN_BREAK = new ItemMetaKeyType(class_9334.field_49635);
    private List<class_4550> canPlaceOnPredicates;
    private List<class_4550> canBreakPredicates;
    private static final Set<class_9331<?>> HIDDEN_COMPONENTS_PREVIOUSLY = Set.of(class_9334.field_49619, class_9334.field_49624, class_9334.field_49611, class_9334.field_49623, class_9334.field_49650, class_9334.field_49649, class_9334.field_49622, class_9334.field_49626, class_9334.field_49615, class_9334.field_49616, class_9334.field_49612, class_9334.field_52175, class_9334.field_49646, class_9334.field_56138, class_9334.field_49621, class_9334.field_49651, class_9334.field_56151, class_9334.field_49606);
    private static final Map<ItemFlag, Set<class_9331<?>>> ITEM_FLAG_EQUIVALENTS = ImmutableMap.builder().put((Object)ItemFlag.HIDE_ATTRIBUTES, Set.of(class_9334.field_49636)).put((Object)ItemFlag.HIDE_ENCHANTS, Set.of(class_9334.field_49633)).put((Object)ItemFlag.HIDE_STORED_ENCHANTS, Set.of(class_9334.field_49643)).put((Object)ItemFlag.HIDE_UNBREAKABLE, Set.of(class_9334.field_49630)).put((Object)ItemFlag.HIDE_DYE, Set.of(class_9334.field_49644)).put((Object)ItemFlag.HIDE_ARMOR_TRIM, Set.of(class_9334.field_49607)).put((Object)ItemFlag.HIDE_PLACED_ON, Set.of(class_9334.field_49634)).put((Object)ItemFlag.HIDE_DESTROYS, Set.of(class_9334.field_49635)).put((Object)ItemFlag.HIDE_ADDITIONAL_TOOLTIP, HIDDEN_COMPONENTS_PREVIOUSLY).buildOrThrow();
    protected static final Set<class_9331<?>> DEFAULT_HANDLED_DCTS = Set.of(CraftMetaItem.NAME.TYPE, CraftMetaItem.ITEM_NAME.TYPE, CraftMetaItem.LORE.TYPE, CraftMetaItem.CUSTOM_MODEL_DATA.TYPE, CraftMetaItem.ENCHANTABLE.TYPE, CraftMetaItem.BLOCK_DATA.TYPE, CraftMetaItem.REPAIR.TYPE, CraftMetaItem.ENCHANTMENTS.TYPE, CraftMetaItem.TOOLTIP_DISPLAY.TYPE, CraftMetaItem.TOOLTIP_STYLE.TYPE, CraftMetaItem.ITEM_MODEL.TYPE, CraftMetaItem.UNBREAKABLE.TYPE, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.TYPE, CraftMetaItem.GLIDER.TYPE, CraftMetaItem.DAMAGE_RESISTANT.TYPE, CraftMetaItem.MAX_STACK_SIZE.TYPE, CraftMetaItem.RARITY.TYPE, CraftMetaItem.USE_REMAINDER.TYPE, CraftMetaItem.USE_COOLDOWN.TYPE, CraftMetaItem.FOOD.TYPE, CraftMetaItem.TOOL.TYPE, CraftMetaItem.EQUIPPABLE.TYPE, CraftMetaItem.JUKEBOX_PLAYABLE.TYPE, CraftMetaItem.DAMAGE.TYPE, CraftMetaItem.MAX_DAMAGE.TYPE, CraftMetaItem.CUSTOM_DATA.TYPE, CraftMetaItem.ATTRIBUTES.TYPE, CraftMetaItem.CAN_PLACE_ON.TYPE, CraftMetaItem.CAN_BREAK.TYPE);
    private class_2561 displayName;
    private class_2561 itemName;
    private List<class_2561> lore;
    private CraftCustomModelDataComponent customModelData;
    private Map<String, String> blockData;
    private Map<Enchantment, Integer> enchantments;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private int repairCost;
    private boolean hideTooltip;
    private boolean unbreakable;
    private Boolean enchantmentGlintOverride;
    private boolean fireResistant;
    private Integer maxStackSize;
    private ItemRarity rarity;
    private CraftToolComponent tool;
    private Integer damage;
    private Integer maxDamage;
    private CraftEquippableComponent equippable;
    private CraftUseCooldownComponent useCooldown;
    private Integer enchantableValue;
    @Nullable
    private class_10712 tooltipDisplay;
    private NamespacedKey tooltipStyle;
    private NamespacedKey itemModel;
    private class_6862<class_8110> damageResistant;
    private ItemStack useRemainder;
    private boolean glider;
    private static final Set<class_9331> HANDLED_TAGS = Sets.newHashSet();
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private class_2487 customTag;
    protected class_9326.class_9327 unhandledTags = class_9326.method_57841();
    private CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private int version = CraftMagicNumbers.INSTANCE.getDataVersion();

    CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            return;
        }
        this.displayName = meta.displayName;
        this.itemName = meta.itemName;
        if (meta.lore != null) {
            this.lore = new ArrayList<class_2561>(meta.lore);
        }
        if (meta.hasCustomModelData()) {
            this.customModelData = new CraftCustomModelDataComponent(meta.customModelData);
        }
        this.enchantableValue = meta.enchantableValue;
        this.blockData = meta.blockData;
        if (meta.enchantments != null) {
            this.enchantments = new LinkedHashMap<Enchantment, Integer>(meta.enchantments);
        }
        if (meta.attributeModifiers != null) {
            this.attributeModifiers = LinkedHashMultimap.create(meta.attributeModifiers);
        }
        this.repairCost = meta.repairCost;
        this.hideTooltip = meta.hideTooltip;
        this.tooltipStyle = meta.tooltipStyle;
        this.itemModel = meta.itemModel;
        this.unbreakable = meta.unbreakable;
        this.enchantmentGlintOverride = meta.enchantmentGlintOverride;
        this.glider = meta.glider;
        this.damageResistant = meta.damageResistant;
        this.maxStackSize = meta.maxStackSize;
        this.rarity = meta.rarity;
        if (meta.tooltipDisplay != null) {
            this.tooltipDisplay = new class_10712(meta.tooltipDisplay.comp_3600(), (SequencedSet)new ReferenceLinkedOpenHashSet((Collection)meta.tooltipDisplay.comp_3601()));
        }
        if (meta.hasUseRemainder()) {
            this.useRemainder = meta.useRemainder.clone();
        }
        if (meta.hasUseCooldown()) {
            this.useCooldown = new CraftUseCooldownComponent(meta.useCooldown);
        }
        if (meta.hasFood()) {
            // empty if block
        }
        if (meta.hasTool()) {
            this.tool = new CraftToolComponent(meta.tool);
        }
        if (meta.hasEquippable()) {
            this.equippable = new CraftEquippableComponent(meta.equippable);
        }
        if (meta.hasJukeboxPlayable()) {
            // empty if block
        }
        this.damage = meta.damage;
        this.maxDamage = meta.maxDamage;
        this.unhandledTags = meta.unhandledTags;
        this.persistentDataContainer.putAll(meta.persistentDataContainer.getRaw());
        this.customTag = meta.customTag;
        this.version = meta.version;
        this.canPlaceOnPredicates = meta.canPlaceOnPredicates;
        this.canBreakPredicates = meta.canBreakPredicates;
    }

    protected static <T> Optional<? extends T> getOrEmpty(class_9326 tag, ItemMetaKeyType<T> type) {
        Optional result = tag.method_57845(type.TYPE);
        return result != null ? result : Optional.empty();
    }

    protected static <T> Optional<? extends T> getOrEmpty(class_9326 tag, class_9331<T> type) {
        Optional result = tag.method_57845(type);
        return result != null ? result : Optional.empty();
    }

    CraftMetaItem(class_9326 tag, Set<class_9331<?>> extraHandledTags) {
        this.updateFromPatch(tag, extraHandledTags);
    }

    protected final void updateFromPatch(class_9326 tag, Set<class_9331<?>> extraHandledTags) {
        CraftMetaItem.getOrEmpty(tag, NAME).ifPresent(component -> {
            this.displayName = component;
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_NAME).ifPresent(component -> {
            this.itemName = component;
        });
        CraftMetaItem.getOrEmpty(tag, LORE).ifPresent(l -> {
            List list = l.comp_2400();
            this.lore = new ArrayList<class_2561>(list.size());
            for (int index = 0; index < list.size(); ++index) {
                class_2561 line = (class_2561)list.get(index);
                this.lore.add(line);
            }
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_MODEL_DATA).ifPresent(i2 -> {
            this.customModelData = new CraftCustomModelDataComponent((class_9280)i2);
        });
        CraftMetaItem.getOrEmpty(tag, BLOCK_DATA).ifPresent(t -> {
            this.blockData = t.comp_2381();
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENTS).ifPresent(en -> {
            this.enchantments = CraftMetaItem.buildEnchantments(en);
        });
        CraftMetaItem.getOrEmpty(tag, ATTRIBUTES).ifPresent(en -> {
            this.attributeModifiers = CraftMetaItem.buildModifiers(en);
        });
        CraftMetaItem.getOrEmpty(tag, REPAIR).ifPresent(i2 -> {
            this.repairCost = i2;
        });
        CraftMetaItem.getOrEmpty(tag, TOOLTIP_DISPLAY).ifPresent(en -> {
            this.tooltipDisplay = new class_10712(en.comp_3600(), (SequencedSet)new ReferenceLinkedOpenHashSet((Collection)en.comp_3601()));
        });
        CraftMetaItem.getOrEmpty(tag, TOOLTIP_STYLE).ifPresent(key -> {
            this.tooltipStyle = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, ITEM_MODEL).ifPresent(key -> {
            this.itemModel = CraftNamespacedKey.fromMinecraft(key);
        });
        CraftMetaItem.getOrEmpty(tag, UNBREAKABLE).ifPresent(u -> {
            this.unbreakable = true;
        });
        CraftMetaItem.getOrEmpty(tag, ENCHANTMENT_GLINT_OVERRIDE).ifPresent(override -> {
            this.enchantmentGlintOverride = override;
        });
        CraftMetaItem.getOrEmpty(tag, GLIDER).ifPresent(u -> {
            this.glider = true;
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE_RESISTANT).ifPresent(tags -> {
            this.damageResistant = tags.comp_3210();
        });
        CraftMetaItem.getOrEmpty(tag, MAX_STACK_SIZE).ifPresent(i2 -> {
            this.maxStackSize = i2;
        });
        CraftMetaItem.getOrEmpty(tag, RARITY).ifPresent(enumItemRarity -> {
            this.rarity = ItemRarity.valueOf((String)enumItemRarity.name());
        });
        CraftMetaItem.getOrEmpty(tag, USE_REMAINDER).ifPresent(remainder -> {
            this.useRemainder = CraftItemStack.asCraftMirror(remainder.comp_3093());
        });
        CraftMetaItem.getOrEmpty(tag, USE_COOLDOWN).ifPresent(cooldown -> {
            this.useCooldown = new CraftUseCooldownComponent((class_10130)cooldown);
        });
        CraftMetaItem.getOrEmpty(tag, FOOD).ifPresent(foodInfo -> {});
        CraftMetaItem.getOrEmpty(tag, TOOL).ifPresent(toolInfo -> {
            this.tool = new CraftToolComponent((class_9424)toolInfo);
        });
        CraftMetaItem.getOrEmpty(tag, EQUIPPABLE).ifPresent(equippableInfo -> {
            this.equippable = new CraftEquippableComponent((class_10192)equippableInfo);
        });
        CraftMetaItem.getOrEmpty(tag, DAMAGE).ifPresent(i2 -> {
            this.damage = i2;
        });
        CraftMetaItem.getOrEmpty(tag, MAX_DAMAGE).ifPresent(i2 -> {
            this.maxDamage = i2;
        });
        CraftMetaItem.getOrEmpty(tag, CUSTOM_DATA).ifPresent(customData -> {
            this.customTag = customData.method_57461();
            if (this.customTag.method_10545(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT)) {
                class_2487 compound = this.customTag.method_68568(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
                Set keys = compound.method_10541();
                for (String key : keys) {
                    this.persistentDataContainer.put(key, compound.method_10580(key).method_10707());
                }
                this.customTag.method_10551(CraftMetaItem.BUKKIT_CUSTOM_TAG.NBT);
            }
            if (this.customTag.method_33133()) {
                this.customTag = null;
            }
        });
        Set keys = tag.method_57846();
        for (Map.Entry key2 : keys) {
            if (CraftMetaItem.getHandledTags().contains(key2.getKey())) continue;
            ((Optional)key2.getValue()).ifPresentOrElse(value -> this.unhandledTags.method_57854((class_9331)key2.getKey(), value), () -> this.unhandledTags.method_57853((class_9331)key2.getKey()));
        }
    }

    static Map<Enchantment, Integer> buildEnchantments(class_9304 tag) {
        LinkedHashMap<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>(tag.method_57541());
        tag.method_57539().forEach(entry -> {
            class_6880 id = (class_6880)entry.getKey();
            int level = entry.getIntValue();
            Enchantment enchant = CardboardEnchantment.minecraftHolderToBukkit((class_6880<class_1887>)id);
            if (enchant != null) {
                enchantments.put(enchant, level);
            }
        });
        return enchantments;
    }

    static Map<Enchantment, Integer> buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        LinkedHashMap<Enchantment, Integer> enchantments = new LinkedHashMap<Enchantment, Integer>(ench.size());
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment;
            String enchantKey = entry.getKey().toString();
            if (enchantKey.equals("SWEEPING")) {
                enchantKey = "SWEEPING_EDGE";
            }
            if ((enchantment = Enchantment.getByName((String)enchantKey)) == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    public void setHideTooltip(boolean hideTooltip) {
        this.tooltipDisplay = this.tooltipDisplay == null ? new class_10712(hideTooltip, (SequencedSet)new ReferenceLinkedOpenHashSet()) : new class_10712(hideTooltip, this.tooltipDisplay.comp_3601());
    }

    public void setEnchantmentGlintOverride(Boolean override) {
        this.enchantmentGlintOverride = override;
    }

    public void setMaxStackSize(Integer max) {
        Preconditions.checkArgument((max == null || max > 0 ? 1 : 0) != 0, (Object)"max_stack_size must be > 0");
        Preconditions.checkArgument((max == null || max <= 99 ? 1 : 0) != 0, (Object)"max_stack_size must be <= 99");
        this.maxStackSize = max;
    }

    public void setRarity(ItemRarity rarity) {
        this.rarity = rarity;
    }

    public void setMaxDamage(Integer maxDamage) {
        this.maxDamage = maxDamage;
    }

    CraftMetaItem(Map<String, Object> map) {
        String custom;
        Object nbtMap;
        String unhandled;
        String internal;
        Integer maxDamage;
        Integer damage;
        CraftEquippableComponent equippable;
        CraftToolComponent tool;
        CraftUseCooldownComponent cooldown;
        ItemStack remainder;
        String rarity;
        Integer maxStackSize;
        Tag tag;
        String damageResistant;
        Boolean glider;
        Boolean enchantmentGlintOverride;
        Boolean unbreakable;
        String itemModel;
        String tooltipStyle;
        ItemFlag hideFlatEnum2;
        String hideFlagString;
        Iterable hideFlags;
        Object blockData;
        Integer enchantmentValue;
        Integer customModelData;
        this.displayName = CraftChatMessage.fromJSONOrString(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true), true, false);
        this.itemName = CraftChatMessage.fromJSONOrNull(SerializableMeta.getString(map, CraftMetaItem.ITEM_NAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<class_2561>();
            CraftMetaItem.safelyAdd(lore, this.lore, true);
        }
        if ((customModelData = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, true)) != null) {
            this.setCustomModelData(customModelData);
        }
        if ((enchantmentValue = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.ENCHANTABLE.BUKKIT, true)) != null) {
            this.setEnchantable(enchantmentValue);
        }
        if ((blockData = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BLOCK_DATA.BUKKIT, true)) != null) {
            HashMap<String, String> mapBlockData = new HashMap<String, String>();
            class_2487 nbtBlockData = (class_2487)CraftNBTTagConfigSerializer.deserialize(blockData);
            for (String key : nbtBlockData.method_10541()) {
                mapBlockData.put(key, (String)nbtBlockData.method_10558(key).orElseThrow());
            }
            this.blockData = mapBlockData;
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        this.attributeModifiers = CraftMetaItem.buildModifiers(map, ATTRIBUTES);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
        if ((hideFlags = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.HIDEFLAGS.BUKKIT, true)) != null) {
            for (Object hideFlagObject : hideFlags) {
                hideFlagString = (String)hideFlagObject;
                try {
                    hideFlatEnum2 = ItemFlag.valueOf((String)hideFlagString);
                    this.addItemFlags(hideFlatEnum2);
                }
                catch (IllegalArgumentException hideFlatEnum2) {}
            }
        }
        if ((hideFlags = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.HIDEFLAGS.BUKKIT, true)) != null) {
            for (Object hideFlagObject : hideFlags) {
                hideFlagString = (String)hideFlagObject;
                try {
                    hideFlatEnum2 = CraftItemFlag.stringToBukkit(hideFlagString);
                    this.addItemFlags(hideFlatEnum2);
                }
                catch (IllegalArgumentException hideFlatEnum3) {}
            }
        }
        if ((tooltipStyle = SerializableMeta.getString(map, CraftMetaItem.TOOLTIP_STYLE.BUKKIT, true)) != null) {
            this.setTooltipStyle(NamespacedKey.fromString((String)tooltipStyle));
        }
        if ((itemModel = SerializableMeta.getString(map, CraftMetaItem.ITEM_MODEL.BUKKIT, true)) != null) {
            this.setItemModel(NamespacedKey.fromString((String)itemModel));
        }
        if ((unbreakable = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.UNBREAKABLE.BUKKIT, true)) != null) {
            this.setUnbreakable(unbreakable);
        }
        if ((enchantmentGlintOverride = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, true)) != null) {
            this.setEnchantmentGlintOverride(enchantmentGlintOverride);
        }
        if ((glider = SerializableMeta.getObject(Boolean.class, map, CraftMetaItem.GLIDER.BUKKIT, true)) != null) {
            this.setGlider(glider);
        }
        if ((damageResistant = SerializableMeta.getString(map, CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, true)) != null && (tag = Bukkit.getTag((String)"damage_types", (NamespacedKey)NamespacedKey.fromString((String)damageResistant), DamageType.class)) != null) {
            this.setDamageResistant((Tag<DamageType>)tag);
        }
        if ((maxStackSize = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_STACK_SIZE.BUKKIT, true)) != null) {
            this.setMaxStackSize(maxStackSize);
        }
        if ((rarity = SerializableMeta.getString(map, CraftMetaItem.RARITY.BUKKIT, true)) != null) {
            this.setRarity(ItemRarity.valueOf((String)rarity));
        }
        if ((remainder = SerializableMeta.getObject(ItemStack.class, map, CraftMetaItem.USE_REMAINDER.BUKKIT, true)) != null) {
            this.setUseRemainder(remainder);
        }
        if ((cooldown = SerializableMeta.getObject(CraftUseCooldownComponent.class, map, CraftMetaItem.USE_COOLDOWN.BUKKIT, true)) != null) {
            this.setUseCooldown(cooldown);
        }
        if ((tool = SerializableMeta.getObject(CraftToolComponent.class, map, CraftMetaItem.TOOL.BUKKIT, true)) != null) {
            this.setTool(tool);
        }
        if ((equippable = SerializableMeta.getObject(CraftEquippableComponent.class, map, CraftMetaItem.EQUIPPABLE.BUKKIT, true)) != null) {
            this.setEquippable(equippable);
        }
        if ((damage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.DAMAGE.BUKKIT, true)) != null) {
            this.setDamage(damage);
        }
        if ((maxDamage = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.MAX_DAMAGE.BUKKIT, true)) != null) {
            this.setMaxDamage(maxDamage);
        }
        if ((internal = SerializableMeta.getString(map, "internal", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(internal));
            try {
                class_2487 internalTag = class_2507.method_10629((InputStream)buf, (class_2505)class_2505.method_53898());
                this.deserializeInternal(internalTag, map);
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((unhandled = SerializableMeta.getString(map, "unhandled", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(internal));
            try {
                class_2487 unhandledTag = class_2507.method_10629((InputStream)buf, (class_2505)class_2505.method_53898());
                class_6903 ops = ICommonMod.getIServer().getMinecraft().method_30611().method_57093((DynamicOps)class_2509.field_11560);
                ((IComponentChanges)this.unhandledTags.method_57852()).copy((class_9326)class_9326.field_49589.parse((DynamicOps)ops, (Object)unhandledTag).result().get());
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((nbtMap = SerializableMeta.getObject(Object.class, map, CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, true)) != null) {
            this.persistentDataContainer.putAll((class_2487)CraftNBTTagConfigSerializer.deserialize(nbtMap));
        }
        if ((custom = SerializableMeta.getString(map, "custom", true)) != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(custom));
            try {
                this.customTag = class_2507.method_10629((InputStream)buf, (class_2505)class_2505.method_53898());
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    void deserializeInternal(class_2487 tag, Object context) {
        if (tag.method_10554(CraftMetaItem.ATTRIBUTES.NBT).isPresent()) {
            this.attributeModifiers = CraftMetaItem.buildModifiersLegacy(tag, ATTRIBUTES);
        }
    }

    private static Multimap<Attribute, AttributeModifier> buildModifiersLegacy(class_2487 tag, ItemMetaKey key) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        class_2499 mods = tag.method_68569(key.NBT);
        int size = mods.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Attribute attribute;
            class_1322 nmsModifier;
            class_2487 entry = mods.method_68582(i2);
            if (entry.method_33133() || (nmsModifier = (class_1322)class_1322.field_46247.parse((DynamicOps)class_2509.field_11560, (Object)entry).resultOrPartial().orElse(null)) == null) continue;
            AttributeModifier attribMod = CraftAttributeInstance.convert(nmsModifier);
            String attributeName = entry.method_10558(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT).map(CraftAttributeMap::convertIfNeeded).orElse(null);
            if (attributeName == null || attributeName.isEmpty() || (attribute = CraftAttribute.stringToBukkit(attributeName)) == null) continue;
            Optional attributeSlot = entry.method_10558(CraftMetaItem.ATTRIBUTES_SLOT.NBT);
            if (attributeSlot.isPresent()) {
                String slotName = (String)attributeSlot.get();
                if (slotName.isEmpty()) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                EquipmentSlot slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlot(class_1304.method_5924((String)slotName.toLowerCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot.getGroup());
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    static Multimap<Attribute, AttributeModifier> buildModifiers(class_9285 tag) {
        LinkedHashMultimap modifiers = LinkedHashMultimap.create();
        List mods = tag.comp_2393();
        int size = mods.size();
        for (int i = 0; i < size; ++i) {
            class_9285.class_9287 entry = (class_9285.class_9287)mods.get(i);
            class_1322 nmsModifier = entry.comp_2396();
            if (nmsModifier == null) continue;
            AttributeModifier attribMod = CardboardAttributeInstance.convert(nmsModifier);
            Attribute attribute = CraftAttribute.minecraftHolderToBukkit((class_6880<class_1320>)entry.comp_2395());
            if (attribute == null) continue;
            if (entry.comp_2397() != null) {
                class_9274 slotName = entry.comp_2397();
                if (slotName == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                EquipmentSlotGroup slot = null;
                try {
                    slot = CraftEquipmentSlot.getSlotGroup(slotName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (slot == null) {
                    modifiers.put((Object)attribute, (Object)attribMod);
                    continue;
                }
                attribMod = new AttributeModifier(attribMod.getKey(), attribMod.getAmount(), attribMod.getOperation(), slot);
            }
            modifiers.put((Object)attribute, (Object)attribMod);
        }
        return modifiers;
    }

    static Multimap<Attribute, AttributeModifier> buildModifiers(Map<String, Object> map, ItemMetaKey key) {
        Map mods = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        LinkedHashMultimap result = LinkedHashMultimap.create();
        if (mods == null) {
            return null;
        }
        for (Object obj : mods.keySet()) {
            String attributeName;
            if (!(obj instanceof String) || Strings.isNullOrEmpty((String)(attributeName = (String)obj))) continue;
            List list = SerializableMeta.getObject(List.class, mods, attributeName, true);
            if (list == null || list.isEmpty()) {
                return result;
            }
            for (Object o : list) {
                if (!(o instanceof AttributeModifier)) continue;
                AttributeModifier modifier = (AttributeModifier)o;
                Attribute attribute = CraftAttribute.stringToBukkit(attributeName);
                if (attribute == null) continue;
                result.put((Object)attribute, (Object)modifier);
            }
        }
        return result;
    }

    void applyToItem(Applicator itemTag) {
        if (this.hasDisplayName()) {
            itemTag.put(NAME, this.displayName);
        }
        if (this.hasItemName()) {
            itemTag.put(ITEM_NAME, this.itemName);
        }
        if (this.lore != null) {
            itemTag.put(LORE, new class_9290(this.lore));
        }
        if (this.hasCustomModelData()) {
            itemTag.put(CUSTOM_MODEL_DATA, this.customModelData.getHandle());
        }
        if (this.hasEnchantable()) {
            itemTag.put(ENCHANTABLE, new class_9889(this.enchantableValue.intValue()));
        }
        if (this.hasBlockData()) {
            itemTag.put(BLOCK_DATA, new class_9275(this.blockData));
        }
        this.applyEnchantments(this.enchantments, itemTag, ENCHANTMENTS, ItemFlag.HIDE_ENCHANTS);
        this.applyModifiers(this.attributeModifiers, itemTag);
        if (this.hasRepairCost()) {
            itemTag.put(REPAIR, this.repairCost);
        }
        if (this.tooltipDisplay != null) {
            itemTag.put(TOOLTIP_DISPLAY, new class_10712(this.tooltipDisplay.comp_3600(), (SequencedSet)new ReferenceLinkedOpenHashSet((Collection)this.tooltipDisplay.comp_3601())));
        }
        if (this.hasTooltipStyle()) {
            itemTag.put(TOOLTIP_STYLE, CraftNamespacedKey.toMinecraft(this.getTooltipStyle()));
        }
        if (this.hasItemModel()) {
            itemTag.put(ITEM_MODEL, CraftNamespacedKey.toMinecraft(this.getItemModel()));
        }
        if (this.isUnbreakable()) {
            itemTag.put(UNBREAKABLE, class_3902.field_17274);
        }
        if (this.hasEnchantmentGlintOverride()) {
            itemTag.put(ENCHANTMENT_GLINT_OVERRIDE, this.getEnchantmentGlintOverride());
        }
        if (this.isGlider()) {
            itemTag.put(GLIDER, class_3902.field_17274);
        }
        if (this.hasDamageResistant()) {
            itemTag.put(DAMAGE_RESISTANT, new class_10215(this.damageResistant));
        }
        if (this.hasMaxStackSize()) {
            itemTag.put(MAX_STACK_SIZE, this.maxStackSize);
        }
        if (this.hasRarity()) {
            itemTag.put(RARITY, class_1814.valueOf((String)this.rarity.name()));
        }
        if (this.hasUseRemainder()) {
            itemTag.put(USE_REMAINDER, new class_10131(CraftItemStack.asNMSCopy(this.useRemainder)));
        }
        if (this.hasUseCooldown()) {
            itemTag.put(USE_COOLDOWN, this.useCooldown.getHandle());
        }
        if (this.hasFood()) {
            // empty if block
        }
        if (this.hasTool()) {
            itemTag.put(TOOL, this.tool.getHandle());
        }
        if (this.hasEquippable()) {
            itemTag.put(EQUIPPABLE, this.equippable.getHandle());
        }
        if (this.hasDamage()) {
            itemTag.put(DAMAGE, this.damage);
        }
        if (this.hasDamageValue()) {
            itemTag.put(DAMAGE, this.damage);
        }
        if (this.hasMaxDamage()) {
            itemTag.put(MAX_DAMAGE, this.maxDamage);
        }
        if (this.canPlaceOnPredicates != null && !this.canPlaceOnPredicates.isEmpty()) {
            itemTag.put(CAN_PLACE_ON, new class_6538(this.canPlaceOnPredicates));
        }
        if (this.canBreakPredicates != null && !this.canBreakPredicates.isEmpty()) {
            itemTag.put(CAN_BREAK, new class_6538(this.canBreakPredicates));
        }
        for (Map.Entry e : this.unhandledTags.method_57852().method_57846()) {
            ((Optional)e.getValue()).ifPresent(value -> itemTag.builder.method_57854((class_9331)e.getKey(), value));
        }
        if (!this.persistentDataContainer.isEmpty()) {
            class_2487 bukkitCustomCompound = new class_2487();
            Map<String, class_2520> rawPublicMap = this.persistentDataContainer.getRaw();
            for (Map.Entry<String, class_2520> nbtBaseEntry : rawPublicMap.entrySet()) {
                bukkitCustomCompound.method_10566(nbtBaseEntry.getKey(), nbtBaseEntry.getValue());
            }
            if (this.customTag == null) {
                this.customTag = new class_2487();
            }
            this.customTag.method_10566(CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, (class_2520)bukkitCustomCompound);
        }
        if (this.customTag != null) {
            itemTag.put(CUSTOM_DATA, class_9279.method_57456((class_2487)this.customTag));
        }
    }

    class_2499 createStringList(List<class_2561> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        class_2499 tagList = new class_2499();
        for (class_2561 value : list) {
            tagList.add((Object)class_2519.method_23256((String)(this.version <= 0 || this.version >= 1803 ? CraftChatMessage.toJSON(value) : CraftChatMessage.fromComponent(value, class_124.field_1064))));
        }
        return tagList;
    }

    void applyEnchantments(Map<Enchantment, Integer> enchantments, Applicator tag, ItemMetaKeyType<class_9304> key, ItemFlag itemFlag) {
        if (enchantments == null) {
            return;
        }
        class_9304.class_9305 list = new class_9304.class_9305(class_9304.field_49385);
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            list.method_57547(CardboardEnchantment.bukkitToMinecraftHolder(entry.getKey()), entry.getValue().intValue());
        }
        tag.put(key, list.method_57549());
    }

    void applyModifiers(Multimap<Attribute, AttributeModifier> modifiers, Applicator tag) {
        if (modifiers == null) {
            return;
        }
        class_9285.class_9286 list = class_9285.method_57480();
        for (Map.Entry entry : modifiers.entries()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            class_1322 nmsModifier = CraftAttributeInstance.convert((AttributeModifier)entry.getValue());
            class_6880<class_1320> name = CraftAttribute.bukkitToMinecraftHolder((Attribute)entry.getKey());
            if (name == null) continue;
            class_9274 group = class_9274.field_49216;
            list.method_57487(name, nmsModifier, group);
        }
        tag.put(ATTRIBUTES, list.method_57486());
    }

    boolean applicableTo(Material type) {
        return type != Material.AIR;
    }

    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasItemName() && !this.hasLocalizedName() && !this.hasEnchants() && this.lore == null && !this.hasCustomModelData() && !this.hasBlockData() && !this.hasRepairCost() && this.unhandledTags.method_57852().method_57848() && this.persistentDataContainer.isEmpty() && !this.isHideTooltip() && !this.isUnbreakable() && !this.hasEnchantmentGlintOverride() && !this.isFireResistant() && !this.hasMaxStackSize() && !this.hasRarity() && !this.hasFood() && !this.hasDamage() && !this.hasMaxDamage() && !this.hasAttributeModifiers() && this.customTag == null;
    }

    public String getDisplayName() {
        return CraftChatMessage.fromComponent(this.displayName, class_124.field_1068);
    }

    public final void setDisplayName(String name) {
        this.displayName = CraftChatMessage.wrapOrNull(name);
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public String getLocalizedName() {
        return this.getDisplayName();
    }

    public void setLocalizedName(String name) {
    }

    public boolean hasLocalizedName() {
        return false;
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    public boolean hasEnchant(Enchantment ench) {
        return this.hasEnchants() && this.enchantments.containsKey(ench);
    }

    public int getEnchantLevel(Enchantment ench) {
        Validate.notNull(ench, "Enchantment cannot be null");
        Integer level = this.hasEnchants() ? this.enchantments.get(ench) : null;
        return level == null ? 0 : level;
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableMap.copyOf(this.enchantments) : ImmutableMap.of();
    }

    public boolean addEnchant(Enchantment ench, int level, boolean ignoreRestrictions) {
        if (this.enchantments == null) {
            this.enchantments = new LinkedHashMap<Enchantment, Integer>(4);
        }
        if (ignoreRestrictions || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            Integer old = this.enchantments.put(ench, level);
            return old == null || old != level;
        }
        return false;
    }

    public boolean removeEnchant(Enchantment ench) {
        boolean b;
        boolean bl = b = this.hasEnchants() && this.enchantments.remove(ench) != null;
        if (this.enchantments != null && this.enchantments.isEmpty()) {
            this.enchantments = null;
        }
        return b;
    }

    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    public boolean hasConflictingEnchant(Enchantment ench) {
        return CraftMetaItem.checkConflictingEnchants(this.enchantments, ench);
    }

    public void addItemFlags(ItemFlag ... hideFlags) {
        if (this.tooltipDisplay == null) {
            this.tooltipDisplay = new class_10712(false, (SequencedSet)new ReferenceLinkedOpenHashSet());
        }
        for (ItemFlag f : hideFlags) {
            this.tooltipDisplay.comp_3601().addAll((Collection)ITEM_FLAG_EQUIVALENTS.get(f));
        }
    }

    public void removeItemFlags(ItemFlag ... hideFlags) {
        if (this.tooltipDisplay == null) {
            return;
        }
        for (ItemFlag f : hideFlags) {
            Set<class_9331<?>> dataComponentTypes = ITEM_FLAG_EQUIVALENTS.get(f);
            if (!this.tooltipDisplay.comp_3601().containsAll(dataComponentTypes)) continue;
            this.tooltipDisplay.comp_3601().removeAll(dataComponentTypes);
        }
    }

    public Set<ItemFlag> getItemFlags() {
        EnumSet<ItemFlag> currentFlags = EnumSet.noneOf(ItemFlag.class);
        for (ItemFlag f : ItemFlag.values()) {
            if (!this.hasItemFlag(f)) continue;
            currentFlags.add(f);
        }
        return currentFlags;
    }

    public boolean hasItemFlag(ItemFlag flag) {
        if (this.tooltipDisplay == null) {
            return false;
        }
        return this.tooltipDisplay.comp_3601().containsAll((Collection)ITEM_FLAG_EQUIVALENTS.get(flag));
    }

    private byte getBitModifier1(ItemFlag hideFlag) {
        return (byte)(1 << hideFlag.ordinal());
    }

    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList(Lists.transform(this.lore, line -> CraftChatMessage.fromComponent(line, class_124.field_1064)));
    }

    public void setLore(List<String> lore) {
        if (lore == null) {
            this.lore = null;
        } else if (this.lore == null) {
            this.lore = new ArrayList<class_2561>(lore.size());
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        } else {
            this.lore.clear();
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        }
    }

    public boolean hasCustomModelData() {
        return this.customModelData != null;
    }

    public int getCustomModelData() {
        Preconditions.checkState((boolean)this.hasCustomModelData(), (Object)"We don't have CustomModelData! Check hasCustomModelData first!");
        List<Float> floats = this.customModelData.getFloats();
        Preconditions.checkState((!floats.isEmpty() ? 1 : 0) != 0, (Object)"No numeric custom model data");
        return floats.get(0).intValue();
    }

    public void setCustomModelData(Integer data) {
        this.customModelData = data == null ? null : new CraftCustomModelDataComponent(new class_9280(List.of(Float.valueOf(data.floatValue())), List.of(), List.of(), List.of()));
    }

    public boolean hasBlockData() {
        return this.blockData != null;
    }

    public BlockData getBlockData(Material material) {
        class_2680 defaultData = CraftBlockType.bukkitToMinecraft(material).method_9564();
        return CraftBlockData.fromData(this.hasBlockData() ? new class_9275(this.blockData).method_57415(defaultData) : defaultData);
    }

    public void setBlockData(BlockData blockData) {
        this.blockData = blockData == null ? null : ((CraftBlockData)blockData).toStates();
    }

    public int getRepairCost() {
        return this.repairCost;
    }

    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean hasAttributeModifiers() {
        return this.attributeModifiers != null && !this.attributeModifiers.isEmpty();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.hasAttributeModifiers() ? ImmutableMultimap.copyOf(this.attributeModifiers) : null;
    }

    private void checkAttributeList() {
        if (this.attributeModifiers == null) {
            this.attributeModifiers = LinkedHashMultimap.create();
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot) {
        this.checkAttributeList();
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            if (((AttributeModifier)entry.getValue()).getSlot() != null && ((AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            result.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
        }
        return result;
    }

    public Collection<AttributeModifier> getAttributeModifiers(Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        return this.attributeModifiers.containsKey((Object)attribute) ? ImmutableList.copyOf((Collection)this.attributeModifiers.get((Object)attribute)) : null;
    }

    public boolean addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        for (Map.Entry entry : this.attributeModifiers.entries()) {
            Preconditions.checkArgument((!((AttributeModifier)entry.getValue()).getUniqueId().equals(modifier.getUniqueId()) ? 1 : 0) != 0, (String)"Cannot register AttributeModifier. Modifier is already applied! %s", (Object)modifier);
        }
        return this.attributeModifiers.put((Object)attribute, (Object)modifier);
    }

    public void setAttributeModifiers(Multimap<Attribute, AttributeModifier> attributeModifiers) {
        if (attributeModifiers == null || attributeModifiers.isEmpty()) {
            this.attributeModifiers = LinkedHashMultimap.create();
            return;
        }
        this.checkAttributeList();
        this.attributeModifiers.clear();
        Iterator iterator = attributeModifiers.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (next.getKey() == null || next.getValue() == null) {
                iterator.remove();
                continue;
            }
            this.attributeModifiers.put((Object)((Attribute)next.getKey()), (Object)((AttributeModifier)next.getValue()));
        }
    }

    public boolean removeAttributeModifier(Attribute attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        this.checkAttributeList();
        return !this.attributeModifiers.removeAll((Object)attribute).isEmpty();
    }

    public boolean removeAttributeModifier(EquipmentSlot slot) {
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (((AttributeModifier)entry.getValue()).getSlot() != null && ((AttributeModifier)entry.getValue()).getSlot() != slot) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public boolean removeAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        Preconditions.checkNotNull((Object)attribute, (Object)"Attribute cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        this.checkAttributeList();
        int removed = 0;
        Iterator iter = this.attributeModifiers.entries().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (entry.getKey() == null || entry.getValue() == null) {
                iter.remove();
                ++removed;
                continue;
            }
            if (entry.getKey() != attribute || !((AttributeModifier)entry.getValue()).getUniqueId().equals(modifier.getUniqueId())) continue;
            iter.remove();
            ++removed;
        }
        return removed > 0;
    }

    public CustomItemTagContainer getCustomTagContainer() {
        return new DeprecatedCustomTagContainer(this.getPersistentDataContainer());
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    private static boolean compareModifiers(Multimap<Attribute, AttributeModifier> first, Multimap<Attribute, AttributeModifier> second) {
        if (first == null || second == null) {
            return false;
        }
        for (Map.Entry entry : first.entries()) {
            if (second.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        for (Map.Entry entry : second.entries()) {
            if (first.containsEntry(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean hasDamage() {
        return this.damage != null && this.damage > 0;
    }

    public int getDamage() {
        return this.damage == null ? 0 : this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    boolean equalsCommon(CraftMetaItem meta) {
        return (this.hasDisplayName() ? meta.hasDisplayName() && this.displayName.equals((Object)meta.displayName) : !meta.hasDisplayName()) && (this.hasItemName() ? meta.hasItemName() && this.itemName.equals((Object)meta.itemName) : !meta.hasItemName()) && (this.hasEnchants() ? meta.hasEnchants() && this.enchantments.equals(meta.enchantments) : !meta.hasEnchants()) && Objects.equals(this.lore, meta.lore) && (this.hasCustomModelData() ? meta.hasCustomModelData() && this.customModelData.equals(meta.customModelData) : !meta.hasCustomModelData()) && (this.hasEnchantable() ? meta.hasEnchantable() && this.enchantableValue.equals(meta.enchantableValue) : !meta.hasEnchantable()) && (this.hasBlockData() ? meta.hasBlockData() && this.blockData.equals(meta.blockData) : !meta.hasBlockData()) && (this.hasRepairCost() ? meta.hasRepairCost() && this.repairCost == meta.repairCost : !meta.hasRepairCost()) && (this.attributeModifiers != null ? meta.attributeModifiers != null && CraftMetaItem.compareModifiers(this.attributeModifiers, meta.attributeModifiers) : meta.attributeModifiers == null) && this.unhandledTags.equals(meta.unhandledTags) && Objects.equals(this.customTag, meta.customTag) && this.persistentDataContainer.equals(meta.persistentDataContainer) && Objects.equals(this.tooltipDisplay, meta.tooltipDisplay) && this.isHideTooltip() == meta.isHideTooltip() && (this.hasTooltipStyle() ? meta.hasTooltipStyle() && this.tooltipStyle.equals((Object)meta.tooltipStyle) : !meta.hasTooltipStyle()) && (this.hasItemModel() ? meta.hasItemModel() && this.itemModel.equals((Object)meta.itemModel) : !meta.hasItemModel()) && this.isUnbreakable() == meta.isUnbreakable() && (this.hasEnchantmentGlintOverride() ? meta.hasEnchantmentGlintOverride() && this.enchantmentGlintOverride.equals(meta.enchantmentGlintOverride) : !meta.hasEnchantmentGlintOverride()) && this.glider == meta.glider && (this.hasDamageResistant() ? meta.hasDamageResistant() && this.damageResistant.equals(meta.damageResistant) : !meta.hasDamageResistant()) && (this.hasMaxStackSize() ? meta.hasMaxStackSize() && this.maxStackSize.equals(meta.maxStackSize) : !meta.hasMaxStackSize()) && this.rarity == meta.rarity && (this.hasUseRemainder() ? meta.hasUseRemainder() && this.useRemainder.equals((Object)meta.useRemainder) : !meta.hasUseRemainder()) && (this.hasUseCooldown() ? meta.hasUseCooldown() && this.useCooldown.equals(meta.useCooldown) : !meta.hasUseCooldown()) && (this.hasTool() ? meta.hasTool() && this.tool.equals(meta.tool) : !meta.hasTool()) && (this.hasEquippable() ? meta.hasEquippable() && this.equippable.equals(meta.equippable) : !meta.hasEquippable()) && (this.hasJukeboxPlayable() ? meta.hasJukeboxPlayable() : !meta.hasJukeboxPlayable()) && Objects.equals(this.damage, meta.damage) && (this.hasMaxDamage() ? meta.hasMaxDamage() && this.maxDamage.equals(meta.maxDamage) : !meta.hasMaxDamage()) && (this.canPlaceOnPredicates != null ? meta.canPlaceOnPredicates != null && this.canPlaceOnPredicates.equals(meta.canPlaceOnPredicates) : meta.canPlaceOnPredicates == null) && (this.canBreakPredicates != null ? meta.canBreakPredicates != null && this.canBreakPredicates.equals(meta.canBreakPredicates) : meta.canBreakPredicates == null) && this.version == meta.version;
    }

    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    public boolean hasMaxStackSize() {
        return this.maxStackSize != null;
    }

    public boolean hasItemName() {
        return this.itemName != null;
    }

    public boolean isHideTooltip() {
        return this.tooltipDisplay != null && this.tooltipDisplay.comp_3600();
    }

    public boolean hasEnchantmentGlintOverride() {
        return this.enchantmentGlintOverride != null;
    }

    public Boolean getEnchantmentGlintOverride() {
        Preconditions.checkState((boolean)this.hasEnchantmentGlintOverride(), (Object)"Check hasEnchantmentGlintOverride first!");
        return this.enchantmentGlintOverride;
    }

    public boolean isFireResistant() {
        return this.fireResistant;
    }

    public void setFireResistant(boolean fireResistant) {
        this.fireResistant = fireResistant;
    }

    public boolean hasRarity() {
        return this.rarity != null;
    }

    public ItemRarity getRarity() {
        Preconditions.checkState((boolean)this.hasRarity(), (Object)"We don't have rarity! Check hasRarity first!");
        return this.rarity;
    }

    public boolean hasFood() {
        return false;
    }

    public boolean hasMaxDamage() {
        return this.maxDamage != null;
    }

    public int getMaxDamage() {
        Preconditions.checkState((boolean)this.hasMaxDamage(), (Object)"We don't have max_damage! Check hasMaxDamage first!");
        return this.maxDamage;
    }

    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasItemName() ? this.itemName.hashCode() : 0);
        hash = 61 * hash + (this.lore != null ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasCustomModelData() ? this.customModelData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchantable() ? this.enchantableValue.hashCode() : 0);
        hash = 61 * hash + (this.hasBlockData() ? this.blockData.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        hash = 61 * hash + this.unhandledTags.hashCode();
        hash = 61 * hash + 0;
        hash = 61 * hash + (this.customTag != null ? this.customTag.hashCode() : 0);
        hash = 61 * hash + (!this.persistentDataContainer.isEmpty() ? this.persistentDataContainer.hashCode() : 0);
        hash = 61 * hash + (this.tooltipDisplay != null ? this.tooltipDisplay.hashCode() : 0);
        hash = 61 * hash + (this.isHideTooltip() ? 1231 : 1237);
        hash = 61 * hash + (this.hasTooltipStyle() ? this.tooltipStyle.hashCode() : 0);
        hash = 61 * hash + (this.hasItemModel() ? this.itemModel.hashCode() : 0);
        hash = 61 * hash + (this.isUnbreakable() ? 1231 : 1237);
        hash = 61 * hash + (this.hasEnchantmentGlintOverride() ? this.enchantmentGlintOverride.hashCode() : 0);
        hash = 61 * hash + (this.isGlider() ? 1231 : 1237);
        hash = 61 * hash + (this.hasDamageResistant() ? this.damageResistant.hashCode() : 0);
        hash = 61 * hash + (this.hasMaxStackSize() ? this.maxStackSize.hashCode() : 0);
        hash = 61 * hash + (this.hasRarity() ? this.rarity.hashCode() : 0);
        hash = 61 * hash + (this.hasUseRemainder() ? this.useRemainder.hashCode() : 0);
        hash = 61 * hash + (this.hasUseCooldown() ? this.useCooldown.hashCode() : 0);
        hash = 61 * hash + 0;
        hash = 61 * hash + (this.hasTool() ? this.tool.hashCode() : 0);
        hash = 61 * hash + 0;
        hash = 61 * hash + (this.hasEquippable() ? this.equippable.hashCode() : 0);
        hash = 61 * hash + (this.hasDamageValue() ? this.damage : -1);
        hash = 61 * hash + (this.hasMaxDamage() ? this.maxDamage.hashCode() : 0);
        hash = 61 * hash + (this.attributeModifiers != null ? this.attributeModifiers.hashCode() : 0);
        hash = 61 * hash + (this.canPlaceOnPredicates != null ? this.canPlaceOnPredicates.hashCode() : 0);
        hash = 61 * hash + (this.canBreakPredicates != null ? this.canBreakPredicates.hashCode() : 0);
        hash = 61 * hash + this.version;
        return hash;
    }

    public CraftMetaItem clone() {
        try {
            CraftMetaItem clone = (CraftMetaItem)super.clone();
            if (this.lore != null) {
                clone.lore = new ArrayList<class_2561>(this.lore);
            }
            if (this.hasCustomModelData()) {
                clone.customModelData = new CraftCustomModelDataComponent(this.customModelData);
            }
            clone.enchantableValue = this.enchantableValue;
            clone.blockData = this.blockData;
            if (this.enchantments != null) {
                clone.enchantments = new LinkedHashMap<Enchantment, Integer>(this.enchantments);
            }
            if (this.attributeModifiers != null) {
                clone.attributeModifiers = LinkedHashMultimap.create(this.attributeModifiers);
            }
            if (this.customTag != null) {
                clone.customTag = this.customTag.method_10553();
            }
            clone.persistentDataContainer = new CraftPersistentDataContainer(this.persistentDataContainer.getRaw(), DATA_TYPE_REGISTRY);
            if (this.tooltipDisplay != null) {
                clone.tooltipDisplay = new class_10712(this.tooltipDisplay.comp_3600(), (SequencedSet)new ReferenceLinkedOpenHashSet((Collection)this.tooltipDisplay.comp_3601()));
            }
            clone.hideTooltip = this.hideTooltip;
            clone.tooltipStyle = this.tooltipStyle;
            clone.itemModel = this.itemModel;
            clone.unbreakable = this.unbreakable;
            clone.enchantmentGlintOverride = this.enchantmentGlintOverride;
            clone.glider = this.glider;
            clone.damageResistant = this.damageResistant;
            clone.maxStackSize = this.maxStackSize;
            clone.rarity = this.rarity;
            if (this.hasUseRemainder()) {
                clone.useRemainder = this.useRemainder.clone();
            }
            if (this.hasUseCooldown()) {
                clone.useCooldown = new CraftUseCooldownComponent(this.useCooldown);
            }
            if (this.hasFood()) {
                // empty if block
            }
            if (this.hasTool()) {
                clone.tool = new CraftToolComponent(this.tool);
            }
            if (this.hasEquippable()) {
                clone.equippable = new CraftEquippableComponent(this.equippable);
            }
            if (this.hasJukeboxPlayable()) {
                // empty if block
            }
            clone.damage = this.damage;
            clone.maxDamage = this.maxDamage;
            clone.version = this.version;
            if (this.canPlaceOnPredicates != null) {
                clone.canPlaceOnPredicates = List.copyOf(this.canPlaceOnPredicates);
            }
            if (this.canBreakPredicates != null) {
                clone.canBreakPredicates = List.copyOf(this.canBreakPredicates);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.displayName));
        }
        if (this.hasItemName()) {
            builder.put((Object)CraftMetaItem.ITEM_NAME.BUKKIT, (Object)CraftChatMessage.toJSON(this.itemName));
        }
        if (this.hasLore()) {
            ArrayList<String> jsonLore = new ArrayList<String>();
            for (class_2561 component : this.lore) {
                jsonLore.add(CraftChatMessage.toJSON(component));
            }
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, jsonLore);
        }
        if (this.hasCustomModelData()) {
            builder.put((Object)CraftMetaItem.CUSTOM_MODEL_DATA.BUKKIT, (Object)this.customModelData);
        }
        if (this.hasEnchantable()) {
            builder.put((Object)CraftMetaItem.ENCHANTABLE.BUKKIT, (Object)this.enchantableValue);
        }
        if (this.hasBlockData()) {
            builder.put((Object)CraftMetaItem.BLOCK_DATA.BUKKIT, this.blockData);
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        CraftMetaItem.serializeModifiers(this.attributeModifiers, builder, ATTRIBUTES);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        ArrayList<String> hideFlags = new ArrayList<String>();
        for (ItemFlag hideFlagEnum : this.getItemFlags()) {
            hideFlags.add(hideFlagEnum.name());
        }
        if (!hideFlags.isEmpty()) {
            builder.put((Object)CraftMetaItem.HIDEFLAGS.BUKKIT, hideFlags);
        }
        if (this.hasTooltipStyle()) {
            builder.put((Object)CraftMetaItem.TOOLTIP_STYLE.BUKKIT, (Object)this.tooltipStyle.toString());
        }
        if (this.hasItemModel()) {
            builder.put((Object)CraftMetaItem.ITEM_MODEL.BUKKIT, (Object)this.itemModel.toString());
        }
        if (this.isUnbreakable()) {
            builder.put((Object)CraftMetaItem.UNBREAKABLE.BUKKIT, (Object)this.unbreakable);
        }
        if (this.hasEnchantmentGlintOverride()) {
            builder.put((Object)CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.BUKKIT, (Object)this.enchantmentGlintOverride);
        }
        if (this.isGlider()) {
            builder.put((Object)CraftMetaItem.GLIDER.BUKKIT, (Object)this.glider);
        }
        if (this.hasDamageResistant()) {
            builder.put((Object)CraftMetaItem.DAMAGE_RESISTANT.BUKKIT, (Object)this.damageResistant.comp_327().toString());
        }
        if (this.hasMaxStackSize()) {
            builder.put((Object)CraftMetaItem.MAX_STACK_SIZE.BUKKIT, (Object)this.maxStackSize);
        }
        if (this.hasRarity()) {
            builder.put((Object)CraftMetaItem.RARITY.BUKKIT, (Object)this.rarity.name());
        }
        if (this.hasUseRemainder()) {
            builder.put((Object)CraftMetaItem.USE_REMAINDER.BUKKIT, (Object)this.useRemainder);
        }
        if (this.hasUseCooldown()) {
            builder.put((Object)CraftMetaItem.USE_COOLDOWN.BUKKIT, (Object)this.useCooldown);
        }
        if (this.hasFood()) {
            // empty if block
        }
        if (this.hasTool()) {
            builder.put((Object)CraftMetaItem.TOOL.BUKKIT, (Object)this.tool);
        }
        if (this.hasEquippable()) {
            builder.put((Object)CraftMetaItem.EQUIPPABLE.BUKKIT, (Object)this.equippable);
        }
        if (this.hasJukeboxPlayable()) {
            // empty if block
        }
        if (this.hasDamageValue()) {
            builder.put((Object)CraftMetaItem.DAMAGE.BUKKIT, (Object)this.damage);
        }
        if (this.hasMaxDamage()) {
            builder.put((Object)CraftMetaItem.MAX_DAMAGE.BUKKIT, (Object)this.maxDamage);
        }
        HashMap<String, class_2520> internalTags = new HashMap<String, class_2520>();
        this.serializeInternal(internalTags);
        if (!internalTags.isEmpty()) {
            class_2487 internal = new class_2487();
            for (Map.Entry e : internalTags.entrySet()) {
                internal.method_10566((String)e.getKey(), (class_2520)e.getValue());
            }
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                class_2507.method_10634((class_2487)internal, (OutputStream)buf);
                builder.put((Object)"internal", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!this.unhandledTags.method_57852().method_57848()) {
            class_6903 ops = ICommonMod.getIServer().getMinecraft().method_30611().method_57093((DynamicOps)class_2509.field_11560);
            class_2520 unhandled = (class_2520)class_9326.field_49589.encodeStart((DynamicOps)ops, (Object)this.unhandledTags.method_57852()).getOrThrow(IllegalStateException::new);
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                class_2507.method_10634((class_2487)((class_2487)unhandled), (OutputStream)buf);
                builder.put((Object)"unhandled", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (!this.persistentDataContainer.isEmpty()) {
            builder.put((Object)CraftMetaItem.BUKKIT_CUSTOM_TAG.BUKKIT, (Object)this.persistentDataContainer.serialize());
        }
        if (this.customTag != null && !this.customTag.method_33133()) {
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                class_2507.method_10634((class_2487)this.customTag, (OutputStream)buf);
                builder.put((Object)"custom", (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
            }
            catch (IOException ex) {
                java.util.logging.Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return builder;
    }

    void serializeInternal(Map<String, class_2520> unhandledTags) {
    }

    public Material updateMaterial(Material material) {
        return material;
    }

    public static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)enchant.getKey().getName(), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    public static void serializeModifiers(Multimap<Attribute, AttributeModifier> modifiers, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (modifiers == null || modifiers.isEmpty()) {
            return;
        }
        LinkedHashMap mods = new LinkedHashMap();
        for (Map.Entry entry : modifiers.entries()) {
            Collection modCollection;
            if (entry.getKey() == null || (modCollection = modifiers.get((Object)((Attribute)entry.getKey()))) == null || modCollection.isEmpty()) continue;
            mods.put(((Attribute)entry.getKey()).name(), new ArrayList(modCollection));
        }
        builder.put((Object)key.BUKKIT, mods);
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<class_2561> addTo, boolean possiblyJsonInput) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            class_2561 component;
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(String.valueOf(addFrom) + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add((class_2561)class_2561.method_43473());
                continue;
            }
            String entry = object.toString();
            class_2561 class_25612 = component = possiblyJsonInput ? CraftChatMessage.fromJSONOrString(entry) : CraftChatMessage.fromStringOrNull(entry);
            if (component != null) {
                addTo.add(component);
                continue;
            }
            addTo.add((class_2561)class_2561.method_43473());
        }
    }

    public static void safelyAdd(Iterable<?> addFrom, Collection<class_2561> addTo, int maxItemLength) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(String.valueOf(addFrom) + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add(class_2561.method_30163((String)""));
                continue;
            }
            String page = object.toString();
            if (page.length() > maxItemLength) {
                page = page.substring(0, maxItemLength);
            }
            addTo.add(CraftChatMessage.wrapOrEmpty(page));
        }
    }

    public static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        for (Enchantment enchant : enchantments.keySet()) {
            if (!enchant.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        return (String)SerializableMeta.classMap.get(this.getClass()) + "_META:" + String.valueOf(this.serialize());
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<class_9331> getHandledTags() {
        Set<class_9331> set = HANDLED_TAGS;
        synchronized (set) {
            if (HANDLED_TAGS.isEmpty()) {
                HANDLED_TAGS.addAll(Arrays.asList(CraftMetaItem.NAME.TYPE, CraftMetaItem.ITEM_NAME.TYPE, CraftMetaItem.LORE.TYPE, CraftMetaItem.CUSTOM_MODEL_DATA.TYPE, CraftMetaItem.BLOCK_DATA.TYPE, CraftMetaItem.REPAIR.TYPE, CraftMetaItem.ENCHANTMENTS.TYPE, CraftMetaItem.UNBREAKABLE.TYPE, CraftMetaItem.ENCHANTMENT_GLINT_OVERRIDE.TYPE, CraftMetaItem.MAX_STACK_SIZE.TYPE, CraftMetaItem.RARITY.TYPE, CraftMetaItem.FOOD.TYPE, CraftMetaItem.DAMAGE.TYPE, CraftMetaItem.MAX_DAMAGE.TYPE, CraftMetaItem.CUSTOM_DATA.TYPE, CraftMetaItem.ATTRIBUTES.TYPE, CraftMetaArmorStand.ENTITY_TAG.TYPE, CraftMetaBanner.PATTERNS.TYPE, CraftMetaEntityTag.ENTITY_TAG.TYPE, CraftMetaLeatherArmor.COLOR.TYPE, CraftMetaMap.MAP_POST_PROCESSING.TYPE, CraftMetaMap.MAP_COLOR.TYPE, CraftMetaMap.MAP_ID.TYPE, CraftMetaPotion.POTION_CONTENTS.TYPE, CraftMetaSkull.SKULL_PROFILE.TYPE, CraftMetaSpawnEgg.ENTITY_TAG.TYPE, CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, CraftMetaBook.BOOK_CONTENT.TYPE, CraftMetaBookSigned.BOOK_CONTENT.TYPE, CraftMetaFirework.FIREWORKS.TYPE, CraftMetaEnchantedBook.STORED_ENCHANTMENTS.TYPE, CraftMetaCharge.EXPLOSION.TYPE, CraftMetaBlockState.BLOCK_ENTITY_TAG.TYPE, CraftMetaKnowledgeBook.BOOK_RECIPES.TYPE, CraftMetaCrossbow.CHARGED_PROJECTILES.TYPE, CraftMetaSuspiciousStew.EFFECTS.TYPE));
            }
            return HANDLED_TAGS;
        }
    }

    @Deprecated(forRemoval=true)
    public Set<Material> getCanDestroy() {
        return Collections.emptySet();
    }

    @Deprecated(forRemoval=true)
    public Set<Material> getCanPlaceOn() {
        return null;
    }

    public BaseComponent[] getDisplayNameComponent() {
        return null;
    }

    public List<BaseComponent[]> getLoreComponents() {
        return null;
    }

    @Deprecated(forRemoval=true)
    public boolean hasDestroyableKeys() {
        return false;
    }

    @Deprecated(forRemoval=true)
    public boolean hasPlaceableKeys() {
        return false;
    }

    @Deprecated(forRemoval=true)
    public void setCanDestroy(Set<Material> arg0) {
    }

    @Deprecated(forRemoval=true)
    public void setCanPlaceOn(Set<Material> arg0) {
    }

    public void setDisplayNameComponent(BaseComponent[] arg0) {
    }

    public void setLoreComponents(List<BaseComponent[]> arg0) {
    }

    @Nullable
    public Component displayName() {
        return null;
    }

    public void displayName(@Nullable Component arg0) {
    }

    @Nullable
    public List<Component> lore() {
        return null;
    }

    public void lore(@Nullable List<? extends Component> arg0) {
    }

    public String getAsString() {
        Applicator tag = new Applicator();
        this.applyToItem(tag);
        class_9326 patch = tag.build();
        class_6903 reg = ICommonMod.getIServer().getMinecraft().method_30611().method_57093((DynamicOps)class_2509.field_11560);
        class_2520 nbt = (class_2520)class_9326.field_49589.encodeStart((DynamicOps)reg, (Object)patch).getOrThrow();
        return nbt.toString();
    }

    public void removeEnchantments() {
        if (this.hasEnchants()) {
            this.enchantments.clear();
        }
    }

    @NotNull
    public Component itemName() {
        return CardboardAdventure.asAdventure(this.itemName);
    }

    public void itemName(Component name) {
        this.itemName = CardboardAdventure.asVanilla(name);
    }

    @NotNull
    public String getItemName() {
        return CraftChatMessage.fromComponent(this.itemName);
    }

    public void setItemName(@Nullable String name) {
        this.itemName = CraftChatMessage.fromStringOrNull(name);
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    @NotNull
    public FoodComponent getFood() {
        return null;
    }

    public void setFood(@Nullable FoodComponent food) {
    }

    public boolean hasTool() {
        return this.tool != null;
    }

    @NotNull
    public ToolComponent getTool() {
        return null;
    }

    public void setTool(@Nullable ToolComponent tool) {
    }

    public String getAsComponentString() {
        Applicator tag = new Applicator(this){};
        this.applyToItem(tag);
        class_9326 patch = tag.build();
        class_5455 registryAccess = CraftRegistry.getMinecraftRegistry();
        class_6903 ops = registryAccess.method_57093((DynamicOps)class_2509.field_11560);
        class_2378 componentTypeRegistry = registryAccess.method_30530(class_7924.field_49659);
        StringJoiner componentString = new StringJoiner(",", "[", "]");
        for (Map.Entry entry : patch.method_57846()) {
            class_9331 componentType = (class_9331)entry.getKey();
            Optional componentValue = (Optional)entry.getValue();
            String componentKey = ((class_5321)componentTypeRegistry.method_29113((Object)componentType).orElseThrow()).method_29177().toString();
            if (componentValue.isPresent()) continue;
        }
        return componentString.toString();
    }

    public boolean hasDamageValue() {
        return this.damage != null;
    }

    public void resetDamage() {
        this.damage = null;
    }

    public boolean hasJukeboxPlayable() {
        return false;
    }

    @NotNull
    public JukeboxPlayableComponent getJukeboxPlayable() {
        return null;
    }

    public void setJukeboxPlayable(@Nullable JukeboxPlayableComponent jukeboxPlayable) {
    }

    private static Set<Namespaced> convertToLegacyNamespaced(Collection<class_4550> predicates) {
        HashSet namespaceds = Sets.newHashSet();
        for (class_4550 predicate : predicates) {
            if (predicate.comp_1732().isEmpty()) continue;
            class_6885 holders = (class_6885)predicate.comp_1732().get();
            if (holders instanceof class_6885.class_6888) {
                class_6885.class_6888 named = (class_6885.class_6888)holders;
                namespaceds.add(new NamespacedTag(named.method_40251().comp_327().method_12836(), named.method_40251().comp_327().method_12832()));
                continue;
            }
            holders.forEach(h2 -> h2.method_40230().ifPresent(key -> namespaceds.add(new NamespacedKey(key.method_29177().method_12836(), key.method_29177().method_12832()))));
        }
        return namespaceds;
    }

    @NotNull
    public Set<Namespaced> getDestroyableKeys() {
        return !this.hasDestroyableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyNamespaced(this.canBreakPredicates);
    }

    private static List<class_4550> convertFromLegacyNamespaced(Collection<Namespaced> namespaceds) {
        ArrayList<class_4550> predicates = new ArrayList<class_4550>();
        class_2378 blockRegistry = CraftServer.server.method_30611().method_30530(class_7924.field_41254);
        for (Namespaced namespaced : namespaceds) {
            if (namespaced instanceof NamespacedKey) {
                NamespacedKey key = (NamespacedKey)namespaced;
                predicates.add(class_4550.class_4710.method_23880().method_27962((class_7871)blockRegistry, new class_2248[]{CraftBlockType.bukkitToMinecraft(Objects.requireNonNull((Material)Registry.MATERIAL.get(key)))}).method_23882());
                continue;
            }
            if (!(namespaced instanceof NamespacedTag)) continue;
            NamespacedTag tag = (NamespacedTag)namespaced;
            predicates.add(class_4550.class_4710.method_23880().method_29233((class_7871)blockRegistry, class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)tag.getNamespace(), (String)tag.getKey()))).method_23882());
        }
        return predicates;
    }

    public void setDestroyableKeys(@NotNull Collection<Namespaced> canDestroy) {
        this.canBreakPredicates = CraftMetaItem.convertFromLegacyNamespaced(canDestroy);
    }

    @NotNull
    public Set<Namespaced> getPlaceableKeys() {
        return !this.hasPlaceableKeys() ? Collections.emptySet() : CraftMetaItem.convertToLegacyNamespaced(this.canPlaceOnPredicates);
    }

    public void setPlaceableKeys(@NotNull Collection<Namespaced> canPlaceOn) {
        this.canPlaceOnPredicates = CraftMetaItem.convertFromLegacyNamespaced(canPlaceOn);
    }

    public boolean hasCustomName() {
        return this.displayName != null;
    }

    @Nullable
    public Component customName() {
        return this.displayName == null ? null : CardboardAdventure.asAdventure(this.displayName);
    }

    public void customName(@Nullable Component customName) {
        this.displayName = customName == null ? null : CardboardAdventure.asVanilla(customName);
    }

    public @NotNull CustomModelDataComponent getCustomModelDataComponent() {
        return this.hasCustomModelData() ? new CraftCustomModelDataComponent(this.customModelData) : new CraftCustomModelDataComponent(new class_9280(List.of(), List.of(), List.of(), List.of()));
    }

    public void setCustomModelDataComponent(@Nullable CustomModelDataComponent customModelData) {
        this.customModelData = customModelData == null ? null : new CraftCustomModelDataComponent((CraftCustomModelDataComponent)customModelData);
    }

    public boolean hasEnchantable() {
        return this.enchantableValue != null;
    }

    public int getEnchantable() {
        return this.enchantableValue;
    }

    public void setEnchantable(@Nullable Integer data) {
        Preconditions.checkArgument((data == null || data > 0 ? 1 : 0) != 0, (Object)"Enchantability must be positive");
        this.enchantableValue = data;
    }

    public boolean hasTooltipStyle() {
        return this.tooltipStyle != null;
    }

    @Nullable
    public NamespacedKey getTooltipStyle() {
        return this.tooltipStyle;
    }

    public void setTooltipStyle(NamespacedKey tooltipStyle) {
        this.tooltipStyle = tooltipStyle;
    }

    public boolean hasItemModel() {
        return this.itemModel != null;
    }

    @Nullable
    public NamespacedKey getItemModel() {
        return this.itemModel;
    }

    public void setItemModel(@Nullable NamespacedKey itemModel) {
        this.itemModel = itemModel;
    }

    public boolean isGlider() {
        return this.glider;
    }

    public void setGlider(boolean glider) {
        this.glider = glider;
    }

    public boolean hasDamageResistant() {
        return this.damageResistant != null;
    }

    @Nullable
    public Tag<DamageType> getDamageResistant() {
        return this.hasDamageResistant() ? Bukkit.getTag((String)"damage_types", (NamespacedKey)CraftNamespacedKey.fromMinecraft(this.damageResistant.comp_327()), DamageType.class) : null;
    }

    public void setDamageResistant(@Nullable Tag<DamageType> tag) {
        this.setDamageResistant((Tag<DamageType>)DamageTypeTags.IS_FIRE);
    }

    public boolean hasUseRemainder() {
        return this.useRemainder != null;
    }

    @Nullable
    public ItemStack getUseRemainder() {
        return this.useRemainder;
    }

    public void setUseRemainder(@Nullable ItemStack remainder) {
        Preconditions.checkArgument((this.useRemainder == null || !this.useRemainder.isEmpty() ? 1 : 0) != 0, (Object)"Item cannot be empty");
        this.useRemainder = this.useRemainder;
    }

    public boolean hasUseCooldown() {
        return this.useCooldown != null;
    }

    public UseCooldownComponent getUseCooldown() {
        return this.hasUseCooldown() ? new CraftUseCooldownComponent(this.useCooldown) : new CraftUseCooldownComponent(new class_10130(1.0f));
    }

    public void setUseCooldown(UseCooldownComponent cooldown) {
        this.useCooldown = cooldown == null ? null : new CraftUseCooldownComponent((CraftUseCooldownComponent)cooldown);
    }

    public boolean hasEquippable() {
        return this.equippable != null;
    }

    public EquippableComponent getEquippable() {
        return this.hasEquippable() ? new CraftEquippableComponent(this.equippable) : new CraftEquippableComponent(class_10192.method_64202((class_1304)class_1304.field_6169).method_64203());
    }

    public void setEquippable(EquippableComponent equippable) {
        this.equippable = equippable == null ? null : new CraftEquippableComponent((CraftEquippableComponent)equippable);
    }

    public boolean hasCustomModelDataComponent() {
        return this.customModelData != null;
    }

    static final class ItemMetaKeyType<T>
    extends ItemMetaKey {
        final class_9331<T> TYPE;

        ItemMetaKeyType(class_9331<T> type) {
            this(type, null, null);
        }

        ItemMetaKeyType(class_9331<T> type, String both) {
            this(type, both, both);
        }

        ItemMetaKeyType(class_9331<T> type, String nbt, String bukkit) {
            super(nbt, bukkit);
            this.TYPE = type;
        }
    }

    static class ItemMetaKey {
        final String BUKKIT;
        final String NBT;

        ItemMetaKey(String both) {
            this(both, both);
        }

        ItemMetaKey(String nbt, String bukkit) {
            this.NBT = nbt;
            this.BUKKIT = bukkit;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.FIELD})
        static @interface Specific {
            public To value();

            public static enum To {
                BUKKIT,
                NBT;

            }
        }
    }

    @SerializableAs(value="ItemMeta")
    public static final class SerializableMeta
    implements ConfigurationSerializable {
        static final String TYPE_FIELD = "meta-type";
        static final ImmutableMap<Class<? extends CraftMetaItem>, String> classMap = ImmutableMap.builder().put(CraftMetaArmorStand.class, (Object)"ARMOR_STAND").put(CraftMetaBanner.class, (Object)"BANNER").put(CraftMetaBlockState.class, (Object)"TILE_ENTITY").put(CraftMetaBook.class, (Object)"BOOK").put(CraftMetaBookSigned.class, (Object)"BOOK_SIGNED").put(CraftMetaSkull.class, (Object)"SKULL").put(CraftMetaLeatherArmor.class, (Object)"LEATHER_ARMOR").put(CraftMetaMap.class, (Object)"MAP").put(CraftMetaPotion.class, (Object)"POTION").put(CraftMetaSpawnEgg.class, (Object)"SPAWN_EGG").put(CraftMetaEnchantedBook.class, (Object)"ENCHANTED").put(CraftMetaFirework.class, (Object)"FIREWORK").put(CraftMetaCharge.class, (Object)"FIREWORK_EFFECT").put(CraftMetaKnowledgeBook.class, (Object)"KNOWLEDGE_BOOK").put(CraftMetaCrossbow.class, (Object)"CROSSBOW").put(CraftMetaSuspiciousStew.class, (Object)"SUSPICIOUS_STEW").put(CraftMetaItem.class, (Object)"UNSPECIFIC").build();
        static final ImmutableMap<String, Constructor<? extends CraftMetaItem>> constructorMap;

        private SerializableMeta() {
        }

        public static ItemMeta deserialize(Map<String, Object> map) throws Throwable {
            Validate.notNull(map, "Cannot deserialize null map");
            String type = SerializableMeta.getString(map, TYPE_FIELD, false);
            Constructor constructor = (Constructor)constructorMap.get((Object)type);
            if (constructor == null) {
                throw new IllegalArgumentException(type + " is not a valid meta-type");
            }
            try {
                return (ItemMeta)constructor.newInstance(map);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        public Map<String, Object> serialize() {
            throw new AssertionError();
        }

        static String getString(Map<?, ?> map, Object field, boolean nullable) {
            return SerializableMeta.getObject(String.class, map, field, nullable);
        }

        static boolean getBoolean(Map<?, ?> map, Object field) {
            Boolean value = SerializableMeta.getObject(Boolean.class, map, field, true);
            return value != null && value != false;
        }

        static <T> T getObject(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
            Object object = map.get(field);
            if (clazz.isInstance(object)) {
                return clazz.cast(object);
            }
            if (object == null) {
                if (!nullable) {
                    throw new NoSuchElementException(String.valueOf(map) + " does not contain " + String.valueOf(field));
                }
                return null;
            }
            throw new IllegalArgumentException(String.valueOf(field) + "(" + String.valueOf(object) + ") is not a valid " + String.valueOf(clazz));
        }

        public static <T> Optional<T> getObjectOptionally(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
            Object object = map.get(field);
            if (clazz.isInstance(object)) {
                return Optional.of(clazz.cast(object));
            }
            if (object == null) {
                if (!nullable) {
                    throw new NoSuchElementException(String.valueOf(map) + " does not contain " + String.valueOf(field));
                }
                return Optional.empty();
            }
            throw new IllegalArgumentException(String.valueOf(field) + "(" + String.valueOf(object) + ") is not a valid " + String.valueOf(clazz));
        }

        static {
            ImmutableMap.Builder classConstructorBuilder = ImmutableMap.builder();
            for (Map.Entry mapping : classMap.entrySet()) {
                try {
                    classConstructorBuilder.put((Object)((String)mapping.getValue()), ((Class)mapping.getKey()).getDeclaredConstructor(Map.class));
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
            constructorMap = classConstructorBuilder.build();
        }
    }

    static class Applicator {
        final class_9326.class_9327 builder = class_9326.method_57841();

        Applicator() {
        }

        void skullCallback(class_9296 gameProfile) {
        }

        <T> Applicator put(ItemMetaKeyType<T> key, T value) {
            this.builder.method_57854(key.TYPE, value);
            return this;
        }

        <T> Applicator remove(class_9331<T> type) {
            this.builder.method_57853(type);
            return this;
        }

        class_9326 build() {
            return this.builder.method_57852();
        }
    }
}

