/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_9280;
import org.bukkit.Color;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

@SerializableAs(value="CustomModelData")
public final class CraftCustomModelDataComponent
implements CustomModelDataComponent {
    private class_9280 handle;

    public CraftCustomModelDataComponent(class_9280 handle) {
        this.handle = handle;
    }

    public CraftCustomModelDataComponent(CraftCustomModelDataComponent craft) {
        this.handle = craft.handle;
    }

    public CraftCustomModelDataComponent(Map<String, Object> map) {
        this.handle = new class_9280(SerializableMeta.getList(Float.class, map, "floats"), SerializableMeta.getList(Boolean.class, map, "flags"), SerializableMeta.getList(String.class, map, "strings"), SerializableMeta.getList(Color.class, map, "colors").stream().map(Color::asRGB).toList());
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("floats", this.getFloats());
        result.put("flags", this.getFlags());
        result.put("strings", this.getStrings());
        result.put("colors", this.getColors());
        return result;
    }

    public class_9280 getHandle() {
        return this.handle;
    }

    public List<Float> getFloats() {
        return Collections.unmodifiableList(this.handle.comp_3354());
    }

    public void setFloats(List<Float> floats) {
        this.handle = new class_9280(new ArrayList<Float>(floats), this.handle.comp_3355(), this.handle.comp_3356(), this.handle.comp_3357());
    }

    public List<Boolean> getFlags() {
        return Collections.unmodifiableList(this.handle.comp_3355());
    }

    public void setFlags(List<Boolean> flags) {
        this.handle = new class_9280(this.handle.comp_3354(), List.copyOf(flags), this.handle.comp_3356(), this.handle.comp_3357());
    }

    public List<String> getStrings() {
        return Collections.unmodifiableList(this.handle.comp_3356());
    }

    public void setStrings(List<String> strings) {
        this.handle = new class_9280(this.handle.comp_3354(), this.handle.comp_3355(), List.copyOf(strings), this.handle.comp_3357());
    }

    public List<Color> getColors() {
        return this.getHandle().comp_3357().stream().map(Color::fromRGB).toList();
    }

    public void setColors(List<Color> colors) {
        this.handle = new class_9280(this.handle.comp_3354(), this.handle.comp_3355(), this.handle.comp_3356(), colors.stream().map(Color::asRGB).toList());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftCustomModelDataComponent other = (CraftCustomModelDataComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public String toString() {
        return "CraftCustomModelDataComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

