/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.view.builder;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1703;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;
import org.cardboardpowered.interfaces.IMixinScreenHandler;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public abstract class CraftAbstractInventoryViewBuilder<V extends InventoryView>
implements InventoryViewBuilder<V> {
    protected final class_3917<?> handle;
    protected boolean checkReachable = false;
    protected @MonotonicNonNull Component title = null;

    public CraftAbstractInventoryViewBuilder(class_3917<?> handle) {
        this.handle = handle;
    }

    public InventoryViewBuilder<V> title(Component title) {
        this.title = title;
        return this;
    }

    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((this.title != null ? 1 : 0) != 0, (Object)"The given title must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof class_3222), (Object)"The given player must be an EntityPlayer");
        class_3222 serverPlayer = (class_3222)craftHuman.getHandle();
        class_1703 container = this.buildContainer(serverPlayer);
        IMixinScreenHandler sh = (IMixinScreenHandler)container;
        sh.setCheckReachable(this.checkReachable);
        sh.setTitle(PaperAdventure.asVanilla(this.title));
        return (V)((IMixinScreenHandler)container).getBukkitView();
    }

    protected abstract class_1703 buildContainer(class_3222 var1);
}

