/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.bukkit.craftbukkit.persistence.CraftPersistentDataContainer;
import org.bukkit.persistence.ListPersistentDataType;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class CraftPersistentDataTypeRegistry {
    private final Function<Class, TagAdapter> CREATE_ADAPTER = this::createAdapter;
    private final Map<Class, TagAdapter> adapters = new ConcurrentHashMap<Class, TagAdapter>();

    private <T> TagAdapter createAdapter(Class<T> type) {
        if (!Primitives.isWrapperType(type)) {
            type = Primitives.wrap(type);
        }
        if (Objects.equals(Byte.class, type)) {
            return this.createAdapter(Byte.class, class_2481.class, (byte)1, class_2481::method_23233, class_2481::comp_3817);
        }
        if (Objects.equals(Short.class, type)) {
            return this.createAdapter(Short.class, class_2516.class, (byte)2, class_2516::method_23254, class_2516::comp_3822);
        }
        if (Objects.equals(Integer.class, type)) {
            return this.createAdapter(Integer.class, class_2497.class, (byte)3, class_2497::method_23247, class_2497::comp_3820);
        }
        if (Objects.equals(Long.class, type)) {
            return this.createAdapter(Long.class, class_2503.class, (byte)4, class_2503::method_23251, class_2503::comp_3821);
        }
        if (Objects.equals(Float.class, type)) {
            return this.createAdapter(Float.class, class_2494.class, (byte)5, class_2494::method_23244, class_2494::comp_3819);
        }
        if (Objects.equals(Double.class, type)) {
            return this.createAdapter(Double.class, class_2489.class, (byte)6, class_2489::method_23241, class_2489::comp_3818);
        }
        if (Objects.equals(String.class, type)) {
            return this.createAdapter(String.class, class_2519.class, (byte)8, class_2519::method_23256, class_2519::comp_3831);
        }
        if (Objects.equals(byte[].class, type)) {
            return this.createAdapter(byte[].class, class_2479.class, (byte)7, array -> new class_2479(Arrays.copyOf(array, ((byte[])array).length)), n -> Arrays.copyOf(n.method_10521(), n.size()));
        }
        if (Objects.equals(int[].class, type)) {
            return this.createAdapter(int[].class, class_2495.class, (byte)11, array -> new class_2495(Arrays.copyOf(array, ((int[])array).length)), n -> Arrays.copyOf(n.method_10588(), n.size()));
        }
        if (Objects.equals(long[].class, type)) {
            return this.createAdapter(long[].class, class_2501.class, (byte)12, array -> new class_2501(Arrays.copyOf(array, ((long[])array).length)), n -> Arrays.copyOf(n.method_10615(), n.size()));
        }
        if (Objects.equals(PersistentDataContainer[].class, type)) {
            return this.createAdapter(PersistentDataContainer[].class, class_2499.class, (byte)9, containerArray -> {
                class_2499 list = new class_2499();
                for (PersistentDataContainer persistentDataContainer : containerArray) {
                    list.add((Object)((CraftPersistentDataContainer)persistentDataContainer).toTagCompound());
                }
                return list;
            }, tag -> {
                PersistentDataContainer[] containerArray = new CraftPersistentDataContainer[tag.size()];
                for (int i2 = 0; i2 < tag.size(); ++i2) {
                    CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                    class_2487 compound = tag.method_68582(i2);
                    for (String key : compound.method_10541()) {
                        container.put(key, compound.method_10580(key));
                    }
                    containerArray[i2] = container;
                }
                return containerArray;
            });
        }
        if (Objects.equals(PersistentDataContainer.class, type)) {
            return this.createAdapter(CraftPersistentDataContainer.class, class_2487.class, (byte)10, CraftPersistentDataContainer::toTagCompound, tag -> {
                CraftPersistentDataContainer container = new CraftPersistentDataContainer(this);
                for (String key : tag.method_10541()) {
                    container.put(key, tag.method_10580(key));
                }
                return container;
            });
        }
        if (Objects.equals(List.class, type)) {
            return this.createAdapter(List.class, class_2499.class, (byte)9, this::constructList, this::extractList, this::matchesListTag);
        }
        throw new IllegalArgumentException("Could not find a valid TagAdapter implementation for the requested type " + type.getSimpleName());
    }

    private <T, Z extends class_2520> TagAdapter<T, Z> createAdapter(Class<T> primitiveType, Class<Z> tagType, byte nmsTypeByte, Function<T, Z> builder, Function<Z, T> extractor) {
        return this.createAdapter(primitiveType, tagType, nmsTypeByte, (type, t) -> (class_2520)builder.apply(t), (type, z) -> extractor.apply(z), (type, t) -> tagType.isInstance(t));
    }

    private <T, Z extends class_2520> TagAdapter<T, Z> createAdapter(Class<T> primitiveType, Class<Z> tagType, byte nmsTypeByte, BiFunction<PersistentDataType<T, ?>, T, Z> builder, BiFunction<PersistentDataType<T, ?>, Z, T> extractor, BiPredicate<PersistentDataType<T, ?>, class_2520> matcher) {
        return new TagAdapter<T, Z>(primitiveType, tagType, nmsTypeByte, builder, extractor, matcher);
    }

    public <T> class_2520 wrap(PersistentDataType<T, ?> type, T value) {
        return this.getOrCreateAdapter(type).build(type, value);
    }

    public <T> boolean isInstanceOf(PersistentDataType<T, ?> type, class_2520 base) {
        return this.getOrCreateAdapter(type).isInstance(type, base);
    }

    @NotNull
    private <T, Z extends class_2520> TagAdapter<T, Z> getOrCreateAdapter(@NotNull PersistentDataType<T, ?> type) {
        return this.adapters.computeIfAbsent(type.getPrimitiveType(), this.CREATE_ADAPTER);
    }

    public <T, Z extends class_2520> T extract(PersistentDataType<T, ?> type, class_2520 tag) throws ClassCastException, IllegalArgumentException {
        Class primitiveType = type.getPrimitiveType();
        TagAdapter<T, Z> adapter = this.getOrCreateAdapter(type);
        Preconditions.checkArgument((boolean)adapter.isInstance(type, tag), (String)"The found tag instance (%s) cannot store %s", (Object)tag.getClass().getSimpleName(), (Object)primitiveType.getSimpleName());
        T foundValue = adapter.extract(type, tag);
        Preconditions.checkArgument((boolean)primitiveType.isInstance(foundValue), (String)"The found object is of the type %s. Expected type %s", (Object)foundValue.getClass().getSimpleName(), (Object)primitiveType.getSimpleName());
        return primitiveType.cast(foundValue);
    }

    private <P, T extends List<P>> class_2499 constructList(@NotNull PersistentDataType<T, ?> type, @NotNull List<P> list) {
        Preconditions.checkArgument((boolean)(type instanceof ListPersistentDataType), (String)"The passed list cannot be written to the PDC with a %s (expected a list data type)", (Object)type.getClass().getSimpleName());
        ListPersistentDataType listPersistentDataType = (ListPersistentDataType)type;
        ArrayList values = Lists.newArrayListWithCapacity((int)list.size());
        for (P primitiveValue : list) {
            values.add(this.wrap(listPersistentDataType.elementType(), primitiveValue));
        }
        return new class_2499((List)values);
    }

    private <P> List<P> extractList(@NotNull PersistentDataType<P, ?> type, @NotNull class_2499 listTag) {
        Preconditions.checkArgument((boolean)(type instanceof ListPersistentDataType), (String)"The found list tag cannot be read with a %s (expected a list data type)", (Object)type.getClass().getSimpleName());
        ListPersistentDataType listPersistentDataType = (ListPersistentDataType)type;
        ObjectArrayList output = new ObjectArrayList(listTag.size());
        for (class_2520 tag : listTag) {
            output.add(this.extract(listPersistentDataType.elementType(), tag));
        }
        return output;
    }

    private boolean matchesListTag(PersistentDataType<List, ?> type, class_2520 tag) {
        if (!(type instanceof ListPersistentDataType)) {
            return false;
        }
        ListPersistentDataType listPersistentDataType = (ListPersistentDataType)type;
        if (!(tag instanceof class_2499)) {
            return false;
        }
        class_2499 listTag = (class_2499)tag;
        byte elementType = listTag.method_68587();
        TagAdapter elementAdapter = this.getOrCreateAdapter(listPersistentDataType.elementType());
        return elementAdapter.nmsTypeByte() == elementType || elementType == 0;
    }

    private record TagAdapter<P, T extends class_2520>(Class<P> primitiveType, Class<T> tagType, byte nmsTypeByte, BiFunction<PersistentDataType<P, ?>, P, T> builder, BiFunction<PersistentDataType<P, ?>, T, P> extractor, BiPredicate<PersistentDataType<P, ?>, class_2520> matcher) {
        private P extract(PersistentDataType<P, ?> dataType, class_2520 base) {
            Preconditions.checkArgument((boolean)this.tagType.isInstance(base), (String)"The provided Tag was of the type %s. Expected type %s", (Object)base.getClass().getSimpleName(), (Object)this.tagType.getSimpleName());
            return this.extractor.apply(dataType, (PersistentDataType<P, ?>)((class_2520)this.tagType.cast(base)));
        }

        private T build(PersistentDataType<P, ?> dataType, Object value) {
            Preconditions.checkArgument((boolean)this.primitiveType.isInstance(value), (String)"The provided value was of the type %s. Expected type %s", (Object)value.getClass().getSimpleName(), (Object)this.primitiveType.getSimpleName());
            return (T)((class_2520)this.builder.apply(dataType, this.primitiveType.cast(value)));
        }

        private boolean isInstance(PersistentDataType<P, ?> persistentDataType, class_2520 base) {
            return this.matcher.test(persistentDataType, base);
        }
    }
}

