/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.api.event;

import com.google.common.base.Preconditions;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.cardboardpowered.api.event.CardboardEntityMountEvent;
import org.cardboardpowered.api.event.CardboardFireworkExplodeEvent;

public class CardboardEventManager {
    public static CardboardEventManager INSTANCE = new CardboardEventManager();

    public void callCardboardEvents() {
        this.callCardboardFireworkExplodeEvent();
        this.callCardboardEntityMountEvent();
    }

    private void callCardboardFireworkExplodeEvent() {
        CardboardFireworkExplodeEvent.EVENT.register(firework -> {
            if (CraftEventFactory.callFireworkExplodeEvent(firework).isCancelled()) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    private void callCardboardEntityMountEvent() {
        CardboardEntityMountEvent.EVENT.register((vehicle, entity) -> {
            EntityDismountEvent SPevent;
            CraftEntity craftn;
            class_1297 n;
            VehicleExitEvent CBevent;
            class_1297 orig;
            CraftEntity craft;
            if (vehicle.method_5685().isEmpty()) {
                craft = (CraftEntity)vehicle.getBukkitEntity().getVehicle();
                class_1297 class_12972 = orig = craft == null ? null : craft.getHandle();
                if (vehicle.getBukkitEntity() instanceof Vehicle && vehicle.getBukkitEntity() instanceof LivingEntity) {
                    CBevent = new VehicleExitEvent((Vehicle)vehicle.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity());
                    if (entity.isValidBF()) {
                        Bukkit.getPluginManager().callEvent((Event)CBevent);
                    }
                    class_1297 class_12973 = n = (craftn = (CraftEntity)vehicle.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
                    if (CBevent.isCancelled() || n != orig) {
                        return class_1269.field_5814;
                    }
                }
                SPevent = new EntityDismountEvent((Entity)vehicle.getBukkitEntity(), (Entity)entity.getBukkitEntity());
                if (vehicle.isValidBF()) {
                    Bukkit.getPluginManager().callEvent((Event)SPevent);
                }
                if (SPevent.isCancelled()) {
                    return class_1269.field_5814;
                }
            }
            if (!vehicle.method_5685().isEmpty()) {
                Preconditions.checkState((!vehicle.method_5685().contains(vehicle) ? 1 : 0) != 0, (String)"Circular entity riding! %s %s", (Object)this, (Object)entity);
                craft = (CraftEntity)vehicle.getBukkitEntity().getVehicle();
                class_1297 class_12974 = orig = craft == null ? null : craft.getHandle();
                if (entity.getBukkitEntity() instanceof Vehicle && vehicle.getBukkitEntity() instanceof LivingEntity) {
                    CBevent = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (Entity)vehicle.getBukkitEntity());
                    if (entity.isValidBF()) {
                        Bukkit.getPluginManager().callEvent((Event)CBevent);
                    }
                    class_1297 class_12975 = n = (craftn = (CraftEntity)vehicle.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
                    if (CBevent.isCancelled() || n != orig) {
                        return class_1269.field_5814;
                    }
                }
                SPevent = new EntityMountEvent((Entity)vehicle.getBukkitEntity(), (Entity)entity.getBukkitEntity());
                if (entity.isValidBF()) {
                    Bukkit.getPluginManager().callEvent((Event)SPevent);
                    if (SPevent.isCancelled()) {
                        return class_1269.field_5814;
                    }
                }
            }
            return class_1269.field_5811;
        });
    }
}

