/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.block;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.datacomponent.item.PaperResolvableProfile;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.class_11560;
import net.minecraft.class_156;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.cardboardpowered.impl.block.CardboardBlockEntityState;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.jetbrains.annotations.Nullable;

public class CardboardSkull
extends CardboardBlockEntityState<class_2631>
implements Skull {
    private static final int MAX_OWNER_LENGTH = 16;
    private class_9296 profile;

    public CardboardSkull(World world, class_2631 tileEntity) {
        super(world, tileEntity);
    }

    protected CardboardSkull(CardboardSkull state, Location location) {
        super(state, location);
    }

    @Override
    public CardboardSkull copy() {
        return new CardboardSkull(this, null);
    }

    @Override
    public CardboardSkull copy(Location location) {
        return new CardboardSkull(this, location);
    }

    @Override
    public void load(class_2631 skull) {
        super.load(skull);
        class_9296 owner = skull.method_11334();
        if (null != owner) {
            this.profile = owner;
        }
    }

    static int getSkullType(SkullType type) {
        switch (type) {
            default: {
                return 0;
            }
            case WITHER: {
                return 1;
            }
            case ZOMBIE: {
                return 2;
            }
            case PLAYER: {
                return 3;
            }
            case CREEPER: {
                return 4;
            }
            case DRAGON: 
        }
        return 5;
    }

    public boolean hasOwner() {
        return this.profile != null;
    }

    public String getOwner() {
        return this.hasOwner() ? (String)this.profile.method_73317().orElse(null) : null;
    }

    public static GameProfile PlayerConfigEntry_toUncompletedGameProfile(class_11560 thiz) {
        return new GameProfile(thiz.comp_4422(), thiz.comp_4423());
    }

    public boolean setOwner(String name) {
        if (name != null && name.length() <= 16) {
            GameProfile profile = CraftServer.INSTANCE.getPaperFilledProfileCache().getIfCached(name);
            if (profile == null) {
                profile = CraftServer.server.method_73550().comp_4407().method_14515(name).map(CardboardSkull::PlayerConfigEntry_toUncompletedGameProfile).orElse(null);
            }
            if (profile == null) {
                return false;
            }
            this.profile = class_9296.method_73307((GameProfile)profile);
            return true;
        }
        return false;
    }

    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            GameProfile gameProfile = this.profile.method_73313();
            if (Objects.equals(gameProfile.id(), class_156.field_25140)) {
                return Bukkit.getOfflinePlayer((UUID)gameProfile.id());
            }
            if (!gameProfile.name().isEmpty()) {
                return Bukkit.getOfflinePlayer((String)gameProfile.name());
            }
        }
        return null;
    }

    public void setOwningPlayer(OfflinePlayer player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (player instanceof CraftPlayer) {
            CraftPlayer craftPlayer = (CraftPlayer)player;
            this.profile = class_9296.method_73307((GameProfile)craftPlayer.getProfile());
        } else {
            this.profile = new class_9296.class_11756(Either.right((Object)player.getUniqueId()), class_8685.class_11892.field_63029);
        }
    }

    public BlockFace getRotation() {
        BlockData blockData = this.getBlockData();
        return blockData instanceof Rotatable ? ((Rotatable)blockData).getRotation() : ((Directional)blockData).getFacing();
    }

    public void setRotation(BlockFace rotation) {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Rotatable) {
            ((Rotatable)blockData).setRotation(rotation);
        } else {
            ((Directional)blockData).setFacing(rotation);
        }
        this.setBlockData(blockData);
    }

    public SkullType getSkullType() {
        switch (this.getType()) {
            case SKELETON_SKULL: 
            case SKELETON_WALL_SKULL: {
                return SkullType.SKELETON;
            }
            case WITHER_SKELETON_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: {
                return SkullType.WITHER;
            }
            case ZOMBIE_HEAD: 
            case ZOMBIE_WALL_HEAD: {
                return SkullType.ZOMBIE;
            }
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: {
                return SkullType.PLAYER;
            }
            case CREEPER_HEAD: 
            case CREEPER_WALL_HEAD: {
                return SkullType.CREEPER;
            }
            case DRAGON_HEAD: 
            case DRAGON_WALL_HEAD: {
                return SkullType.DRAGON;
            }
        }
        throw new IllegalArgumentException("Unknown SkullType for " + String.valueOf(this.getType()));
    }

    public void setSkullType(SkullType skullType) {
        throw new UnsupportedOperationException("Must change block type");
    }

    @Override
    public void applyTo(class_2631 skull) {
        super.applyTo(skull);
        if (this.getSkullType() == SkullType.PLAYER) {
            skull.field_12087 = this.hasOwner() ? this.profile : null;
        }
    }

    public PlayerProfile getPlayerProfile() {
        return null;
    }

    public void setPlayerProfile(PlayerProfile arg0) {
        this.profile = CraftPlayerProfile.asResolvableProfileCopy(arg0);
    }

    public PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new CraftPlayerProfile(this.profile);
    }

    public void setOwnerProfile(@Nullable org.bukkit.profile.PlayerProfile profile) {
        if (profile == null) {
            this.profile = null;
        }
    }

    public NamespacedKey getNoteBlockSound() {
        class_2960 key = ((class_2631)this.getSnapshot()).method_47888();
        return key != null ? CraftNamespacedKey.fromMinecraft(key) : null;
    }

    public void setNoteBlockSound(@Nullable NamespacedKey namespacedKey) {
        if (namespacedKey == null) {
            ((class_2631)this.getSnapshot()).field_41603 = null;
            return;
        }
        ((class_2631)this.getSnapshot()).field_41603 = CraftNamespacedKey.toMinecraft(namespacedKey);
    }

    @Nullable
    public Component customName() {
        return null;
    }

    public void customName(@Nullable Component customName) {
    }

    @Nullable
    public ResolvableProfile getProfile() {
        return this.profile == null ? null : new PaperResolvableProfile(this.profile);
    }

    public void setProfile(@Nullable ResolvableProfile profile) {
        this.profile = profile == null ? null : ((PaperResolvableProfile)profile).getHandle();
    }
}

