/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.entity;

import com.destroystokyo.paper.entity.villager.Reputation;
import com.google.common.base.Preconditions;
import io.papermc.paper.util.OldEnumHolderable;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1646;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_3988;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.cardboardpowered.impl.entity.CraftAbstractVillager;
import org.jetbrains.annotations.Nullable;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, class_1646 entity) {
        super(server, (class_3988)entity);
    }

    public class_1646 getHandle() {
        return (class_1646)this.nms;
    }

    @Override
    public String toString() {
        return "CraftVillager";
    }

    @Override
    public EntityType getType() {
        return EntityType.VILLAGER;
    }

    public Villager.Profession getProfession() {
        return CraftProfession.minecraftHolderToBukkit((class_6880<class_3852>)this.getHandle().method_7231().comp_3521());
    }

    public void setProfession(Villager.Profession profession) {
        Validate.notNull(profession);
        this.getHandle().method_7195(this.getHandle().method_7231().method_16921(CraftProfession.bukkitToMinecraftHolder(profession)));
    }

    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf((String)class_7923.field_41194.method_10221((Object)((class_3854)this.getHandle().method_7231().comp_3520().comp_349())).method_12832().toUpperCase(Locale.ROOT));
    }

    public void setVillagerType(Villager.Type type) {
        Validate.notNull(type);
        this.getHandle().method_7195(this.getHandle().method_7231().method_16922(CraftType.bukkitToMinecraftHolder(type)));
    }

    public int getVillagerLevel() {
        return this.getHandle().method_7231().comp_3522();
    }

    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (Object)"level must be between [1, 5]");
        this.getHandle().method_7195(this.getHandle().method_7231().method_16920(level));
    }

    public int getVillagerExperience() {
        return this.getHandle().method_19269();
    }

    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (Object)"Experience must be positive");
        this.getHandle().method_19625(experience);
    }

    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        class_2338 position = new class_2338(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        class_2680 iblockdata = this.getHandle().method_73183().method_8320(position);
        if (!(iblockdata.method_26204() instanceof class_2244)) {
            return false;
        }
        this.getHandle().method_18403(position);
        return true;
    }

    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        this.getHandle().method_18400();
    }

    public static Villager.Profession nmsToBukkitProfession(class_3852 nms) {
        return Villager.Profession.valueOf((String)class_7923.field_41195.method_10221((Object)nms).method_12832().toUpperCase(Locale.ROOT));
    }

    public static class_3852 bukkitToNmsProfession(Villager.Profession bukkit) {
        return (class_3852)class_7923.field_41195.method_63535(CraftNamespacedKey.toMinecraft(bukkit.getKey()));
    }

    public int getRestocksToday() {
        return -1;
    }

    public void setRestocksToday(int restocksToday) {
    }

    public void clearReputations() {
    }

    public Reputation getReputation(UUID arg0) {
        return null;
    }

    public Map<UUID, Reputation> getReputations() {
        return null;
    }

    public void setReputation(UUID arg0, Reputation arg1) {
    }

    public void setReputations(Map<UUID, Reputation> arg0) {
    }

    public void shakeHead() {
    }

    @Nullable
    public ZombieVillager zombify() {
        return null;
    }

    public boolean addTrades(int arg0) {
        return false;
    }

    public boolean increaseLevel(int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Level earned must be positive");
        int supposedFinalLevel = this.getVillagerLevel() + amount;
        Preconditions.checkArgument((1 <= supposedFinalLevel && supposedFinalLevel <= 5 ? 1 : 0) != 0, (Object)"Final level reached after the donation (%d) must be between [%d, %d]".formatted(supposedFinalLevel, 1, 5));
        Int2ObjectMap trades = (Int2ObjectMap)class_3853.field_17067.get(this.getHandle().method_7231().comp_3521());
        if (trades == null || trades.isEmpty()) {
            this.getHandle().method_7195(this.getHandle().method_7231().method_16920(supposedFinalLevel));
            return false;
        }
        while (amount > 0) {
            --amount;
        }
        return true;
    }

    public void updateDemand() {
    }

    public void restock() {
        this.getHandle().method_19182();
    }

    public static class CraftProfession
    extends OldEnumHolderable<Villager.Profession, class_3852>
    implements Villager.Profession {
        private static int count = 0;

        public static Villager.Profession minecraftHolderToBukkit(class_6880<class_3852> minecraft) {
            return (Villager.Profession)CraftRegistry.minecraftHolderToBukkit(minecraft, class_7924.field_41234);
        }

        public static class_6880<class_3852> bukkitToMinecraftHolder(Villager.Profession bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public static Villager.Profession minecraftToBukkit(class_3852 minecraft) {
            return (Villager.Profession)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41234);
        }

        public static class_3852 bukkitToMinecraft(Villager.Profession bukkit) {
            return (class_3852)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public CraftProfession(class_6880<class_3852> holder) {
            super(holder, count++);
        }
    }

    public static class CraftType
    extends OldEnumHolderable<Villager.Type, class_3854>
    implements Villager.Type {
        private static int count = 0;

        public static Villager.Type minecraftToBukkit(class_3854 minecraft) {
            return (Villager.Type)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41235);
        }

        public static Villager.Type minecraftHolderToBukkit(class_6880<class_3854> minecraft) {
            return (Villager.Type)CraftRegistry.minecraftHolderToBukkit(minecraft, class_7924.field_41235);
        }

        public static class_3854 bukkitToMinecraft(Villager.Type bukkit) {
            return (class_3854)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static class_6880<class_3854> bukkitToMinecraftHolder(Villager.Type bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftType(class_6880<class_3854> holder) {
            super(holder, count++);
        }
    }
}

