/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.inventory;

import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_3944;
import org.bukkit.GameMode;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftContainer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.inventory.CraftMenuType;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.cardboardpowered.impl.inventory.CardboardAbstractInventoryView;
import org.cardboardpowered.interfaces.IMixinScreenHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardboardInventoryView<T extends class_1703, I extends Inventory>
extends CardboardAbstractInventoryView {
    public final class_1703 container;
    public CraftHumanEntity player;
    public final I viewing;
    public final String originalTitle;
    public String title;

    public CardboardInventoryView(HumanEntity player, I viewing, class_1703 container) {
        this.player = null != player ? (CraftHumanEntity)player : null;
        this.viewing = viewing;
        this.container = container;
        this.title = this.originalTitle = CraftChatMessage.fromComponent(((IMixinScreenHandler)container).getTitle());
    }

    public void setPlayerIfNotSet(HumanEntity player) {
        if (null == this.player) {
            this.player = (CraftHumanEntity)player;
        }
    }

    public I getTopInventory() {
        return this.viewing;
    }

    public Inventory getBottomInventory() {
        return this.player.getInventory();
    }

    public HumanEntity getPlayer() {
        return this.player;
    }

    public InventoryType getType() {
        InventoryType type = this.viewing.getType();
        return type == InventoryType.CRAFTING && this.player.getGameMode() == GameMode.CREATIVE ? InventoryType.CREATIVE : type;
    }

    @Override
    public void setItem(int slot, ItemStack item) {
        class_1799 stack = CraftItemStack.asNMSCopy(item);
        if (slot >= 0) {
            this.container.method_7611(slot).method_7673(stack);
        } else {
            this.player.getHandle().method_7328(stack, false);
        }
    }

    @Override
    public ItemStack getItem(int slot) {
        return slot < 0 ? null : CraftItemStack.asCraftMirror(this.container.method_7611(slot).method_7677());
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isInTop(int rawSlot) {
        return rawSlot < this.viewing.getSize();
    }

    public class_1703 getHandle() {
        return this.container;
    }

    @NotNull
    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setTitle(@NotNull String arg0) {
        CardboardInventoryView.sendInventoryTitleChange(this, this.title);
        this.title = arg0;
    }

    public static void sendInventoryTitleChange(InventoryView view, String title) {
        class_3222 entityPlayer = (class_3222)((CraftHumanEntity)view.getPlayer()).getHandle();
        int containerId = entityPlayer.field_7512.field_7763;
        class_3917 windowType = CraftContainer.getNotchInventoryType(view.getTopInventory());
        entityPlayer.field_13987.method_14364((class_2596)new class_3944(containerId, windowType, CraftChatMessage.fromString(title)[0]));
        ((Player)view.getPlayer()).updateInventory();
    }

    public I getTopInventorya() {
        return null;
    }

    @Nullable
    public MenuType getMenuType() {
        class_3917 menuType = this.container.method_17358();
        return menuType != null ? CraftMenuType.minecraftToBukkit(menuType) : null;
    }
}

