/*
 * Decompiled with CFR 0.152.
 */
package org.cardboardpowered.impl.util;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.IndexHelpTopic;

public class HelpYamlReader {
    private YamlConfiguration helpYaml;
    private final char ALT_COLOR_CODE = (char)38;
    private final Server server;

    public HelpYamlReader(Server server) {
        this.server = server;
        File helpYamlFile = new File("help.yml");
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration(new InputStreamReader(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("configurations/help.yml")), Charsets.UTF_8));
        try {
            this.helpYaml = YamlConfiguration.loadConfiguration(helpYamlFile);
            this.helpYaml.options().copyDefaults(true);
            this.helpYaml.setDefaults((Configuration)defaultConfig);
            try {
                if (!helpYamlFile.exists()) {
                    this.helpYaml.save(helpYamlFile);
                }
            }
            catch (IOException ex) {
                server.getLogger().log(Level.SEVERE, "Could not save " + String.valueOf(helpYamlFile), ex);
            }
        }
        catch (Exception ex) {
            server.getLogger().severe("Failed to load help.yml. Verify the yaml indentation is correct. Reverting to default help.yml.");
            this.helpYaml = defaultConfig;
        }
    }

    public List<HelpTopic> getGeneralTopics() {
        LinkedList<HelpTopic> topics = new LinkedList<HelpTopic>();
        ConfigurationSection generalTopics = this.helpYaml.getConfigurationSection("general-topics");
        if (generalTopics != null) {
            for (String topicName : generalTopics.getKeys(false)) {
                ConfigurationSection section = generalTopics.getConfigurationSection(topicName);
                String shortText = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(section.getString("shortText", "")));
                String fullText = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(section.getString("fullText", "")));
                String permission = section.getString("permission", "");
                topics.add(new CustomHelpTopic(topicName, shortText, fullText, permission));
            }
        }
        return topics;
    }

    public List<HelpTopic> getIndexTopics() {
        LinkedList<HelpTopic> topics = new LinkedList<HelpTopic>();
        ConfigurationSection indexTopics = this.helpYaml.getConfigurationSection("index-topics");
        if (indexTopics != null) {
            for (String topicName : indexTopics.getKeys(false)) {
                ConfigurationSection section = indexTopics.getConfigurationSection(topicName);
                String shortText = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(section.getString("shortText", "")));
                String preamble = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(section.getString("preamble", "")));
                String permission = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(section.getString("permission", "")));
                List commands = section.getStringList("commands");
                topics.add((HelpTopic)new CustomIndexHelpTopic(this.server.getHelpMap(), topicName, shortText, permission, commands, preamble));
            }
        }
        return topics;
    }

    public List<HelpTopicAmendment> getTopicAmendments() {
        LinkedList<HelpTopicAmendment> amendments = new LinkedList<HelpTopicAmendment>();
        ConfigurationSection commandTopics = this.helpYaml.getConfigurationSection("amended-topics");
        if (commandTopics != null) {
            for (String topicName : commandTopics.getKeys(false)) {
                ConfigurationSection section = commandTopics.getConfigurationSection(topicName);
                String description = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(section.getString("shortText", "")));
                String usage = ChatColor.translateAlternateColorCodes((char)'&', (String)Objects.requireNonNull(section.getString("fullText", "")));
                String permission = section.getString("permission", "");
                amendments.add(new HelpTopicAmendment(topicName, description, usage, permission));
            }
        }
        return amendments;
    }

    public List<String> getIgnoredPlugins() {
        return this.helpYaml.getStringList("ignore-plugins");
    }

    public boolean commandTopicsInMasterIndex() {
        return this.helpYaml.getBoolean("command-topics-in-master-index", true);
    }

    public static class CustomHelpTopic
    extends HelpTopic {
        private final String permissionNode;

        public CustomHelpTopic(String name, String shortText, String fullText, String permissionNode) {
            this.permissionNode = permissionNode;
            this.name = name;
            this.shortText = shortText;
            this.fullText = shortText + "\n" + fullText;
        }

        public boolean canSee(CommandSender sender) {
            return sender instanceof ConsoleCommandSender || this.permissionNode.equals("") || sender.hasPermission(this.permissionNode);
        }
    }

    public static class CustomIndexHelpTopic
    extends IndexHelpTopic {
        private List<String> futureTopics;
        private final HelpMap helpMap;

        public CustomIndexHelpTopic(HelpMap helpMap, String name, String shortText, String permission, List<String> futureTopics, String preamble) {
            super(name, shortText, permission, new HashSet(), preamble);
            this.helpMap = helpMap;
            this.futureTopics = futureTopics;
        }

        public String getFullText(CommandSender sender) {
            if (this.futureTopics != null) {
                LinkedList<HelpTopic> topics = new LinkedList<HelpTopic>();
                for (String futureTopic : this.futureTopics) {
                    HelpTopic topic = this.helpMap.getHelpTopic(futureTopic);
                    if (topic == null) continue;
                    topics.add(topic);
                }
                this.setTopicsCollection(topics);
                this.futureTopics = null;
            }
            return super.getFullText(sender);
        }
    }

    public static class HelpTopicAmendment {
        public final String topicName;
        public final String shortText;
        public final String fullText;
        public final String permission;

        public HelpTopicAmendment(String topicName, String shortText, String fullText, String permission) {
            this.fullText = fullText;
            this.shortText = shortText;
            this.topicName = topicName;
            this.permission = permission;
        }
    }
}

