/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.loottable;

import com.destroystokyo.paper.loottable.LootableInventoryReplenishEvent;
import com.destroystokyo.paper.loottable.PaperLootableInventory;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_4844;
import org.bukkit.entity.Player;
import org.bukkit.loot.LootTable;
import org.cardboardpowered.CardboardMod;

public class PaperLootableInventoryData {
    private static final Random RANDOM = new Random();
    private long lastFill = -1L;
    private long nextRefill = -1L;
    private int numRefills = 0;
    private Map<UUID, Long> lootedPlayers;
    private final PaperLootableInventory lootable;
    private static final String ROOT = "Paper.LootableData";
    private static final String LAST_FILL = "lastFill";
    private static final String NEXT_REFILL = "nextRefill";
    private static final String NUM_REFILLS = "numRefills";
    private static final String LOOTED_PLAYERS = "lootedPlayers";

    public PaperLootableInventoryData(PaperLootableInventory lootable) {
        this.lootable = lootable;
    }

    long getLastFill() {
        return this.lastFill;
    }

    long getNextRefill() {
        return this.nextRefill;
    }

    long setNextRefill(long nextRefill) {
        long prev = this.nextRefill;
        this.nextRefill = nextRefill;
        return prev;
    }

    public boolean shouldReplenish(@Nullable class_1657 player) {
        LootTable table = this.lootable.getLootTable();
        if (table == null) {
            return false;
        }
        if (this.lastFill == -1L) {
            return true;
        }
        if (player == null) {
            return false;
        }
        if (this.nextRefill == -1L) {
            return false;
        }
        if (this.nextRefill > System.currentTimeMillis()) {
            return false;
        }
        Player bukkitPlayer = (Player)player.getBukkitEntity();
        LootableInventoryReplenishEvent event = new LootableInventoryReplenishEvent(bukkitPlayer, this.lootable.getAPILootableInventory());
        event.setCancelled(!this.canPlayerLoot(player.method_5667(), null));
        return event.callEvent();
    }

    public void processRefill(@Nullable class_1657 player) {
        this.lastFill = System.currentTimeMillis();
        CardboardMod.LOGGER.info("processRefil: TODO stub");
    }

    public void loadNbt(class_11368 input) {
        class_11368 data = input.method_71434(ROOT);
        this.lastFill = data.method_71425(LAST_FILL, -1L);
        this.nextRefill = data.method_71425(NEXT_REFILL, -1L);
        this.numRefills = data.method_71424(NUM_REFILLS, 0);
        class_11368.class_11369 list = data.method_71437(LOOTED_PLAYERS, SerializedLootedPlayerEntry.CODEC);
        if (!list.method_71453()) {
            this.lootedPlayers = new HashMap<UUID, Long>();
            list.forEach(serializedLootedPlayerEntry -> this.lootedPlayers.put(serializedLootedPlayerEntry.uuid, serializedLootedPlayerEntry.time));
        }
    }

    public void saveNbt(class_11372 output) {
        class_11372 data = output.method_71461(ROOT);
        if (this.nextRefill != -1L) {
            data.method_71466(NEXT_REFILL, this.nextRefill);
        }
        if (this.lastFill != -1L) {
            data.method_71466(LAST_FILL, this.lastFill);
        }
        if (this.numRefills != 0) {
            data.method_71465(NUM_REFILLS, this.numRefills);
        }
        if (this.lootedPlayers != null && !this.lootedPlayers.isEmpty()) {
            class_11372.class_11373 list = data.method_71467(LOOTED_PLAYERS, SerializedLootedPlayerEntry.CODEC);
            for (Map.Entry<UUID, Long> entry : this.lootedPlayers.entrySet()) {
                list.method_71484((Object)new SerializedLootedPlayerEntry(entry.getKey(), entry.getValue()));
            }
        }
        if (data.method_71457()) {
            output.method_71478(ROOT);
        }
    }

    void setPlayerLootedState(UUID player, boolean looted) {
        if (looted && this.lootedPlayers == null) {
            this.lootedPlayers = new HashMap<UUID, Long>();
        }
        if (looted) {
            this.lootedPlayers.put(player, System.currentTimeMillis());
        } else if (this.lootedPlayers != null) {
            this.lootedPlayers.remove(player);
        }
    }

    boolean canPlayerLoot(UUID player, Object worldConfiguration) {
        Long lastLooted = this.getLastLooted(player);
        if (lastLooted == null) {
            return true;
        }
        return true;
    }

    boolean hasPlayerLooted(UUID player) {
        return this.lootedPlayers != null && this.lootedPlayers.containsKey(player);
    }

    Long getLastLooted(UUID player) {
        return this.lootedPlayers != null ? this.lootedPlayers.get(player) : null;
    }

    record SerializedLootedPlayerEntry(UUID uuid, long time) {
        public static final Codec<SerializedLootedPlayerEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("UUID").forGetter(SerializedLootedPlayerEntry::uuid), (App)Codec.LONG.optionalFieldOf("Time", (Object)0L).forGetter(SerializedLootedPlayerEntry::time)).apply((Applicative)instance, SerializedLootedPlayerEntry::new));
    }
}

