/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.WritableBookContent;
import io.papermc.paper.text.Filtered;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import org.bukkit.craftbukkit.util.Handleable;
import org.jetbrains.annotations.Unmodifiable;

public record PaperWritableBookContent(class_9301 impl) implements WritableBookContent,
Handleable<class_9301>
{
    @Override
    public class_9301 getHandle() {
        return this.impl;
    }

    public @Unmodifiable List<Filtered<String>> pages() {
        return MCUtil.transformUnmodifiable(this.impl.comp_2422(), input -> Filtered.of((Object)((String)input.comp_2369()), (Object)input.comp_2370().orElse(null)));
    }

    static final class BuilderImpl
    implements WritableBookContent.Builder {
        private final List<class_9262<String>> pages = new ObjectArrayList();

        BuilderImpl() {
        }

        private static void validatePageLength(String page) {
            Preconditions.checkArgument((page.length() <= 1024 ? 1 : 0) != 0, (String)"Cannot have page length more than %s, had %s", (int)1024, (int)page.length());
        }

        private static void validatePageCount(int current, int add) {
            int newSize = current + add;
            Preconditions.checkArgument((newSize <= 100 ? 1 : 0) != 0, (String)"Cannot have more than %s pages, had %s", (int)100, (int)newSize);
        }

        public WritableBookContent.Builder addPage(String page) {
            BuilderImpl.validatePageLength(page);
            BuilderImpl.validatePageCount(this.pages.size(), 1);
            this.pages.add((class_9262<String>)class_9262.method_57137((Object)page));
            return this;
        }

        public WritableBookContent.Builder addPages(List<String> pages) {
            BuilderImpl.validatePageCount(this.pages.size(), pages.size());
            for (String page : pages) {
                BuilderImpl.validatePageLength(page);
                this.pages.add((class_9262<String>)class_9262.method_57137((Object)page));
            }
            return this;
        }

        public WritableBookContent.Builder addFilteredPage(Filtered<String> page) {
            BuilderImpl.validatePageLength((String)page.raw());
            if (page.filtered() != null) {
                BuilderImpl.validatePageLength((String)page.filtered());
            }
            BuilderImpl.validatePageCount(this.pages.size(), 1);
            this.pages.add((class_9262<String>)new class_9262((Object)((String)page.raw()), Optional.ofNullable((String)page.filtered())));
            return this;
        }

        public WritableBookContent.Builder addFilteredPages(List<Filtered<String>> pages) {
            BuilderImpl.validatePageCount(this.pages.size(), pages.size());
            for (Filtered<String> page : pages) {
                BuilderImpl.validatePageLength((String)page.raw());
                if (page.filtered() != null) {
                    BuilderImpl.validatePageLength((String)page.filtered());
                }
                this.pages.add((class_9262<String>)new class_9262((Object)((String)page.raw()), Optional.ofNullable((String)page.filtered())));
            }
            return this;
        }

        public WritableBookContent build() {
            if (this.pages.isEmpty()) {
                return new PaperWritableBookContent(class_9301.field_49369);
            }
            return new PaperWritableBookContent(new class_9301((List)new ObjectArrayList(this.pages)));
        }
    }
}

