/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item.consumable;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.consumable.ConsumableTypesBridge;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.datacomponent.item.consumable.PaperApplyStatusEffects;
import io.papermc.paper.datacomponent.item.consumable.PaperClearAllStatusEffects;
import io.papermc.paper.datacomponent.item.consumable.PaperPlaySound;
import io.papermc.paper.datacomponent.item.consumable.PaperRemoveStatusEffects;
import io.papermc.paper.datacomponent.item.consumable.PaperTeleportRandomly;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.minecraft.class_10132;
import net.minecraft.class_10133;
import net.minecraft.class_10136;
import net.minecraft.class_10137;
import net.minecraft.class_10138;
import net.minecraft.class_7924;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.cardboardpowered.Registries_Bridge;
import org.cardboardpowered.impl.CardboardPotionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Internal
public class ConsumableTypesBridgeImpl
implements ConsumableTypesBridge {
    public ConsumeEffect.ApplyStatusEffects applyStatusEffects(List<PotionEffect> effectList, float probability) {
        Preconditions.checkArgument((0.0f <= probability && probability <= 1.0f ? 1 : 0) != 0, (String)"probability must be between 0-1, was %s", (Object)Float.valueOf(probability));
        return new PaperApplyStatusEffects(new class_10132(new ArrayList(Lists.transform(effectList, CardboardPotionUtil::fromBukkit)), probability));
    }

    public ConsumeEffect.RemoveStatusEffects removeStatusEffects(RegistryKeySet<PotionEffectType> effectTypes) {
        return new PaperRemoveStatusEffects(new class_10137(PaperRegistrySets.convertToNms(class_7924.field_41208, Registries_Bridge.BUILT_IN_CONVERSIONS.lookup(), effectTypes)));
    }

    public ConsumeEffect.ClearAllStatusEffects clearAllStatusEffects() {
        return new PaperClearAllStatusEffects(new class_10133());
    }

    public ConsumeEffect.PlaySound playSoundEffect(Key sound) {
        return new PaperPlaySound(new class_10136(PaperAdventure.resolveSound(sound)));
    }

    public ConsumeEffect.TeleportRandomly teleportRandomlyEffect(float diameter) {
        Preconditions.checkArgument((diameter > 0.0f ? 1 : 0) != 0, (String)"diameter must be positive, was %s", (Object)Float.valueOf(diameter));
        return new PaperTeleportRandomly(new class_10138(diameter));
    }
}

