/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.entry;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.WritableCraftRegistry;
import io.papermc.paper.registry.entry.RegistryTypeMapper;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.ApiVersion;

public sealed interface RegistryEntryMeta<M, A extends Keyed> {
    public class_5321<? extends class_2378<M>> mcKey();

    public RegistryKey<A> apiKey();

    public Registry<A> createApiRegistry(class_2378<M> var1);

    default public RegistryModificationApiSupport modificationApiSupport() {
        return RegistryModificationApiSupport.NONE;
    }

    public static enum RegistryModificationApiSupport {
        NONE,
        ADDABLE,
        MODIFIABLE,
        WRITABLE;


        public boolean canAdd() {
            return this != MODIFIABLE && this != NONE;
        }

        public boolean canModify() {
            return this != ADDABLE && this != NONE;
        }
    }

    public record Buildable<M, A extends Keyed, B extends PaperRegistryBuilder<M, A>>(class_5321<? extends class_2378<M>> mcKey, RegistryKey<A> apiKey, Class<?> classToPreload, RegistryTypeMapper<M, A> registryTypeMapper, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater, PaperRegistryBuilder.Filler<M, A, B> builderFiller, RegistryModificationApiSupport modificationApiSupport) implements ServerSide<M, A>
    {
        @Override
        public Registry<A> createApiRegistry(class_2378<M> nmsRegistry) {
            if (this.modificationApiSupport.canAdd()) {
                return new WritableCraftRegistry((class_2370)nmsRegistry, this);
            }
            return ServerSide.super.createApiRegistry(nmsRegistry);
        }
    }

    public record Craft<M, A extends Keyed>(class_5321<? extends class_2378<M>> mcKey, RegistryKey<A> apiKey, Class<?> classToPreload, RegistryTypeMapper<M, A> registryTypeMapper, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater) implements ServerSide<M, A>
    {
        public Craft {
            String pac = classToPreload.getPackageName();
            if (pac.startsWith("net.minecraft")) {
                System.out.println("ignoring preload of " + String.valueOf(classToPreload));
            }
        }
    }

    public static sealed interface ServerSide<M, A extends Keyed>
    extends RegistryEntryMeta<M, A>
    permits Craft, Buildable {
        public Class<?> classToPreload();

        public RegistryTypeMapper<M, A> registryTypeMapper();

        public BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater();

        @Override
        default public Registry<A> createApiRegistry(class_2378<M> nmsRegistry) {
            return new CraftRegistry(this, nmsRegistry);
        }
    }

    public record ApiOnly<M, A extends Keyed>(class_5321<? extends class_2378<M>> mcKey, RegistryKey<A> apiKey, Supplier<Registry<A>> registrySupplier) implements RegistryEntryMeta<M, A>
    {
        @Override
        public Registry<A> createApiRegistry(class_2378<M> nmsRegistry) {
            return this.registrySupplier.get();
        }
    }
}

