/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.event;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public final class RegistryEventMap {
    private final Map<RegistryKey<?>, LifecycleEventType<BootstrapContext, ? extends LifecycleEvent, ?>> eventTypes = new HashMap();
    private final String name;

    public RegistryEventMap(String name) {
        this.name = name;
    }

    public <T, E extends LifecycleEvent, ET extends LifecycleEventType<BootstrapContext, E, ?>> ET getOrCreate(RegistryKey<T> registryKey, BiFunction<? super RegistryKey<T>, ? super String, ET> eventTypeCreator) {
        LifecycleEventType eventType;
        if (this.eventTypes.containsKey(registryKey)) {
            eventType = this.eventTypes.get(registryKey);
        } else {
            eventType = (LifecycleEventType)eventTypeCreator.apply(registryKey, this.name);
            this.eventTypes.put(registryKey, eventType);
        }
        return (ET)eventType;
    }

    public <T, E extends LifecycleEvent> LifecycleEventType<BootstrapContext, E, ?> getEventType(RegistryKey<T> registryKey) {
        return Objects.requireNonNull(this.eventTypes.get(registryKey), "No hook for " + String.valueOf(registryKey));
    }

    public boolean hasHandlers(RegistryKey<?> registryKey) {
        return false;
    }
}

