/*
 * Decompiled with CFR 0.152.
 */
package net.techcable.srglib.format;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.techcable.srglib.FieldData;
import net.techcable.srglib.JavaType;
import net.techcable.srglib.MethodData;
import net.techcable.srglib.MethodSignature;
import net.techcable.srglib.format.MappingsFormat;
import net.techcable.srglib.mappings.ImmutableMappings;
import net.techcable.srglib.mappings.Mappings;
import net.techcable.srglib.utils.LineProcessor;
import org.checkerframework.checker.nullness.qual.NonNull;

class CompactSrgMappingsFormat
implements MappingsFormat {
    public static final CompactSrgMappingsFormat INSTANCE = new CompactSrgMappingsFormat();

    CompactSrgMappingsFormat() {
    }

    @Override
    public LineProcessor<Mappings> createLineProcessor() {
        return new SrgLineProcessor();
    }

    @Override
    public void write(Mappings mappings, Appendable output) throws IOException {
        try {
            mappings.forEachClass((original, renamed) -> {
                try {
                    output.append(original.getInternalName());
                    output.append(' ');
                    output.append(renamed.getInternalName());
                    output.append('\n');
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            mappings.forEachField((original, renamed) -> {
                try {
                    output.append(original.getDeclaringType().getInternalName());
                    output.append(' ');
                    output.append(original.getName());
                    output.append(' ');
                    output.append(renamed.getName());
                    output.append('\n');
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            mappings.forEachMethod((original, renamed) -> {
                try {
                    output.append(original.getDeclaringType().getInternalName());
                    output.append(' ');
                    output.append(original.getName());
                    output.append(' ');
                    output.append(original.getSignature().getDescriptor());
                    output.append(' ');
                    output.append(renamed.getName());
                    output.append('\n');
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    static class SrgLineProcessor
    implements LineProcessor<Mappings> {
        private final Map<JavaType, JavaType> types = new LinkedHashMap<JavaType, JavaType>();
        private final Map<MethodData, String> methods = new LinkedHashMap<MethodData, String>();
        private final Map<FieldData, String> fields = new LinkedHashMap<FieldData, String>();

        SrgLineProcessor() {
        }

        @Override
        public boolean processLine(@NonNull String line) throws IOException {
            this.parseLine(line);
            return true;
        }

        public void parseLine(@NonNull String line) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) {
                return;
            }
            String[] args = line.split(" ");
            switch (args.length) {
                case 2: {
                    JavaType originalType = JavaType.fromInternalName(args[0]);
                    JavaType renamedType = JavaType.fromInternalName(args[1]);
                    this.types.put(originalType, renamedType);
                    break;
                }
                case 3: {
                    JavaType originalDeclaringType = JavaType.fromInternalName(args[0]);
                    String originalName = args[1];
                    String newName = args[2];
                    this.fields.put(FieldData.create(originalDeclaringType, originalName), newName);
                    break;
                }
                case 4: {
                    JavaType originalDeclaringType = JavaType.fromInternalName(args[0]);
                    String originalName = args[1];
                    MethodSignature signature = MethodSignature.fromDescriptor(args[2]);
                    String newName = args[3];
                    this.methods.put(MethodData.create(originalDeclaringType, originalName, signature), newName);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid line: " + line);
                }
            }
        }

        @Override
        public Mappings getResult() {
            HashMap<JavaType, JavaType> types = new HashMap<JavaType, JavaType>(this.types);
            HashMap<MethodData, MethodData> methods = new HashMap<MethodData, MethodData>();
            HashMap<FieldData, FieldData> fields = new HashMap<FieldData, FieldData>();
            this.methods.forEach((originalData, newName) -> methods.put((MethodData)originalData, originalData.mapTypes(original -> types.getOrDefault(original, (JavaType)original)).withName((String)newName)));
            this.fields.forEach((originalData, newName) -> fields.put((FieldData)originalData, originalData.mapTypes(original -> types.getOrDefault(original, (JavaType)original)).withName((String)newName)));
            return ImmutableMappings.create(types, methods, fields);
        }
    }
}

