/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_169;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.cardboardpowered.impl.world.CraftWorld;

public class CraftLootTable
implements LootTable {
    private final class_52 handle;
    private final NamespacedKey key;

    public static LootTable minecraftToBukkit(class_2960 minecraft) {
        return minecraft == null ? null : Bukkit.getLootTable((NamespacedKey)CraftNamespacedKey.fromMinecraft(minecraft));
    }

    public static LootTable minecraftToBukkit(class_5321<class_52> minecraft) {
        return minecraft == null || minecraft.method_29177().method_12832().isEmpty() ? null : Bukkit.getLootTable((NamespacedKey)CraftLootTable.minecraftToBukkitKey(minecraft));
    }

    public static NamespacedKey minecraftToBukkitKey(class_5321<class_52> minecraft) {
        return minecraft == null ? null : CraftNamespacedKey.fromMinecraft(minecraft.method_29177());
    }

    public static class_5321<class_52> bukkitToMinecraft(LootTable table) {
        return table == null ? null : CraftLootTable.bukkitKeyToMinecraft(table.getKey());
    }

    public static class_5321<class_52> bukkitKeyToMinecraft(NamespacedKey key) {
        return key == null ? null : class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)CraftNamespacedKey.toMinecraft(key));
    }

    public CraftLootTable(NamespacedKey key, class_52 handle) {
        this.handle = handle;
        this.key = key;
    }

    public class_52 getHandle() {
        return this.handle;
    }

    public Collection<ItemStack> populateLoot(Random random, LootContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        class_8567 nmsContext = this.convertContext(context, random);
        ObjectArrayList nmsItems = this.handle.method_51878(nmsContext);
        ArrayList<ItemStack> bukkit = new ArrayList<ItemStack>(nmsItems.size());
        for (class_1799 item : nmsItems) {
            if (item.method_7960()) continue;
            bukkit.add(CraftItemStack.asBukkitCopy(item));
        }
        return bukkit;
    }

    public void fillInventory(Inventory inventory, Random random, LootContext context) {
        Preconditions.checkArgument((inventory != null ? 1 : 0) != 0, (Object)"Inventory cannot be null");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        class_8567 nmsContext = this.convertContext(context, random);
        CraftInventory craftInventory = (CraftInventory)inventory;
        class_1263 handle = craftInventory.getInventory();
        this.getHandle().method_329(handle, nmsContext, random.nextLong());
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    private class_8567 convertContext(LootContext context, Random random) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        Location loc = context.getLocation();
        Preconditions.checkArgument((loc.getWorld() != null ? 1 : 0) != 0, (Object)"LootContext.getLocation#getWorld cannot be null");
        class_3218 handle = ((CraftWorld)loc.getWorld()).getHandle();
        class_8567.class_8568 builder = new class_8567.class_8568(handle);
        if (random != null) {
            // empty if block
        }
        this.setMaybe(builder, class_181.field_24424, CraftLocation.toVec3D(loc));
        if (this.getHandle() != class_52.field_948) {
            if (context.getLootedEntity() != null) {
                class_1297 nmsLootedEntity = ((CraftEntity)context.getLootedEntity()).getHandle();
                this.setMaybe(builder, class_181.field_1226, nmsLootedEntity);
                this.setMaybe(builder, class_181.field_1231, handle.method_48963().method_48830());
                this.setMaybe(builder, class_181.field_24424, nmsLootedEntity.method_19538());
            }
            if (context.getKiller() != null) {
                class_1657 nmsKiller = ((CraftHumanEntity)context.getKiller()).getHandle();
                this.setMaybe(builder, class_181.field_1230, nmsKiller);
                this.setMaybe(builder, class_181.field_1231, handle.method_48963().method_48802(nmsKiller));
                this.setMaybe(builder, class_181.field_1233, nmsKiller);
                this.setMaybe(builder, class_181.field_1229, nmsKiller.method_6030());
            }
        }
        class_176.class_177 nmsBuilder = new class_176.class_177();
        for (class_169 param : this.getHandle().method_322().method_778()) {
            nmsBuilder.method_781(param);
        }
        for (class_169 param : this.getHandle().method_322().method_777()) {
            if (this.getHandle().method_322().method_778().contains(param)) continue;
            nmsBuilder.method_780(param);
        }
        return builder.method_51875(this.getHandle().method_322());
    }

    private <T> void setMaybe(class_8567.class_8568 builder, class_169<T> param, T value) {
        if (this.getHandle().method_322().method_778().contains(param) || this.getHandle().method_322().method_777().contains(param)) {
            builder.method_51874(param, value);
        }
    }

    public static LootContext convertContext(class_47 info) {
        CraftEntity killer;
        class_243 position = (class_243)info.method_65013(class_181.field_24424);
        if (position == null) {
            position = ((class_1297)info.method_65013(class_181.field_1226)).method_19538();
        }
        Location location = CraftLocation.toBukkit(position, (World)info.method_299().getWorld());
        LootContext.Builder contextBuilder = new LootContext.Builder(location);
        if (info.method_300(class_181.field_1230) && (killer = ((class_1297)info.method_65013(class_181.field_1230)).getBukkitEntity()) instanceof CraftHumanEntity) {
            contextBuilder.killer((HumanEntity)((CraftHumanEntity)killer));
        }
        if (info.method_300(class_181.field_1226)) {
            contextBuilder.lootedEntity((Entity)((class_1297)info.method_65013(class_181.field_1226)).getBukkitEntity());
        }
        contextBuilder.luck(info.method_302());
        return contextBuilder.build();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LootTable)) {
            return false;
        }
        LootTable table = (LootTable)obj;
        return table.getKey().equals((Object)this.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

