/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.authlib.GameProfile;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_29;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3340;
import net.minecraft.class_4208;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.cardboardpowered.interfaces.IMixinWorldSaveHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializableAs(value="Player")
public class CraftOfflinePlayer
implements OfflinePlayer,
ConfigurationSerializable {
    private final GameProfile profile;
    private final CraftServer server;
    private final class_29 storage;

    protected CraftOfflinePlayer(CraftServer server, GameProfile profile) {
        this.server = server;
        this.profile = profile;
        this.storage = server.getServer().getSaveHandler_BF();
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public boolean isOnline() {
        System.out.println("isOnline: " + this.profile.toString() + ", " + (this.getPlayer() != null));
        return this.getPlayer() != null;
    }

    public String getName() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getName();
        }
        if (this.profile.getName() != null) {
            return this.profile.getName();
        }
        class_2487 data = this.getBukkitData();
        if (data != null) {
            return data.method_10558("lastKnownName").orElse(null);
        }
        return null;
    }

    public UUID getUniqueId() {
        return this.profile.getId();
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isOp() {
        return this.server.getHandle().method_3760().method_14569(this.profile);
    }

    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().method_3760().method_14582(this.profile);
        } else {
            this.server.getHandle().method_3760().method_14604(this.profile);
        }
    }

    public boolean isBanned() {
        return this.getName() == null ? false : this.server.getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    public void setBanned(boolean value) {
        if (this.getName() == null) {
            return;
        }
        if (value) {
            this.server.getBanList(BanList.Type.PROFILE).addBan((Object)this.getPlayerProfile(), null, (Date)null, null);
        } else {
            this.server.getBanList(BanList.Type.PROFILE).pardon((Object)this.getPlayerProfile());
        }
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().method_3760().method_14590().method_14653(this.profile);
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().method_3760().method_14590().method_14633((class_3330)new class_3340(this.profile));
        } else {
            this.server.getHandle().method_3760().method_14590().method_14635((Object)this.profile);
        }
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("UUID", this.profile.getId().toString());
        return result;
    }

    public static OfflinePlayer deserialize(Map<String, Object> args) {
        if (args.get("name") != null) {
            return Bukkit.getServer().getOfflinePlayer((String)args.get("name"));
        }
        return Bukkit.getServer().getOfflinePlayer(UUID.fromString((String)args.get("UUID")));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[UUID=" + String.valueOf(this.profile.getId()) + "]";
    }

    public Player getPlayer() {
        return this.server.getPlayer(this.getUniqueId());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(other.getUniqueId());
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        return hash;
    }

    private class_2487 getData() {
        return ((IMixinWorldSaveHandler)this.storage).getPlayerData(this.getUniqueId().toString());
    }

    private class_2487 getBukkitData() {
        class_2487 result = this.getData();
        if (result != null) {
            result = result.method_10562("bukkit").orElse(null);
        }
        return result;
    }

    private File getDataFile() {
        return new File(this.storage.field_144, String.valueOf(this.getUniqueId()) + ".dat");
    }

    public long getFirstPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getFirstPlayed();
        }
        class_2487 data = this.getBukkitData();
        if (data != null) {
            return data.method_10537("firstPlayed").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    public long getLastPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastPlayed();
        }
        class_2487 data = this.getBukkitData();
        if (data != null) {
            return data.method_10537("lastPlayed").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    public boolean hasPlayedBefore() {
        return this.getData() != null;
    }

    public Location getBedSpawnLocation() {
        class_2487 data = this.getData();
        if (data == null) {
            return null;
        }
        if (data.method_10545("SpawnX") && data.method_10545("SpawnY") && data.method_10545("SpawnZ")) {
            String spawnWorld = data.method_10558("SpawnWorld").orElse(null);
            if (spawnWorld.equals("")) {
                spawnWorld = this.server.getWorlds().get(0).getName();
            }
            int x = data.method_10550("SpawnX").orElse(null);
            int y = data.method_10550("SpawnY").orElse(null);
            int z = data.method_10550("SpawnZ").orElse(null);
            return new Location(this.server.getWorld(spawnWorld), (double)x, (double)y, (double)z);
        }
        return null;
    }

    public void setMetadata(String metadataKey, MetadataValue metadataValue) {
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return null;
    }

    public boolean hasMetadata(String metadataKey) {
        return false;
    }

    public void removeMetadata(String metadataKey, Plugin plugin) {
    }

    public void incrementStatistic(Statistic statistic) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic);
        }
    }

    public void decrementStatistic(Statistic statistic) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic);
        }
    }

    public int getStatistic(Statistic statistic) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic);
        }
        return 0;
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, amount);
        }
    }

    public void setStatistic(Statistic statistic, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, newValue);
        }
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, material);
        }
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, material);
        }
    }

    public int getStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic, material);
        }
        return 0;
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, material, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, material, amount);
        }
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, material, newValue);
        }
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, entityType);
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, entityType);
        }
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic, entityType);
        }
        return 0;
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, entityType, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, entityType, amount);
        }
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
    }

    public long getLastLogin() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastLogin();
        }
        class_2487 data = this.getPaperData();
        if (data != null) {
            return data.method_10537("LastLogin").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    public long getLastSeen() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastSeen();
        }
        class_2487 data = this.getPaperData();
        if (data != null) {
            return data.method_10537("LastSeen").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    private class_2487 getPaperData() {
        class_2487 result = this.getData();
        if (result != null) {
            result = result.method_10562("Paper").orElse(null);
        }
        return result;
    }

    @NotNull
    public @NotNull @NotNull PlayerProfile getPlayerProfile() {
        return null;
    }

    @Nullable
    public Location getLastDeathLocation() {
        class_2487 data = this.getData();
        if (data == null) {
            return null;
        }
        return data.method_67491("LastDeathLocation", class_4208.field_25066).map(CraftLocation::fromGlobalPos).orElse(null);
    }

    public boolean isConnected() {
        return false;
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String reason, @Nullable Date expires, @Nullable String source) {
        return null;
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String reason, @Nullable Instant expires, @Nullable String source) {
        return null;
    }

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String reason, @Nullable Duration duration, @Nullable String source) {
        return null;
    }

    @Nullable
    public Location getRespawnLocation() {
        return this.getRespawnLocation(false);
    }

    public Location getRespawnLocation(boolean loadLocationAdValidate) {
        class_2487 data = this.getData();
        if (data == null) {
            return null;
        }
        class_3222.class_10766 respawnConfig = data.method_67491("respawn", class_3222.class_10766.field_56608).orElse(null);
        if (respawnConfig == null) {
            return null;
        }
        class_3218 level = CraftServer.console.method_3847(respawnConfig.comp_3683());
        if (level == null) {
            return null;
        }
        return CraftLocation.toBukkit(respawnConfig.comp_3684(), (World)level.getWorld(), respawnConfig.comp_3685(), 0.0f);
    }

    public Location getLocation() {
        class_2487 data = this.getData();
        if (data == null) {
            return null;
        }
        class_243 pos = data.method_67491("Pos", class_243.field_38277).orElse(null);
        class_241 rot = data.method_67491("Rotation", class_241.field_56695).orElse(null);
        if (pos != null && rot != null) {
            Long msb = data.method_10537("WorldUUIDMost").orElse(null);
            Long lsb = data.method_10537("WorldUUIDLeast").orElse(null);
            World world = msb != null && lsb != null ? this.server.getWorld(new UUID(msb, lsb)) : null;
            return new Location(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), rot.field_1343, rot.field_1342);
        }
        return null;
    }

    @NotNull
    public PersistentDataContainerView getPersistentDataContainer() {
        return null;
    }
}

