/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import net.minecraft.class_1429;
import net.minecraft.class_6880;
import net.minecraft.class_7102;
import net.minecraft.class_7106;
import net.minecraft.class_7924;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;
import org.cardboardpowered.impl.entity.CraftAnimals;
import org.cardboardpowered.interfaces.IMixinEntity;

public class CraftFrog
extends CraftAnimals
implements Frog {
    public CraftFrog(CraftServer server, class_7102 entity) {
        super(server, (class_1429)entity);
    }

    public class_7102 getHandle() {
        return (class_7102)this.nms;
    }

    @Override
    public String toString() {
        return "CraftFrog";
    }

    public Entity getTongueTarget() {
        return this.getHandle().method_41360().map(IMixinEntity::getBukkitEntity).orElse(null);
    }

    public void setTongueTarget(Entity target) {
        if (target == null) {
            this.getHandle().method_41359();
        } else {
            this.getHandle().method_41352(((CraftEntity)target).getHandle());
        }
    }

    public Frog.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit((class_6880<class_7106>)this.getHandle().method_41354());
    }

    public void setVariant(Frog.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().method_41353(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    implements Frog.Variant,
    Handleable<class_7106> {
        private static int count = 0;
        private final NamespacedKey key;
        private final class_7106 frogVariant;
        private final String name;
        private final int ordinal;

        public static Frog.Variant minecraftToBukkit(class_7106 minecraft) {
            return (Frog.Variant)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_41272);
        }

        public static Frog.Variant minecraftHolderToBukkit(class_6880<class_7106> minecraft) {
            return CraftVariant.minecraftToBukkit((class_7106)minecraft.comp_349());
        }

        public static class_7106 bukkitToMinecraft(Frog.Variant bukkit) {
            return (class_7106)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static class_6880<class_7106> bukkitToMinecraftHolder(Frog.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, class_7924.field_41272);
        }

        public CraftVariant(NamespacedKey key, class_7106 frogVariant) {
            this.key = key;
            this.frogVariant = frogVariant;
            this.name = "minecraft".equals(key.getNamespace()) ? key.getKey().toUpperCase(Locale.ROOT) : key.toString();
            this.ordinal = count++;
        }

        @Override
        public class_7106 getHandle() {
            return this.frogVariant;
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public int compareTo(Frog.Variant variant) {
            return this.ordinal - variant.ordinal();
        }

        public String name() {
            return this.name;
        }

        public int ordinal() {
            return this.ordinal;
        }

        public String toString() {
            return this.name();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CraftVariant)) {
                return false;
            }
            return this.getKey().equals((Object)((Frog.Variant)other).getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }
    }
}

