/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import net.kyori.adventure.text.Component;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1704;
import net.minecraft.class_1706;
import net.minecraft.class_1707;
import net.minecraft.class_1708;
import net.minecraft.class_1714;
import net.minecraft.class_1716;
import net.minecraft.class_1718;
import net.minecraft.class_1722;
import net.minecraft.class_1726;
import net.minecraft.class_1728;
import net.minecraft.class_1733;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3705;
import net.minecraft.class_3706;
import net.minecraft.class_3803;
import net.minecraft.class_3858;
import net.minecraft.class_3910;
import net.minecraft.class_3913;
import net.minecraft.class_3916;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_3944;
import net.minecraft.class_3971;
import net.minecraft.class_4862;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.inventory.CraftMenuType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.cardboardpowered.impl.entity.CraftPlayer;
import org.cardboardpowered.impl.inventory.CardboardAbstractInventoryView;
import org.cardboardpowered.impl.inventory.CardboardInventoryView;
import org.cardboardpowered.interfaces.IMixinScreenHandler;
import org.jetbrains.annotations.Nullable;

public class CraftContainer
extends class_1703 {
    private final InventoryView view;
    private InventoryType cachedType;
    private String cachedTitle;
    private class_1703 delegate;
    private final int cachedSize;

    public CraftContainer(InventoryView view, class_1657 player, int id) {
        super(CraftContainer.getNotchInventoryType(view.getTopInventory()), id);
        this.view = view;
        class_1263 top = ((CraftInventory)view.getTopInventory()).getInventory();
        class_1661 bottom = (class_1661)((CraftInventory)view.getBottomInventory()).getInventory();
        this.cachedType = view.getType();
        this.cachedTitle = view.getTitle();
        this.cachedSize = this.getSize();
        this.setupSlots(top, bottom, player);
    }

    public CraftContainer(final Inventory inventory, final class_1657 player, int id) {
        this(new CardboardAbstractInventoryView(){
            private final String originalTitle;
            private String title;
            {
                this.originalTitle = inventory instanceof CraftInventoryCustom ? ((CraftInventoryCustom.MinecraftInventory)((CraftInventory)inventory).getInventory()).getTitle() : inventory.getType().getDefaultTitle();
                this.title = this.originalTitle;
            }

            public Inventory getTopInventory() {
                return inventory;
            }

            public Inventory getBottomInventory() {
                return this.getPlayer().getInventory();
            }

            public HumanEntity getPlayer() {
                return (HumanEntity)player.getBukkitEntity();
            }

            public InventoryType getType() {
                return inventory.getType();
            }

            public Component title() {
                Component component = null;
                if (inventory instanceof CraftInventoryCustom) {
                    CraftInventoryCustom craftInventoryCustom = (CraftInventoryCustom)inventory;
                } else {
                    component = inventory.getType().defaultTitle();
                }
                return component;
            }

            public String getTitle() {
                return this.title;
            }

            public String getOriginalTitle() {
                return this.originalTitle;
            }

            public void setTitle(String title) {
                CardboardInventoryView.sendInventoryTitleChange(this, title);
                this.title = title;
            }

            @Nullable
            public MenuType getMenuType() {
                return CraftMenuType.minecraftToBukkit(CraftContainer.getNotchInventoryType(inventory));
            }
        }, player, id);
    }

    public CardboardInventoryView getBukkitView() {
        return (CardboardInventoryView)this.view;
    }

    private int getSize() {
        return this.view.getTopInventory().getSize();
    }

    public boolean isNotRestricted(class_1657 entityhuman) {
        if (this.cachedType == this.view.getType() && this.cachedSize == this.getSize() && this.cachedTitle.equals(this.view.getTitle())) {
            return true;
        }
        boolean typeChanged = this.cachedType != this.view.getType();
        this.cachedType = this.view.getType();
        this.cachedTitle = this.view.getTitle();
        if (this.view.getPlayer() instanceof CraftPlayer) {
            CraftPlayer player = (CraftPlayer)this.view.getPlayer();
            class_3917 type = CraftContainer.getNotchInventoryType(this.view.getTopInventory());
            class_1263 top = ((CraftInventory)this.view.getTopInventory()).getInventory();
            class_1661 bottom = (class_1661)((CraftInventory)this.view.getBottomInventory()).getInventory();
            ((IMixinScreenHandler)((Object)this)).getTrackedStacksBF().clear();
            this.field_7761.clear();
            if (typeChanged) {
                this.setupSlots(top, bottom, (class_1657)player.getHandle());
            }
            int size = this.getSize();
            player.getHandle().field_13987.method_14364((class_2596)new class_3944(this.field_7763, type, class_2561.method_30163((String)this.cachedTitle)));
            player.updateInventory();
        }
        return true;
    }

    public static class_3917 getNotchInventoryType(Inventory inventory) {
        switch (inventory.getType()) {
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case BARREL: {
                switch (inventory.getSize()) {
                    case 9: {
                        return class_3917.field_18664;
                    }
                    case 18: {
                        return class_3917.field_18665;
                    }
                    case 27: {
                        return class_3917.field_17326;
                    }
                    case 36: 
                    case 41: {
                        return class_3917.field_18666;
                    }
                    case 45: {
                        return class_3917.field_18667;
                    }
                    case 54: {
                        return class_3917.field_17327;
                    }
                }
                throw new IllegalArgumentException("Unsupported custom inventory size " + inventory.getSize());
            }
            case WORKBENCH: {
                return class_3917.field_17333;
            }
            case FURNACE: {
                return class_3917.field_17335;
            }
            case DISPENSER: {
                return class_3917.field_17328;
            }
            case ENCHANTING: {
                return class_3917.field_17334;
            }
            case BREWING: {
                return class_3917.field_17332;
            }
            case BEACON: {
                return class_3917.field_17330;
            }
            case ANVIL: {
                return class_3917.field_17329;
            }
            case SMITHING: {
                return class_3917.field_22484;
            }
            case HOPPER: {
                return class_3917.field_17337;
            }
            case DROPPER: {
                return class_3917.field_17328;
            }
            case SHULKER_BOX: {
                return class_3917.field_17341;
            }
            case BLAST_FURNACE: {
                return class_3917.field_17331;
            }
            case LECTERN: {
                return class_3917.field_17338;
            }
            case SMOKER: {
                return class_3917.field_17342;
            }
            case LOOM: {
                return class_3917.field_17339;
            }
            case CARTOGRAPHY: {
                return class_3917.field_17343;
            }
            case GRINDSTONE: {
                return class_3917.field_17336;
            }
            case STONECUTTER: {
                return class_3917.field_17625;
            }
            case CREATIVE: 
            case CRAFTING: 
            case MERCHANT: {
                throw new IllegalArgumentException("Can't open a " + String.valueOf(inventory.getType()) + " inventory!");
            }
        }
        return class_3917.field_17326;
    }

    private void setupSlots(class_1263 top, class_1661 bottom, class_1657 entityhuman) {
        int windowId = -1;
        switch (this.cachedType) {
            case CREATIVE: {
                break;
            }
            case PLAYER: 
            case CHEST: 
            case ENDER_CHEST: 
            case BARREL: {
                this.delegate = new class_1707(class_3917.field_17326, windowId, bottom, top, top.method_5439() / 9);
                break;
            }
            case DISPENSER: 
            case DROPPER: {
                this.delegate = new class_1716(windowId, bottom, top);
                break;
            }
            case FURNACE: {
                this.delegate = new class_3858(windowId, bottom, top, (class_3913)new class_3919(4));
                break;
            }
            case WORKBENCH: 
            case CRAFTING: {
                this.setupWorkbench(top, (class_1263)bottom);
                break;
            }
            case ENCHANTING: {
                this.delegate = new class_1718(windowId, bottom);
                break;
            }
            case BREWING: {
                this.delegate = new class_1708(windowId, bottom, top, (class_3913)new class_3919(2));
                break;
            }
            case HOPPER: {
                this.delegate = new class_1722(windowId, bottom, top);
                break;
            }
            case ANVIL: {
                this.delegate = new class_1706(windowId, bottom);
                break;
            }
            case SMITHING: {
                this.delegate = new class_4862(windowId, bottom);
                break;
            }
            case BEACON: {
                this.delegate = new class_1704(windowId, (class_1263)bottom);
                break;
            }
            case SHULKER_BOX: {
                this.delegate = new class_1733(windowId, bottom, top);
                break;
            }
            case BLAST_FURNACE: {
                this.delegate = new class_3705(windowId, bottom, top, (class_3913)new class_3919(4));
                break;
            }
            case LECTERN: {
                this.delegate = new class_3916(windowId, top, (class_3913)new class_3919(1));
                break;
            }
            case SMOKER: {
                this.delegate = new class_3706(windowId, bottom, top, (class_3913)new class_3919(4));
                break;
            }
            case LOOM: {
                this.delegate = new class_1726(windowId, bottom);
                break;
            }
            case CARTOGRAPHY: {
                this.delegate = new class_3910(windowId, bottom);
                break;
            }
            case GRINDSTONE: {
                this.delegate = new class_3803(windowId, bottom);
                break;
            }
            case STONECUTTER: {
                this.delegate = new class_3971(windowId, bottom);
                break;
            }
            case MERCHANT: {
                this.delegate = new class_1728(windowId, bottom);
            }
        }
        if (this.delegate != null) {
            ((IMixinScreenHandler)((Object)this)).setTrackedStacksBF(((IMixinScreenHandler)this.delegate).getTrackedStacksBF());
            ((IMixinScreenHandler)((Object)this)).cardboard_setSlots((class_2371<class_1735>)this.delegate.field_7761);
            ((IMixinScreenHandler)((Object)this)).cardboard_previousTrackedStacks(((IMixinScreenHandler)this.delegate).cardboard_previousTrackedStacks());
        }
        if (this.cachedType == InventoryType.WORKBENCH) {
            this.delegate = new class_1714(windowId, bottom);
        }
    }

    private void setupWorkbench(class_1263 top, class_1263 bottom) {
        int col;
        int row;
        this.method_7621(new class_1735(top, 0, 124, 35));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.method_7621(new class_1735(top, 1 + col + row * 3, 30 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.method_7621(new class_1735(bottom, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.method_7621(new class_1735(bottom, col, 8 + col * 18, 142));
        }
    }

    public class_1799 method_7601(class_1657 entityhuman, int i) {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.method_7601(entityhuman, i);
    }

    public boolean method_7597(class_1657 entity) {
        return true;
    }

    public class_3917<?> method_17358() {
        return CraftContainer.getNotchInventoryType(this.view.getTopInventory());
    }
}

