/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.components;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_10130;
import net.minecraft.class_2960;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.components.UseCooldownComponent;

@SerializableAs(value="UseCooldown")
public final class CraftUseCooldownComponent
implements UseCooldownComponent {
    private class_10130 handle;

    public CraftUseCooldownComponent(class_10130 cooldown) {
        this.handle = cooldown;
    }

    public CraftUseCooldownComponent(CraftUseCooldownComponent food) {
        this.handle = food.handle;
    }

    public CraftUseCooldownComponent(Map<String, Object> map) {
        Float seconds = SerializableMeta.getObject(Float.class, map, "seconds", false);
        String cooldownGroup = SerializableMeta.getString(map, "cooldown-group", true);
        this.handle = new class_10130(seconds.floatValue(), Optional.ofNullable(cooldownGroup).map(class_2960::method_60654));
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("seconds", Float.valueOf(this.getCooldownSeconds()));
        if (this.getCooldownGroup() != null) {
            result.put("cooldown-group", this.getCooldownGroup().toString());
        }
        return result;
    }

    public class_10130 getHandle() {
        return this.handle;
    }

    public float getCooldownSeconds() {
        return this.handle.comp_3091();
    }

    public void setCooldownSeconds(float cooldown) {
        Preconditions.checkArgument((cooldown > 0.0f ? 1 : 0) != 0, (Object)"cooldown must be greater than 0");
        this.handle = new class_10130(cooldown, this.handle.comp_3092());
    }

    public NamespacedKey getCooldownGroup() {
        return this.handle.comp_3092().map(CraftNamespacedKey::fromMinecraft).orElse(null);
    }

    public void setCooldownGroup(NamespacedKey song) {
        this.handle = new class_10130(this.handle.comp_3091(), Optional.ofNullable(song).map(CraftNamespacedKey::toMinecraft));
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftUseCooldownComponent other = (CraftUseCooldownComponent)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public String toString() {
        return "CraftUseCooldownComponent{handle=" + String.valueOf(this.handle) + "}";
    }
}

