/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.trim;

import com.google.common.base.Preconditions;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2378;
import net.minecraft.class_2588;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8054;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.util.Handleable;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.cardboardpowered.adventure.CardboardAdventure;
import org.jetbrains.annotations.NotNull;

public class CraftTrimMaterial
implements TrimMaterial,
Handleable<class_8054> {
    private final NamespacedKey key;
    private final class_8054 handle;

    public static TrimMaterial minecraftToBukkit(class_8054 minecraft) {
        return (TrimMaterial)CraftRegistry.minecraftToBukkit(minecraft, class_7924.field_42083);
    }

    public static TrimMaterial minecraftHolderToBukkit(class_6880<class_8054> minecraft) {
        return CraftTrimMaterial.minecraftToBukkit((class_8054)minecraft.comp_349());
    }

    public static class_8054 bukkitToMinecraft(TrimMaterial bukkit) {
        return (class_8054)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static class_6880<class_8054> bukkitToMinecraftHolder(TrimMaterial bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        class_2378 registry = CraftRegistry.getMinecraftRegistry(class_7924.field_42083);
        class_6880 registryEntry = registry.method_47983((Object)CraftTrimMaterial.bukkitToMinecraft(bukkit));
        if (registryEntry instanceof class_6880.class_6883) {
            class_6880.class_6883 holder = (class_6880.class_6883)registryEntry;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own trim material without properly registering it.");
    }

    public CraftTrimMaterial(NamespacedKey key, class_8054 handle) {
        this.key = key;
        this.handle = handle;
    }

    @Override
    public class_8054 getHandle() {
        return this.handle;
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public String getTranslationKey() {
        if (!(this.handle.comp_1212().method_10851() instanceof class_2588)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        return ((class_2588)this.handle.comp_1212().method_10851()).method_11022();
    }

    public Component description() {
        return CardboardAdventure.asAdventure(this.handle.comp_1212());
    }
}

