/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.packs;

import java.util.Set;
import java.util.stream.Collectors;
import me.isaiah.common.ICommonMod;
import me.isaiah.common.IDatapack;
import net.minecraft.class_3272;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_6497;
import org.bukkit.FeatureFlag;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftFeatureFlag;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.packs.DataPack;

public class CraftDataPack
implements DataPack {
    private final class_3288 handle;
    private class_3272 resourcePackInfo;
    private IDatapack ipack;

    public CraftDataPack(class_3288 handler) {
        this.handle = handler;
        this.ipack = ICommonMod.getIServer().get_datapack(handler);
        this.resourcePackInfo = this.ipack.get_metadata();
    }

    public IDatapack asICommon() {
        return this.ipack;
    }

    public class_3288 getHandle() {
        return this.handle;
    }

    public String getRawId() {
        return this.asICommon().get_raw_id();
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.getHandle().method_14457());
    }

    public String getDescription() {
        return CraftChatMessage.fromComponent(this.getHandle().method_14459());
    }

    public int getPackFormat() {
        return this.resourcePackInfo.comp_1581();
    }

    public boolean isRequired() {
        return this.asICommon().is_required();
    }

    public DataPack.Compatibility getCompatibility() {
        return switch (this.getHandle().method_14460()) {
            default -> throw new IncompatibleClassChangeError();
            case class_3281.field_14224 -> DataPack.Compatibility.COMPATIBLE;
            case class_3281.field_14220 -> DataPack.Compatibility.NEW;
            case class_3281.field_14223 -> DataPack.Compatibility.OLD;
        };
    }

    public boolean isEnabled() {
        return this.asICommon().is_enabled();
    }

    public DataPack.Source getSource() {
        if (this.getHandle().method_29483() == class_5352.field_25348) {
            return DataPack.Source.BUILT_IN;
        }
        if (this.getHandle().method_29483() == class_5352.field_40048) {
            return DataPack.Source.FEATURE;
        }
        if (this.getHandle().method_29483() == class_5352.field_25349) {
            return DataPack.Source.WORLD;
        }
        if (this.getHandle().method_29483() == class_5352.field_25350) {
            return DataPack.Source.SERVER;
        }
        return DataPack.Source.DEFAULT;
    }

    public Set<FeatureFlag> getRequestedFeatures() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().method_45276()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public NamespacedKey getKey() {
        return NamespacedKey.fromString((String)this.getRawId());
    }

    public String toString() {
        String requestedFeatures = this.getRequestedFeatures().stream().map(featureFlag -> featureFlag.getKey().toString()).collect(Collectors.joining(","));
        return "CraftDataPack{rawId=" + this.getRawId() + ",id=" + String.valueOf(this.getKey()) + ",title=" + this.getTitle() + ",description=" + this.getDescription() + ",packformat=" + this.getPackFormat() + ",compatibility=" + String.valueOf(this.getCompatibility()) + ",source=" + String.valueOf(this.getSource()) + ",enabled=" + this.isEnabled() + ",requestedFeatures=[" + requestedFeatures + "]}";
    }

    public int getMinSupportedPackFormat() {
        return (Integer)this.resourcePackInfo.comp_1582().orElse(new class_6497((Comparable)Integer.valueOf(this.getPackFormat()))).comp_1();
    }

    public int getMaxSupportedPackFormat() {
        return (Integer)this.resourcePackInfo.comp_1582().orElse(new class_6497((Comparable)Integer.valueOf(this.getPackFormat()))).comp_2();
    }
}

